# Prefer Nimble

Prefer Nimble matchers over XCTAssert functions.

* **Identifier:** prefer_nimble
* **Supports autocorrection:** No
* **Kind:** idiomatic
* **Analyzer rule:** No
* **Minimum Swift compiler version:** 3.0.0
* **Default configuration:** warning

## Non Triggering Examples

```swift
expect(foo) == 1
```

```swift
expect(foo).to(equal(1))
```

## Triggering Examples

```swift
↓XCTAssertTrue(foo)
```

```swift
↓XCTAssertEqual(foo, 2)
```

```swift
↓XCTAssertNotEqual(foo, 2)
```

```swift
↓XCTAssertNil(foo)
```

```swift
↓XCTAssert(foo)
```

```swift
↓XCTAssertGreaterThan(foo, 10)
```