/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.abap.jco;

import com.sap.conn.jco.ext.DestinationDataEventListener;
import com.sap.conn.jco.ext.DestinationDataProvider;
import java.util.HashMap;
import java.util.Properties;
import org.conqat.lib.commons.string.StringUtils;

public abstract class JcoDestinationDataProviderBase
implements DestinationDataProvider {
    protected static final String SNC_MODE_ENABLE = "1";
    protected static final String SNC_MODE_DISABLE = "0";
    protected static final String SNC_SSO_ENABLE = "1";
    protected static final String SNC_SSO_DISABLE = "0";
    protected static final String SNC_QOP_AUTHENTICATION_INTEGRITY_PRIVACY = "3";
    private final HashMap<String, Properties> propertiesMap = new HashMap();
    public static final String DEFAULT_DESTINATION = "__DEFAULT__";

    public JcoDestinationDataProviderBase() {
        this.propertiesMap.put(DEFAULT_DESTINATION, new Properties());
    }

    public Properties getDestinationProperties(String destinationName) {
        Properties properties = this.propertiesMap.get(destinationName);
        if (properties == null) {
            properties = new Properties();
            this.propertiesMap.put(destinationName, properties);
        }
        return properties;
    }

    protected void setProperty(String destinationName, String key, String value) {
        Properties properties = this.getDestinationProperties(destinationName);
        if (key == null) {
            return;
        }
        if (StringUtils.isEmpty((String)value)) {
            properties.remove(key);
        } else {
            properties.put(key, value);
        }
    }

    protected void removeProperty(String destinationName, String key) {
        this.setProperty(destinationName, key, null);
    }

    public void setDestinationDataEventListener(DestinationDataEventListener arg0) {
    }

    public boolean supportsEvents() {
        return false;
    }
}

