/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.ext.autolink.internal;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.commonmark.ext.autolink.AutolinkType;
import org.commonmark.node.AbstractVisitor;
import org.commonmark.node.Link;
import org.commonmark.node.Node;
import org.commonmark.node.SourceSpan;
import org.commonmark.node.Text;
import org.commonmark.node.Visitor;
import org.commonmark.parser.PostProcessor;
import org.nibor.autolink.LinkExtractor;
import org.nibor.autolink.LinkSpan;
import org.nibor.autolink.LinkType;
import org.nibor.autolink.Span;

public class AutolinkPostProcessor
implements PostProcessor {
    private final LinkExtractor linkExtractor;

    public AutolinkPostProcessor(Set<AutolinkType> linkTypes) {
        if (linkTypes == null) {
            throw new NullPointerException("linkTypes must not be null");
        }
        if (linkTypes.isEmpty()) {
            throw new IllegalArgumentException("linkTypes must not be empty");
        }
        EnumSet<LinkType> types = EnumSet.noneOf(LinkType.class);
        for (AutolinkType linkType : linkTypes) {
            switch (linkType) {
                case URL: {
                    types.add(LinkType.URL);
                    break;
                }
                case EMAIL: {
                    types.add(LinkType.EMAIL);
                    break;
                }
                case WWW: {
                    types.add(LinkType.WWW);
                }
            }
        }
        this.linkExtractor = LinkExtractor.builder().linkTypes(types).build();
    }

    public Node process(Node node) {
        AutolinkVisitor autolinkVisitor = new AutolinkVisitor();
        node.accept((Visitor)autolinkVisitor);
        return node;
    }

    private void linkify(Text originalTextNode) {
        String literal = originalTextNode.getLiteral();
        Text lastNode = originalTextNode;
        List sourceSpans = originalTextNode.getSourceSpans();
        SourceSpan sourceSpan = sourceSpans.size() == 1 ? (SourceSpan)sourceSpans.get(0) : null;
        Iterator spans = this.linkExtractor.extractSpans((CharSequence)literal).iterator();
        while (spans.hasNext()) {
            Span span = (Span)spans.next();
            if (lastNode == originalTextNode && !spans.hasNext() && !(span instanceof LinkSpan)) {
                return;
            }
            Text textNode = AutolinkPostProcessor.createTextNode(literal, span, sourceSpan);
            if (span instanceof LinkSpan) {
                String destination = AutolinkPostProcessor.getDestination((LinkSpan)span, textNode.getLiteral());
                Link linkNode = new Link(destination, null);
                linkNode.appendChild((Node)textNode);
                linkNode.setSourceSpans(textNode.getSourceSpans());
                lastNode = AutolinkPostProcessor.insertNode((Node)linkNode, (Node)lastNode);
                continue;
            }
            lastNode = AutolinkPostProcessor.insertNode((Node)textNode, (Node)lastNode);
        }
        originalTextNode.unlink();
    }

    private static Text createTextNode(String literal, Span span, SourceSpan sourceSpan) {
        int beginIndex = span.getBeginIndex();
        int endIndex = span.getEndIndex();
        String text = literal.substring(beginIndex, endIndex);
        Text textNode = new Text(text);
        if (sourceSpan != null) {
            textNode.addSourceSpan(sourceSpan.subSpan(beginIndex, endIndex));
        }
        return textNode;
    }

    private static String getDestination(LinkSpan linkSpan, String linkText) {
        LinkType type = linkSpan.getType();
        if (type == LinkType.EMAIL) {
            return "mailto:" + linkText;
        }
        if (type == LinkType.WWW) {
            return "http://" + linkText;
        }
        return linkText;
    }

    private static Node insertNode(Node node, Node insertAfterNode) {
        insertAfterNode.insertAfter(node);
        return node;
    }

    private class AutolinkVisitor
    extends AbstractVisitor {
        int inLink = 0;

        private AutolinkVisitor() {
        }

        public void visit(Link link) {
            ++this.inLink;
            super.visit(link);
            --this.inLink;
        }

        public void visit(Text text) {
            if (this.inLink == 0) {
                AutolinkPostProcessor.this.linkify(text);
            }
        }
    }
}

