/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.abap.AbapConditionalStatementsCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.AbapLanguageFeatureParser;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

@Check(id="cqse-abap-magic-number-usage-check", languages={ELanguage.ABAP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class MagicNumberUsageCheck
extends AbapConditionalStatementsCheckBase {
    private static final ITokenMatcher LITERAL_TOKENS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.STRING_LITERAL, ETokenType.CHARACTER_LITERAL, ETokenType.INTEGER_LITERAL, ETokenType.FLOATING_POINT_LITERAL});
    private static final ITokenMatcher LOGICAL_LINK_OPERATORS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.AND, ETokenType.OR, ETokenType.EQUIV});
    private static final Pattern STRIP_QUOTE_PATTERN = Pattern.compile("^(['`|])(.*)\\1$");
    private static final ETokenType[] SUBSTRING_ACCESS_TOKEN_SEQUENCE = new ETokenType[]{ETokenType.INTEGER_LITERAL, ETokenType.LPAREN, ETokenType.INTEGER_LITERAL, ETokenType.RPAREN};
    @CheckOption(name="Allowed literals", description="Comma seperated list of literal values that are allowed as magic numbers.")
    private Set<String> allowedLiterals = CollectionUtils.asHashSet((Object[])new String[]{"0", "1"});
    @CheckOption(name="Allowed variables", description="Comma seperated list of variable names that are allowed to be compared to magic numbers.")
    private Set<String> allowedVariables = CollectionUtils.asHashSet((Object[])new String[]{"sy-subrc", "sy-tabix", "sy-dbcnt", "sy-ucomm"});

    public void initialize() {
        MagicNumberUsageCheck.normalizeAllowList(this.allowedLiterals, MagicNumberUsageCheck::normalizeLiteral);
        MagicNumberUsageCheck.normalizeAllowList(this.allowedVariables, arg_0 -> ((AbapLanguageFeatureParser)LanguageFeatureParser.ABAP).normalizeVariable(arg_0));
    }

    private static void normalizeAllowList(Set<String> allowList, Function<String, String> normalizer) {
        HashSet<String> allowListCopy = new HashSet<String>(allowList);
        for (String ignoredOperand : allowListCopy) {
            allowList.remove(ignoredOperand);
            allowList.add(normalizer.apply(ignoredOperand));
        }
    }

    @VisibleForTesting
    static String normalizeLiteral(String literal) {
        Matcher matcher = STRIP_QUOTE_PATTERN.matcher(literal);
        return matcher.matches() ? matcher.group(2) : literal;
    }

    @Override
    protected void checkCaseWhenStatements(ShallowEntity caseEntity) {
        List caseOperandTokens = TokenStreamUtils.tokensFromTo((List)caseEntity.ownStartTokens(), (int)1, (ETokenType[])new ETokenType[]{ETokenType.DOT});
        if (caseOperandTokens.stream().anyMatch(token -> this.allowedVariables.contains(LanguageFeatureParser.ABAP.normalizeVariable(token.getText())))) {
            return;
        }
        super.checkCaseWhenStatements(caseEntity);
    }

    @Override
    protected boolean checkCondition(List<IToken> conditionTokens) {
        List<List<IToken>> logicalExpressions = MagicNumberUsageCheck.getLogicalExpressions(conditionTokens);
        return logicalExpressions.stream().anyMatch(this::containsMagicNumbers);
    }

    private static List<List<IToken>> getLogicalExpressions(List<IToken> conditionTokens) {
        ArrayList<List<IToken>> logicalExpressions = new ArrayList<List<IToken>>();
        List conditionalOperators = TokenStreamUtils.findAll(conditionTokens, (ITokenMatcher)LOGICAL_LINK_OPERATORS);
        conditionalOperators.removeIf(operand -> operand - 2 >= 0 && ((IToken)conditionTokens.get(operand - 2)).getType() == ETokenType.BETWEEN);
        if (conditionalOperators.isEmpty()) {
            logicalExpressions.add(conditionTokens);
        } else {
            logicalExpressions.add(conditionTokens.subList(0, (Integer)conditionalOperators.getFirst()));
            for (int i = 1; i < conditionalOperators.size(); ++i) {
                logicalExpressions.add(conditionTokens.subList((Integer)conditionalOperators.get(i - 1), (Integer)conditionalOperators.get(i)));
            }
            logicalExpressions.add(conditionTokens.subList((Integer)conditionalOperators.getLast(), conditionTokens.size()));
        }
        return logicalExpressions;
    }

    private boolean containsMagicNumbers(List<IToken> expressionTokens) {
        if (expressionTokens.stream().anyMatch(this::isIgnoredOperand)) {
            return false;
        }
        return MagicNumberUsageCheck.containsLiteralWithoutSubstringAccess(expressionTokens);
    }

    private boolean isIgnoredOperand(IToken token) {
        if (LITERAL_TOKENS.matches(token)) {
            return this.allowedLiterals.contains(MagicNumberUsageCheck.normalizeLiteral(token.getText()));
        }
        return this.allowedVariables.contains(LanguageFeatureParser.ABAP.normalizeVariable(token.getText())) || this.allowedVariables.contains(LanguageFeatureParser.ABAP.normalizeVariable(StringUtils.getLastPart((String)token.getText(), (String)"-")));
    }

    private static boolean containsLiteralWithoutSubstringAccess(List<IToken> expressionTokens) {
        int index = 0;
        while (index < expressionTokens.size()) {
            if (MagicNumberUsageCheck.isSubstringAccess(expressionTokens, index)) {
                index += SUBSTRING_ACCESS_TOKEN_SEQUENCE.length;
                continue;
            }
            if (LITERAL_TOKENS.matches(expressionTokens.get(index))) {
                return true;
            }
            ++index;
        }
        return false;
    }

    private static boolean isSubstringAccess(List<IToken> expressionTokens, int fromIndex) {
        return TokenStreamUtils.hasTokenTypeSequence(expressionTokens, (int)fromIndex, (ETokenType[])SUBSTRING_ACCESS_TOKEN_SEQUENCE);
    }

    @Override
    void buildFinding(List<IToken> tokens) {
        this.buildFinding("Replace magic numbers with named constants", this.buildLocation().forTokens(tokens)).createAndStore();
    }
}

