/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.base.CommentCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.core.util.CheckUtils;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.lib.commons.markup.MarkupUtils;

@Check(id="cqse-pseudo-comment", languages={ELanguage.ABAP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class PseudoCommentCheck
extends CommentCheckBase {
    @CheckOption(name="Pseudo comments should not be used - Pseudo comment selection", description="Regular expression for selecting pseudo comments, for example 'CI_.*' to match all Code Inspector pseudo comments. Matches only against the pseudo comment name without '\"EC'. If it is specified, the check option 'Use pseudo comment selection as whitelist' specifies whether it is treated as a white list or a black list.If it is not specified, all pseudo comments are reported as finding.")
    private String selectedPseudoCommentsRegex = "";
    @CheckOption(name="Pseudo comments should not be used - Use pseudo comment selection as whitelist", description="If enabled, 'Pseudo comment selection' is treated as white list (all pseudo comments not matching 'Pseudo comment selection' are reported as finding). If not enabled, 'Pseudo comment selection' is treated as black list (all pseudo comments matching 'Pseudo comment selection' are reported as finding).")
    private boolean isWhitelist = false;
    private static final String CHECK_NAME = "Pseudo comments should not be used";
    private static final Pattern PSEUDO_COMMENT_PATTERN = Pattern.compile("^\"#EC\\s+(\\S*)");
    private Pattern selectedPseudoCommentsPattern;

    public void initialize() throws CheckException {
        this.selectedPseudoCommentsPattern = CheckUtils.compilePatternFromCheckOptionRegex((String)this.selectedPseudoCommentsRegex, (String)CHECK_NAME, (String)"pseudo comment selection");
    }

    protected void processComment(IToken token, int startLine, int endLine) throws CheckException {
        String comment = token.getText();
        Matcher commentMatcher = PSEUDO_COMMENT_PATTERN.matcher(comment);
        if (commentMatcher.find() && commentMatcher.start() == 0 && !this.isAllowedPseudoComment(commentMatcher.group(1))) {
            this.buildFinding("Pseudo comment " + MarkupUtils.formatAsSourceCode((String)comment) + " should not be used", this.buildLocation().forLine(startLine)).createAndStore();
        }
    }

    private boolean isAllowedPseudoComment(String comment) {
        if (this.selectedPseudoCommentsPattern == null) {
            return false;
        }
        if (this.selectedPseudoCommentsPattern.matcher(comment).matches()) {
            return this.isWhitelist;
        }
        return !this.isWhitelist;
    }
}

