/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.clike;

import eu.cqse.check.cpp.misra.TokenFilterCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import java.util.EnumSet;

@Check(id="cqse-lowercase-literal-suffix", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.JAVA, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class LowercaseLiteralSuffixCheck
extends TokenFilterCheckBase {
    private static final EnumSet<ETokenType> CHECKED_TOKENTYPES = EnumSet.of(ETokenType.INTEGER_LITERAL, ETokenType.FLOATING_POINT_LITERAL);

    @Override
    protected String getFindingMessage(IToken token) {
        return "Usage of lowercase `L` in literal suffixes is not allowed";
    }

    @Override
    protected boolean isValidToken(IToken token) {
        if (!CHECKED_TOKENTYPES.contains(token.getType())) {
            return true;
        }
        if (token.getText().matches(".*[u]l+$")) {
            return true;
        }
        return !token.getText().contains("l");
    }
}

