/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.core.phase.IExtractedValue;
import eu.cqse.check.framework.core.phase.IGlobalExtractionPhase;
import eu.cqse.check.framework.core.phase.ITokenElementContext;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.test.IndexValueClass;

public class CppSuperclassHierarchyExtractorPhase
implements IGlobalExtractionPhase<SuperclassHierarchyValue, SuperClassAndVirtualDestructorInfo> {
    private static final String SCOPE = "::";

    public List<SuperclassHierarchyValue> extract(ITokenElementContext fileContext) throws CheckException {
        List metaEntities = ShallowEntityTraversalUtils.listEntitiesOfTypeNonRecursive((Collection)fileContext.getRootEntity(ECodeViewOption.FILTERED_PREPROCESSED).getChildren(), (EShallowEntityType)EShallowEntityType.META);
        List<String> usedNamespaces = metaEntities.stream().filter(entity -> entity.getSubtype().equals("using namespace")).map(entity -> entity.getName() + SCOPE).collect(Collectors.toList());
        ArrayList<SuperclassHierarchyValue> superclassHierarchyValues = new ArrayList<SuperclassHierarchyValue>();
        List entities = ShallowEntityTraversalUtils.listEntitiesOfTypeNonRecursive((Collection)fileContext.getRootEntity(ECodeViewOption.FILTERED_PREPROCESSED).getChildren(), (EShallowEntityType)EShallowEntityType.TYPE);
        for (ShallowEntity entity2 : entities) {
            if (!entity2.getSubtype().equals("class")) continue;
            String classNamespace = CppSuperclassHierarchyExtractorPhase.determineNamespace(entity2);
            boolean declaresVirtualDestructor = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)entity2.getChildren(), (EShallowEntityType)EShallowEntityType.METHOD).stream().anyMatch(methodEntity -> (methodEntity.getSubtype().equals("destructor") || methodEntity.getSubtype().equals("destructor declaration")) && LanguageFeatureParser.CPP.isVirtual(methodEntity));
            List<String> superClasses = CppSuperclassHierarchyExtractorPhase.extractSuperclasses(entity2, usedNamespaces);
            for (String superclass : superClasses) {
                superclassHierarchyValues.add(new SuperclassHierarchyValue(fileContext.getUniformPath(), CppSuperclassHierarchyExtractorPhase.trimNamespaces(superclass), new SuperClassAndVirtualDestructorInfo()));
            }
            superclassHierarchyValues.add(new SuperclassHierarchyValue(fileContext.getUniformPath(), classNamespace + entity2.getName(), new SuperClassAndVirtualDestructorInfo(superClasses, declaresVirtualDestructor)));
        }
        return superclassHierarchyValues;
    }

    private static String determineNamespace(ShallowEntity entity) {
        ArrayList<String> classNamespaces = new ArrayList<String>();
        for (ShallowEntity parent = entity.getParent(); parent != null; parent = parent.getParent()) {
            if (!parent.getSubtype().equals("namespace")) continue;
            classNamespaces.add(parent.getName());
        }
        Collections.reverse(classNamespaces);
        Object classNamespace = String.join((CharSequence)SCOPE, classNamespaces);
        if (!((String)classNamespace).isEmpty()) {
            classNamespace = (String)classNamespace + SCOPE;
        }
        return classNamespace;
    }

    private static List<String> extractSuperclasses(ShallowEntity entity, List<String> usingNamespaces) {
        UnmodifiableList entityStartTokens = entity.ownStartTokens();
        int colonIndex = TokenStreamUtils.firstTokenMatching((List)entityStartTokens, (ITokenMatcher)ETokenType.COLON);
        if (colonIndex == -1) {
            return Collections.emptyList();
        }
        ArrayList<String> superClasses = new ArrayList<String>();
        List superclassDeclarations = TokenStreamUtils.split(entityStartTokens.subList(colonIndex, entityStartTokens.size() - 1), (ETokenType[])new ETokenType[]{ETokenType.COMMA});
        for (List superclassDeclaration : superclassDeclarations) {
            List identifiers = TokenStreamUtils.findAllTokens((List)superclassDeclaration, (ITokenMatcher)ETokenType.IDENTIFIER);
            if (identifiers.isEmpty()) continue;
            StringBuilder superclassNamespace = new StringBuilder();
            String superclassName = ((IToken)identifiers.removeLast()).getText();
            for (IToken identifier : identifiers) {
                superclassNamespace.append(identifier.getText()).append(SCOPE);
            }
            superClasses.add(String.valueOf(superclassNamespace) + superclassName);
            for (String usingNamespace : usingNamespaces) {
                superClasses.add(usingNamespace + superclassName);
            }
        }
        return superClasses;
    }

    private static String trimNamespaces(String classWithNamespaces) {
        String[] splitNames = classWithNamespaces.split(SCOPE);
        return splitNames[splitNames.length - 1];
    }

    public SuperclassHierarchyValue createValue(String uniformPath, String value, SuperClassAndVirtualDestructorInfo additionalInformation) {
        return new SuperclassHierarchyValue(uniformPath, value, additionalInformation);
    }

    public boolean needsAccessByValue() {
        return true;
    }

    public EnumSet<ELanguage> getLanguages() {
        return EnumSet.of(ELanguage.CPP, ELanguage.CPP_MS_CLI);
    }

    public EnumSet<ECheckParameter> getRequiredContextParameters() {
        return EnumSet.of(ECheckParameter.ABSTRACT_SYNTAX_TREE);
    }

    @IndexValueClass
    public static class SuperclassHierarchyValue
    implements IExtractedValue<SuperClassAndVirtualDestructorInfo> {
        private final String className;
        private final String uniformPath;
        private final SuperClassAndVirtualDestructorInfo superClassAndVirtualDestructorInfo;

        private SuperclassHierarchyValue(String uniformPath, String className, SuperClassAndVirtualDestructorInfo superClassAndVirtualDestructorInfo) {
            this.className = className;
            this.uniformPath = uniformPath;
            this.superClassAndVirtualDestructorInfo = superClassAndVirtualDestructorInfo;
        }

        public String getUniformPath() {
            return this.uniformPath;
        }

        public String getValue() {
            return this.className;
        }

        public SuperClassAndVirtualDestructorInfo getAdditionalInformation() {
            return this.superClassAndVirtualDestructorInfo;
        }
    }

    @IndexValueClass
    public static class SuperClassAndVirtualDestructorInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final List<String> superClasses;
        private final boolean hasAnySubClass;
        private final boolean declaresVirtualDestructor;

        public SuperClassAndVirtualDestructorInfo(List<String> superClasses, boolean declaresVirtualDestructor) {
            this.superClasses = superClasses;
            this.declaresVirtualDestructor = declaresVirtualDestructor;
            this.hasAnySubClass = false;
        }

        public SuperClassAndVirtualDestructorInfo() {
            this.hasAnySubClass = true;
            this.superClasses = Collections.emptyList();
            this.declaresVirtualDestructor = false;
        }

        public boolean hasVirtualDestructor() {
            return this.declaresVirtualDestructor;
        }

        public List<String> getSuperClasses() {
            return this.superClasses;
        }

        public boolean hasSubClass() {
            return this.hasAnySubClass;
        }
    }
}

