/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp.clang.base;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.util.clang.ClangTranslationUnitWrapper;
import eu.cqse.check.util.clang.visitors.FindingCollectingClangCursorVisitorBase;
import eu.cqse.clang.CXCursor;
import eu.cqse.clang.ClangBinding;
import eu.cqse.clang.IClangCursorVisitor;
import eu.cqse.clang.SWIGTYPE_p_CXTranslationUnitImpl;
import java.util.List;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.lib.commons.collections.Pair;

public abstract class ClangCursorVisitorCheckBase
extends CheckImplementationBase {
    public void execute() throws CheckException {
        if (EFeatureToggle.DISABLE_CLANG_JNI_CHECKS.isEnabled()) {
            return;
        }
        try (ClangTranslationUnitWrapper clangTranslationUnitWrapper = this.context.getClangTranslationUnitWrapper();){
            List<Pair<TextRegionLocation, String>> findings = this.runVisitorAndGetFindings(clangTranslationUnitWrapper);
            for (Pair<TextRegionLocation, String> finding : findings) {
                this.buildFinding((String)finding.getSecond(), this.buildLocation().betweenOffsets(((TextRegionLocation)finding.getFirst()).getRawStartOffset(), ((TextRegionLocation)finding.getFirst()).getRawEndOffset(), ECodeViewOption.ETextViewOption.FILTERED_CONTENT)).createAndStore();
            }
        }
    }

    private List<Pair<TextRegionLocation, String>> runVisitorAndGetFindings(ClangTranslationUnitWrapper translationUnitWrapper) throws CheckException {
        SWIGTYPE_p_CXTranslationUnitImpl mainTranslationUnit = translationUnitWrapper.getMainTranslationUnit();
        CXCursor rootCursor = translationUnitWrapper.getMainRootCursor();
        String fileText = this.context.getTextContent(ECodeViewOption.ETextViewOption.FILTERED_CONTENT);
        FindingCollectingClangCursorVisitorBase visitor = this.createVisitor(mainTranslationUnit, this.context.getUniformPath(), fileText);
        ClangBinding.visitChildren((CXCursor)rootCursor, (IClangCursorVisitor)visitor);
        return visitor.getFindings();
    }

    protected abstract FindingCollectingClangCursorVisitorBase createVisitor(SWIGTYPE_p_CXTranslationUnitImpl var1, String var2, String var3);
}

