/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp.misra.switches;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.SwitchStatementUtils;
import java.util.Collection;
import java.util.List;

@Check(id="cqse-switch-clause-number", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class SwitchClauseNumberCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List allEntities = ShallowEntityTraversalUtils.getAllEntities((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()));
        for (ShallowEntity entity : allEntities) {
            if (!"switch".equals(entity.getSubtype())) continue;
            this.processEntity(entity);
        }
    }

    protected ECodeViewOption getCodeViewOption() {
        return ECodeViewOption.FILTERED_PREPROCESSED;
    }

    private void processEntity(ShallowEntity entity) {
        int validCases = 0;
        boolean previousWasCase = false;
        for (ShallowEntity shallowEntity : entity.getChildren()) {
            boolean isCaseOrDefault = SwitchStatementUtils.isCaseOrDefault((ShallowEntity)shallowEntity);
            if (!previousWasCase && isCaseOrDefault) {
                ++validCases;
            }
            previousWasCase = isCaseOrDefault;
        }
        if (validCases < 2) {
            this.buildFinding("`switch` has only one possible execution path", this.buildLocation().forEntity(entity)).createAndStore();
        }
    }
}

