/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cs;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;

@Check(id="cqse-dynamic-keyword", languages={ELanguage.CS}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class DynamicKeywordCheck
extends CheckImplementationBase {
    private static final String MICROSOFT_OFFICE_INTEROP = "Microsoft.Office.Interop";

    public void execute() throws CheckException {
        List entities = ShallowEntityTraversalUtils.listAllEntities((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()));
        if (this.ignoreFile(entities)) {
            return;
        }
        for (ShallowEntity entity : entities) {
            if (!TokenStreamUtils.contains((List)entity.ownStartTokens(), (ETokenType)ETokenType.DYNAMIC)) continue;
            this.buildFinding(this.getFindingMessage(entity), this.buildLocation().forEntity(entity)).createAndStore();
        }
    }

    private boolean ignoreFile(List<ShallowEntity> entities) {
        for (ShallowEntity entity : entities) {
            if (entity.getType() != EShallowEntityType.META || !entity.getSubtype().equals("using") || !TokenStreamTextUtils.concatTokenTexts((List)entity.includedTokens()).contains(MICROSOFT_OFFICE_INTEROP)) continue;
            return true;
        }
        return false;
    }

    private String getFindingMessage(ShallowEntity entity) {
        return "Avoid `dynamic` on " + entity.getName();
    }
}

