/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.ECheckTarget;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.typetracker.java.JavaImportSensitiveTypeResolver;
import eu.cqse.check.framework.util.JavaMethodCallMatcher;
import eu.cqse.check.framework.util.clike.CLikeCheckUtils;

@Check(id="java:S5958", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE, ECheckParameter.TYPE_RESOLUTION}, target={ECheckTarget.TEST_CODE})
public class IncorrectAssertJAssertThrownCheck
extends CheckImplementationBase {
    private static final JavaMethodCallMatcher ASSERT_THAT_THROWN_BY_CALLS = JavaMethodCallMatcher.create().onTypes(new String[]{"org.assertj.core.api.Assertions"}).withTargetMethodNames(new String[]{"assertThatThrownBy"});

    public void execute() throws CheckException {
        ShallowEntity rootEntity = this.context.getRootEntity(this.getCodeViewOption());
        JavaImportSensitiveTypeResolver typeResolver = new JavaImportSensitiveTypeResolver(rootEntity);
        for (JavaMethodCallMatcher.MethodCall assertCall : ASSERT_THAT_THROWN_BY_CALLS.find(this.context, typeResolver)) {
            boolean doesCallChainRemainAccessible = CLikeCheckUtils.isReturnStatementOrVariableDeclaration((ShallowEntity)assertCall.entity());
            if (doesCallChainRemainAccessible || !assertCall.findChainedCalls().isEmpty()) continue;
            this.buildFinding("Test further the exception raised by this `assertThatThrownBy` call", this.buildLocation().forToken(assertCall.token())).createAndStore();
        }
    }
}

