/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink;

import eu.cqse.check.simulink.ESimulinkNameCheckType;
import eu.cqse.check.simulink.ESimulinkReservedNameType;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

public class SimulinkNameChecker {
    private static final Set<String> RESERVED_MATLAB_KEYWORDS = CollectionUtils.asHashSet((Object[])new String[]{"break", "case", "catch", "classdef", "continue", "else", "elseif", "end", "for", "function", "global", "if", "otherwise", "parfor", "persistent", "return", "spmd", "switch", "try", "while"});
    private static final Set<String> RESERVED_C_KEYWORDS = CollectionUtils.asHashSet((Object[])new String[]{"auto", "double", "int", "struct", "break", "else", "long", "switch", "case", "enum", "register", "typedef", "char", "extern", "return", "union", "const", "float", "short", "unsigned", "continue", "for", "signed", "void", "default", "goto", "sizeof", "volatile", "do", "if", "static", "while"});
    private static final Set<String> RESERVED_CPP_KEYWORDS = CollectionUtils.asHashSet((Object[])new String[]{"catch", "friend", "protected", "try", "class", "inline", "public", "typeid", "const_cast", "mutable", "reinterpret_cast", "typename", "delete", "namespace", "static_cast", "using", "dynamic_cast", "new", "template", "virtual", "explicit", "operator", "this", "wchar_t", "export", "private", "throw"});
    private static final Set<String> RESERVED_CODE_GENERATION_KEYWORDS = CollectionUtils.asHashSet((Object[])new String[]{"abs", "int8_t", "rtinf", "asm", "int16_t", "rtminusinf", "bool", "int32_t", "rtnan", "boolean_t", "int64_t", "max_uint64_t", "seedfilebuffer", "byte_t", "integer_code", "seedfilebufferlen", "char_t", "link_data_buffer_size", "single", "cint8_t", "link_data_stream", "tid01eq", "cint16_t", "localb", "min_int64_t", "time_t", "cint32_t", "localc", "model", "true", "creal_t", "localdwork", "mt", "uint_t", "creal32_t", "localp", "ncstates", "uint8_t", "creal64_t", "localx", "null", "uint16_t", "cuint8_t", "localxdis", "numst", "uint32_t", "cuint16_t", "localxdot", "pointer_t", "uint64_t", "cuint32_t", "localzce", "profiling_enabled", "unused_parameter", "ert", "localzcsv", "profiling_num_samples", "use_rtmodel", "false", "matrix", "real_t", "vcast_flush_data", "fortran", "real32_t", "vector", "havestdio", "real64_t", "id_t", "rt", "int_t", "max_int64_t", "rt_malloc"});
    public static final Set<String> MATLAB_FUNCTION_NAMES = SimulinkNameChecker.getKnownMatlabFunctionNames();
    private static final String FILE_CONTAINING_MATLAB_FUNCTION_NAMES = "/eu/cqse/check/simulink/matlab/matlab-functions.txt";
    private static final Character UNDERSCORE = Character.valueOf('_');
    private static final String CONSECUTIVE_UNDERSCORES = "__";
    private static final Logger LOGGER = LogManager.getLogger();

    public static ESimulinkReservedNameType getNameType(String name) {
        if (RESERVED_MATLAB_KEYWORDS.contains(name)) {
            return ESimulinkReservedNameType.RESERVED_MATLAB_KEYWORD;
        }
        if (RESERVED_C_KEYWORDS.contains(name)) {
            return ESimulinkReservedNameType.RESERVED_C_KEYWORD;
        }
        if (RESERVED_CPP_KEYWORDS.contains(name)) {
            return ESimulinkReservedNameType.RESERVED_CPP_KEYWORD;
        }
        if (RESERVED_CODE_GENERATION_KEYWORDS.contains(name)) {
            return ESimulinkReservedNameType.RESERVED_CODE_GENERATION_KEYWORD;
        }
        if (MATLAB_FUNCTION_NAMES.contains(name)) {
            return ESimulinkReservedNameType.RESERVED_MATLAB_FUNCTION_NAME;
        }
        return ESimulinkReservedNameType.NON_RESERVED_NAME;
    }

    private static boolean isReservedKeyword(String name) {
        ESimulinkReservedNameType reservedNameType = SimulinkNameChecker.getNameType(name);
        return reservedNameType == ESimulinkReservedNameType.RESERVED_MATLAB_KEYWORD || reservedNameType == ESimulinkReservedNameType.RESERVED_C_KEYWORD || reservedNameType == ESimulinkReservedNameType.RESERVED_CPP_KEYWORD || reservedNameType == ESimulinkReservedNameType.RESERVED_CODE_GENERATION_KEYWORD;
    }

    private static boolean isMatlabFunctionName(String name) {
        ESimulinkReservedNameType reservedNameType = SimulinkNameChecker.getNameType(name);
        return reservedNameType == ESimulinkReservedNameType.RESERVED_MATLAB_FUNCTION_NAME;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static HashSet<String> getKnownMatlabFunctionNames() {
        Object knownMatlabFunctions = CollectionUtils.emptyList();
        Class<SimulinkNameChecker> checkClass = SimulinkNameChecker.class;
        try (InputStream inputStream = checkClass.getResourceAsStream(FILE_CONTAINING_MATLAB_FUNCTION_NAMES);){
            if (inputStream == null) {
                LOGGER.error("Could not read file /eu/cqse/check/simulink/matlab/matlab-functions.txt to retrieve MATLAB function names. " + checkClass.getSimpleName() + " won't use them during evaluation");
                HashSet<String> hashSet = new HashSet<String>();
                return hashSet;
            }
            String knownMatlabFunctionAsString = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8).toLowerCase();
            knownMatlabFunctions = StringUtils.splitLinesAsList((String)knownMatlabFunctionAsString);
            return new HashSet<String>((Collection<String>)knownMatlabFunctions);
        }
        catch (IOException e) {
            LOGGER.error("Could not read file /eu/cqse/check/simulink/matlab/matlab-functions.txt to retrieve MATLAB function names. " + checkClass.getSimpleName() + " won't use them during evaluation", (Throwable)e);
        }
        return new HashSet<String>((Collection<String>)knownMatlabFunctions);
    }

    public static Set<ESimulinkNameCheckType> createTypesToCheckSetFromConfigurations(boolean disallowNonAlphanumericCharacters, boolean disallowStartWithNumbers, boolean disallowConsecutiveUnderscores, boolean disallowStartWithUnderscore, boolean disallowEndWithUnderscore, boolean disallowReservedMatlabKeyword, boolean disallowMatlabFunctionName) {
        HashSet<ESimulinkNameCheckType> typesToCheck = new HashSet<ESimulinkNameCheckType>();
        if (disallowReservedMatlabKeyword) {
            typesToCheck.add(ESimulinkNameCheckType.NAME_IS_RESERVED_MATLAB_KEYWORD);
        }
        if (disallowMatlabFunctionName) {
            typesToCheck.add(ESimulinkNameCheckType.NAME_IS_MATLAB_FUNCTION_NAME);
        }
        if (disallowNonAlphanumericCharacters) {
            typesToCheck.add(ESimulinkNameCheckType.ALPHANUMERIC_CHARACTER_USAGE);
        }
        if (disallowStartWithNumbers) {
            typesToCheck.add(ESimulinkNameCheckType.NAME_STARTS_WITH_NUMBER);
        }
        if (disallowConsecutiveUnderscores) {
            typesToCheck.add(ESimulinkNameCheckType.CONSECUTIVE_UNDERSCORES_USAGE);
        }
        if (disallowStartWithUnderscore) {
            typesToCheck.add(ESimulinkNameCheckType.NAME_STARTS_WITH_UNDERSCORE);
        }
        if (disallowEndWithUnderscore) {
            typesToCheck.add(ESimulinkNameCheckType.NAME_ENDS_WITH_UNDERSCORE);
        }
        return typesToCheck;
    }

    public static List<ESimulinkNameCheckType> checkName(String name, Set<ESimulinkNameCheckType> nameCheckTypesToCheck, String whitelist) {
        ArrayList<ESimulinkNameCheckType> failedCheckTypes = new ArrayList<ESimulinkNameCheckType>();
        if (name == null || name.isEmpty() || whitelist.contains(name)) {
            return failedCheckTypes;
        }
        if (!SimulinkNameChecker.isAlphanumeric(name, true)) {
            failedCheckTypes.add(ESimulinkNameCheckType.ALPHANUMERIC_CHARACTER_USAGE);
        }
        if (SimulinkNameChecker.nameStartsWithDigit(name)) {
            failedCheckTypes.add(ESimulinkNameCheckType.NAME_STARTS_WITH_NUMBER);
        }
        if (name.contains(CONSECUTIVE_UNDERSCORES)) {
            failedCheckTypes.add(ESimulinkNameCheckType.CONSECUTIVE_UNDERSCORES_USAGE);
        }
        if (name.startsWith(UNDERSCORE.toString())) {
            failedCheckTypes.add(ESimulinkNameCheckType.NAME_STARTS_WITH_UNDERSCORE);
        }
        if (name.endsWith(UNDERSCORE.toString())) {
            failedCheckTypes.add(ESimulinkNameCheckType.NAME_ENDS_WITH_UNDERSCORE);
        }
        if (SimulinkNameChecker.isReservedKeyword(name)) {
            failedCheckTypes.add(ESimulinkNameCheckType.NAME_IS_RESERVED_MATLAB_KEYWORD);
        }
        if (SimulinkNameChecker.isMatlabFunctionName(name)) {
            failedCheckTypes.add(ESimulinkNameCheckType.NAME_IS_MATLAB_FUNCTION_NAME);
        }
        return failedCheckTypes.stream().filter(nameCheckTypesToCheck::contains).collect(Collectors.toList());
    }

    private static boolean nameStartsWithDigit(String name) {
        return Character.isDigit(name.charAt(0));
    }

    private static boolean isAlphanumeric(String name, boolean allowUnderscores) {
        if (allowUnderscores) {
            return name.matches("[A-Za-z_0-9]+");
        }
        return name.matches("[A-Za-z0-9]+");
    }
}

