/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.font_settings;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.simulink.font_settings.SimulinkFontChecker;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.ParameterizedElement;
import org.conqat.lib.simulink.model.SimulinkAnnotation;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkInPort;
import org.conqat.lib.simulink.model.SimulinkLine;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkOutPort;
import org.conqat.lib.simulink.model.SimulinkPortBase;
import org.conqat.lib.simulink.model.stateflow.StateflowBlock;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowTransition;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.conqat.lib.simulink.util.StateflowUtils;
import org.jspecify.annotations.NonNull;

@Check(id="cqse.jmaab.db_0043", languages={ELanguage.SIMULINK})
public class SimulinkAndStateflowFontSettingsCheck
extends CheckImplementationBase {
    public static final Function<SimulinkInPort, String> BLOCK_IDENTIFIER_EXTRACTOR = port -> port.getBlock().getName() + port.getBlock().getParameter("SID");
    public static final Comparator<SimulinkLine> LINE_BY_DST_PORT_COMPARATOR = Comparator.comparing(SimulinkLine::getDstPort, Comparator.nullsFirst(Comparator.comparing(BLOCK_IDENTIFIER_EXTRACTOR).thenComparing(SimulinkPortBase::getIndex)));
    private static final String ACTUAL_SETTINGS_FINDING_PROPERTY_NAME = "Actual settings";
    private static final String NOT_SET = "not set";
    @CheckOption(name="Expected font settings for Simulink blocks", description="Specifies the expected font settings for blocks. DEFAULT means that the model default is used. ANY means that any setting is ok. Possible values for Angle: DEFAULT, ANY, NORMAL, ITALIC. Possible values for Weight: DEFAULT, ANY, NORMAL, BOLD.")
    private String blockSettingsParameter = "Name: DEFAULT, Size: DEFAULT, Angle: DEFAULT, Weight: DEFAULT";
    private FontSettings globalExpectedBlockSettings = null;
    @CheckOption(name="Expected font settings for Simulink lines", description="Specifies the expected font settings for blocks. DEFAULT means that the model default is used. ANY means that any setting is ok. Possible values for Angle: DEFAULT, ANY, NORMAL, ITALIC. Possible values for Weight: DEFAULT, ANY, NORMAL, BOLD.")
    private String lineSettingsParameter = "Name: DEFAULT, Size: DEFAULT, Angle: DEFAULT, Weight: DEFAULT";
    private FontSettings globalExpectedLineSettings = null;
    @CheckOption(name="Expected font settings for Stateflow nodes", description="Specifies the expected font settings for Stateflow nodes. ANY means that any setting is ok. Possible values for Angle: DEFAULT, ANY, NORMAL, ITALIC. Possible values for Weight: DEFAULT, ANY, NORMAL, BOLD.")
    private String nodeSettingsParameter = "Name: Arial, Size: 12pt, Angle: NORMAL, Weight: NORMAL";
    private FontSettings globalExpectedNodeSettings = null;
    @CheckOption(name="Expected font settings for Stateflow transitions", description="Specifies the expected font settings for Stateflow transitions. ANY means that any setting is ok. Possible values for Angle: DEFAULT, ANY, NORMAL, ITALIC. Possible values for Weight: DEFAULT, ANY, NORMAL, BOLD.")
    private String transitionSettingsParameter = "Name: Arial, Size: 12pt, Angle: NORMAL, Weight: NORMAL";
    private FontSettings globalExpectedTransitionSettings = null;
    @CheckOption(name="Expected font settings for annotations", description="Specifies the expected font settings for annotations. ANY means that any setting is ok. Possible values for Angle: DEFAULT, ANY, NORMAL, ITALIC. Possible values for Weight: DEFAULT, ANY, NORMAL, BOLD.")
    private String annotationSettingsParameter = "Name: DEFAULT, Size: DEFAULT, Angle: NORMAL, Weight: NORMAL";
    private FontSettings globalExpectedAnnotationSettings = null;
    private SimulinkFontChecker simulinkFontChecker;

    public void initialize() throws CheckException {
        super.initialize();
        this.globalExpectedBlockSettings = new FontSettings(this.blockSettingsParameter);
        this.globalExpectedLineSettings = new FontSettings(this.lineSettingsParameter);
        this.globalExpectedNodeSettings = new FontSettings(this.nodeSettingsParameter);
        this.globalExpectedTransitionSettings = new FontSettings(this.transitionSettingsParameter);
        this.globalExpectedAnnotationSettings = new FontSettings(this.annotationSettingsParameter);
    }

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        this.simulinkFontChecker = new SimulinkFontChecker(model);
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            for (SimulinkAnnotation annotation : block.getAnnotations()) {
                this.checkAnnotationFontSettings(annotation);
            }
            if ("Model".equals(block.getType())) continue;
            this.checkBlockFontSettings(block);
        }
        this.checkSimulinkLinesFontSettings(model);
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            if (!block.isStateflowChartBlock()) continue;
            StateflowChart chart = ((StateflowBlock)block).getChart();
            this.checkStateflowNodeFontPropertiesInChart(block, chart);
            this.checkStateflowTransitionFontPropertiesInChart(block, chart);
        }
    }

    private void checkSimulinkLinesFontSettings(SimulinkModel model) {
        ListMap findingLinesPerSourcePort = new ListMap();
        for (SimulinkLine line2 : model.getContainedLinesRecursively(false, false)) {
            if (!this.lineNeedsFinding(line2)) continue;
            if (line2.getSrcPort() == null) {
                this.reportFindingForLine(line2);
                continue;
            }
            findingLinesPerSourcePort.add((Object)line2.getSrcPort(), (Object)line2);
        }
        for (SimulinkOutPort srcPort : findingLinesPerSourcePort.getKeys()) {
            List lines = (List)findingLinesPerSourcePort.getCollection((Object)srcPort);
            Optional<SimulinkLine> findingLine = lines.stream().filter(line -> line.getDstPort() != null).min(LINE_BY_DST_PORT_COMPARATOR);
            if (findingLine.isEmpty()) {
                for (SimulinkLine line3 : lines) {
                    this.reportFindingForLine(line3);
                }
                continue;
            }
            this.reportFindingForLine(findingLine.get());
        }
    }

    private void reportFindingForLine(SimulinkLine line) {
        FindingPropertyList properties = SimulinkAndStateflowFontSettingsCheck.generateFindingProperties(this.globalExpectedLineSettings);
        properties.addProperty(ACTUAL_SETTINGS_FINDING_PROPERTY_NAME, (Object)SimulinkFontChecker.generateActualSettingsFindingsProperty((ParameterizedElement)line));
        this.buildFinding("Line font settings differ from default settings", (ElementLocation)this.buildLocation().forSimulinkLine(line)).addFindingProperties(properties).createAndStore();
    }

    private void checkBlockFontSettings(SimulinkBlock block) {
        if (!this.simulinkFontChecker.simulinkFontSettingsAreCorrect((ParameterizedElement)block, this.globalExpectedBlockSettings)) {
            FindingPropertyList properties = SimulinkAndStateflowFontSettingsCheck.generateFindingProperties(this.globalExpectedBlockSettings);
            properties.addProperty(ACTUAL_SETTINGS_FINDING_PROPERTY_NAME, (Object)SimulinkFontChecker.generateActualSettingsFindingsProperty((ParameterizedElement)block));
            this.buildFinding("Block font settings differ from default settings", (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(properties).createAndStore();
        }
    }

    private void checkAnnotationFontSettings(SimulinkAnnotation annotation) {
        if (!this.simulinkFontChecker.simulinkFontSettingsAreCorrect((ParameterizedElement)annotation, this.globalExpectedAnnotationSettings)) {
            FindingPropertyList properties = SimulinkAndStateflowFontSettingsCheck.generateFindingProperties(this.globalExpectedAnnotationSettings);
            properties.addProperty(ACTUAL_SETTINGS_FINDING_PROPERTY_NAME, (Object)SimulinkFontChecker.generateActualSettingsFindingsProperty((ParameterizedElement)annotation));
            this.buildFinding("Annotation font settings differ from default settings", (ElementLocation)this.buildLocation().forSimulinkAnnotation(annotation)).addFindingProperties(properties).createAndStore();
        }
    }

    private boolean lineNeedsFinding(SimulinkLine line) {
        if (!SimulinkUtils.isUserVisible((SimulinkLine)line)) {
            return false;
        }
        String explicitlySetSignal = line.getParameter("Name");
        if (explicitlySetSignal == null) {
            return false;
        }
        return !this.simulinkFontChecker.simulinkFontSettingsAreCorrect((ParameterizedElement)line, this.globalExpectedLineSettings);
    }

    private void checkStateflowNodeFontPropertiesInChart(SimulinkBlock block, StateflowChart chart) {
        Optional<String> actualFontName = Optional.ofNullable(chart.getParameter("stateFontS.fontName"));
        String actualFontWeight = Optional.ofNullable(chart.getParameter("stateFontS.fontWeight")).orElse("normal");
        String actualFontAngle = Optional.ofNullable(chart.getParameter("stateFontS.fontAngle")).orElse("normal");
        Optional<String> defaultFontSize = Optional.ofNullable(chart.getParameter("stateFontS.defaultFontSize"));
        if (SimulinkAndStateflowFontSettingsCheck.isPresentAndDifferentThan(actualFontName.orElse(null), this.globalExpectedNodeSettings.name) || SimulinkAndStateflowFontSettingsCheck.isPresentAndDifferentThan(actualFontAngle, this.globalExpectedNodeSettings.angle) || SimulinkAndStateflowFontSettingsCheck.isPresentAndDifferentThan(actualFontWeight, this.globalExpectedNodeSettings.weight) || SimulinkAndStateflowFontSettingsCheck.isPresentAndDifferentThanFontSize(defaultFontSize.orElse(null), this.globalExpectedNodeSettings.size)) {
            FindingPropertyList properties = SimulinkAndStateflowFontSettingsCheck.generateFindingProperties(this.globalExpectedNodeSettings);
            properties.addProperty(ACTUAL_SETTINGS_FINDING_PROPERTY_NAME, (Object)SimulinkAndStateflowFontSettingsCheck.generateActualSettingsFindingsPropertyForStateflowFont(actualFontName.orElse(NOT_SET), defaultFontSize.orElse(NOT_SET), actualFontAngle, actualFontWeight));
            this.buildFinding("Chart font settings for nodes differ from default settings", (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(properties).createAndStore();
        }
        for (StateflowNodeBase node : StateflowUtils.listNodesRecursively((StateflowChart)chart, (boolean)false)) {
            String actualSize = node.getParameter("fontSize");
            if (!SimulinkAndStateflowFontSettingsCheck.isPresentAndDifferentThanFontSize(actualSize, this.globalExpectedNodeSettings.size)) continue;
            FindingPropertyList properties = SimulinkAndStateflowFontSettingsCheck.generateFindingPropertiesForStateflowSize(this.globalExpectedTransitionSettings, actualSize, block.getModel().getLineDefaultParameter("FontSize"));
            this.buildFinding("Node font size differs from default settings", (ElementLocation)this.buildLocation().forStateflowNode(node)).addFindingProperties(properties).createAndStore();
        }
    }

    private void checkStateflowTransitionFontPropertiesInChart(SimulinkBlock block, StateflowChart chart) {
        Optional<String> actualFontName = Optional.ofNullable(chart.getParameter("transitionFontS.fontName"));
        String actualFontWeight = Optional.ofNullable(chart.getParameter("transitionFontS.fontWeight")).orElse("normal");
        String actualFontAngle = Optional.ofNullable(chart.getParameter("transitionFontS.fontAngle")).orElse("normal");
        Optional<String> defaultFontSize = Optional.ofNullable(chart.getParameter("transitionFontS.defaultFontSize"));
        if (SimulinkAndStateflowFontSettingsCheck.isPresentAndDifferentThan(actualFontName.orElse(null), this.globalExpectedTransitionSettings.name) || SimulinkAndStateflowFontSettingsCheck.isPresentAndDifferentThan(actualFontAngle, this.globalExpectedTransitionSettings.angle) || SimulinkAndStateflowFontSettingsCheck.isPresentAndDifferentThan(actualFontWeight, this.globalExpectedTransitionSettings.weight) || SimulinkAndStateflowFontSettingsCheck.isPresentAndDifferentThanFontSize(defaultFontSize.orElse(null), this.globalExpectedTransitionSettings.size)) {
            FindingPropertyList properties = SimulinkAndStateflowFontSettingsCheck.generateFindingProperties(this.globalExpectedTransitionSettings);
            properties.addProperty(ACTUAL_SETTINGS_FINDING_PROPERTY_NAME, (Object)SimulinkAndStateflowFontSettingsCheck.generateActualSettingsFindingsPropertyForStateflowFont(actualFontName.orElse(NOT_SET), defaultFontSize.orElse(NOT_SET), actualFontAngle, actualFontWeight));
            this.buildFinding("Chart font settings for transitions differ from default settings", (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(properties).createAndStore();
        }
        for (StateflowTransition transition : StateflowUtils.getAllTransitions((StateflowChart)chart, (boolean)false)) {
            String actualSize = transition.getParameter("fontSize");
            if (actualSize == null) {
                actualSize = block.getModel().getLineDefaultParameter("FontSize");
            }
            if (!SimulinkAndStateflowFontSettingsCheck.isPresentAndDifferentThanFontSize(actualSize, this.globalExpectedTransitionSettings.size)) continue;
            FindingPropertyList properties = SimulinkAndStateflowFontSettingsCheck.generateFindingPropertiesForStateflowSize(this.globalExpectedTransitionSettings, transition.getParameter("fontSize"), block.getModel().getLineDefaultParameter("FontSize"));
            this.buildFinding("Transition font size differs from default settings", (ElementLocation)this.buildLocation().forStateflowTransition(transition)).addFindingProperties(properties).createAndStore();
        }
    }

    private static boolean isPresentAndDifferentThan(String actualValue, String expectedValue) {
        if (expectedValue.equalsIgnoreCase("any")) {
            return false;
        }
        return actualValue != null && !actualValue.equalsIgnoreCase(expectedValue);
    }

    private static boolean isPresentAndDifferentThanFontSize(String actualSize, String expectedSize) {
        String expected;
        if (expectedSize.equalsIgnoreCase("any")) {
            return false;
        }
        if (actualSize == null) {
            return false;
        }
        String actual = StringUtils.stripSuffix((String)actualSize, (String)"pt");
        return !actual.equals(expected = StringUtils.stripSuffix((String)expectedSize, (String)"pt"));
    }

    private static @NonNull FindingPropertyList generateFindingProperties(FontSettings expectedSettings) {
        FindingPropertyList properties = new FindingPropertyList();
        properties.addProperty("Recommended Action", (Object)"Consider modifying font settings as specified in the configuration.");
        properties.addProperty("Expected settings", (Object)expectedSettings.toUserReadableString());
        return properties;
    }

    private static String generateActualSettingsFindingsPropertyForStateflowFont(String actualName, String actualSize, String actualAngle, String actualWeight) {
        return "Name: " + actualName + ", Size: " + actualSize + ", Angle: " + actualAngle + ", Weight: " + actualWeight;
    }

    private static @NonNull FindingPropertyList generateFindingPropertiesForStateflowSize(FontSettings expectedSettings, String actualSize, String lineSizeDefaultValue) {
        FindingPropertyList properties = new FindingPropertyList();
        properties.addProperty("Recommended Action", (Object)"Consider modifying font size as specified in the configuration.");
        properties.addProperty("Expected setting for size: ", (Object)expectedSettings.size);
        if (actualSize != null) {
            properties.addProperty("Actual setting for size: ", (Object)actualSize);
        } else {
            properties.addProperty("Actual setting for size: ", (Object)(lineSizeDefaultValue + " (inherited from chart)"));
        }
        return properties;
    }

    static class FontSettings {
        public static final String ANY_VALUE = "any";
        private static final String NORMAL_VALUE = "normal";
        public static final String DEFAULT_VALUE = "default";
        final String size;
        final String name;
        final String angle;
        final String weight;

        private FontSettings(String parameterValue) throws CheckException {
            String size = "10";
            String name = "arial";
            String angle = NORMAL_VALUE;
            String weight = NORMAL_VALUE;
            List<Pair<String, String>> parsedParameters = FontSettings.parseFontSettingsParameter(parameterValue);
            block12: for (Pair<String, String> setting : parsedParameters) {
                String settingName = (String)setting.getFirst();
                String settingValue = (String)setting.getSecond();
                switch (settingName) {
                    case "name": {
                        name = settingValue.toLowerCase();
                        continue block12;
                    }
                    case "size": {
                        size = settingValue.toLowerCase();
                        continue block12;
                    }
                    case "angle": {
                        angle = settingValue.toLowerCase();
                        continue block12;
                    }
                    case "weight": {
                        weight = settingValue.toLowerCase();
                        continue block12;
                    }
                }
                throw new CheckException("Invalid configuration of simulink font check. Check Option " + MarkupUtils.formatAsSourceCode((String)parameterValue) + " contains element that is not name, size, angle, or weight.");
            }
            this.size = size;
            this.name = name;
            this.angle = angle;
            this.weight = weight;
        }

        private static List<Pair<String, String>> parseFontSettingsParameter(String parameterValue) throws CheckException {
            ArrayList<Pair<String, String>> parsedParameters = new ArrayList<Pair<String, String>>();
            for (String parameterElement : StringUtils.splitToList((String)parameterValue, (String)",")) {
                if (!parameterElement.contains(":")) {
                    throw new CheckException("invalid configuration of simulink font check. Check Option " + MarkupUtils.formatAsSourceCode((String)parameterValue) + " is not formatted correctly.");
                }
                String settingName = StringUtils.getFirstPart((String)parameterElement, (String)":").trim().toLowerCase();
                String settingValue = StringUtils.getLastPart((String)parameterElement, (String)":").trim().toLowerCase();
                if (settingName.isEmpty() || settingValue.isEmpty()) {
                    throw new CheckException("invalid configuration of simulink font check. Check Option " + MarkupUtils.formatAsSourceCode((String)parameterValue) + " is not formatted correctly.");
                }
                parsedParameters.add((Pair<String, String>)new Pair((Object)settingName, (Object)settingValue));
            }
            return parsedParameters;
        }

        private String toUserReadableString() {
            return "Name: " + this.name + ", Size: " + this.size + ", Angle: " + this.angle + ", Weight: " + this.weight;
        }
    }
}

