/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.simulink.simulink.phases.SimulinkDataDictionaryLoadingPhase;
import eu.cqse.check.simulink.simulink.phases.SimulinkFileReferencesPhase;
import eu.cqse.check.simulink.simulink.phases.SimulinkModelBlockIdListingPhase;
import eu.cqse.check.simulink.simulink.utils.ExternalConfigSetUtils;
import org.conqat.lib.simulink.builder.SimulinkConfigSet;
import org.conqat.lib.simulink.model.SimulinkModel;

@Check(id="cqse.maab.jc_0806", languages={ELanguage.SIMULINK}, phases={SimulinkDataDictionaryLoadingPhase.class, SimulinkFileReferencesPhase.class, SimulinkModelBlockIdListingPhase.class})
public class SimulinkDetectingIncorrectCalculationResultsCheck
extends CheckImplementationBase {
    private static final String DIVISION_BY_SINGULAR_MATRIX_FINDING_MESSAGE = "The configuration parameter \"Division by singular matrix\" is not set to \"error\"";
    private static final FindingPropertyList RECOMMENDED_ACTION_DIVISION_BY_SINGULAR_MATRIX = FindingPropertyList.singleton((String)"Recommended Action", (String)"Set the configuration parameter \"Division by singular matrix\" to \"error\"");
    private static final String INF_OR_NAN_BLOCK_OUTPUT_FINDING_MESSAGE = "The configuration parameter \"Inf or NaN block output\" is not set to \"error\"";
    private static final FindingPropertyList RECOMMENDED_ACTION_INF_OR_NAN_BLOCK_OUTPUT = FindingPropertyList.singleton((String)"Recommended Action", (String)"Set the configuration parameter \"Inf or NaN block output\" to \"error\"");
    private static final String NO_SATURATION_LIMITS_FINDING_MESSAGE = "The configuration parameter \"Wrap on overflow\" is not set to \"error\"";
    private static final FindingPropertyList RECOMMENDED_ACTION_WRAP_ON_OVERFLOW = FindingPropertyList.singleton((String)"Recommended Action", (String)"Set the configuration parameter \"Wrap on overflow\" to \"error\"");
    private static final String SATURATE_ON_WORKFLOW_FINDING_MESSAGE = "The configuration parameter \"Saturate on overflow\" is not set to \"error\"";
    private static final FindingPropertyList RECOMMENDED_ACTION_SATURATE_ON_WORKFLOW = FindingPropertyList.singleton((String)"Recommended Action", (String)"Set the configuration parameter \"Saturate on overflow\" to \"error\"");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null || model.isLibraryModel() || model.isSubsystem()) {
            return;
        }
        SimulinkConfigSet externalConfigSet = ExternalConfigSetUtils.getExternalConfigSet(model, this.context).orElse(null);
        if (ExternalConfigSetUtils.getParameter(model, externalConfigSet, "SignalInfNanChecking").filter("error"::equalsIgnoreCase).isEmpty()) {
            this.buildFinding(INF_OR_NAN_BLOCK_OUTPUT_FINDING_MESSAGE, this.buildLocation().forElement()).addFindingProperties(RECOMMENDED_ACTION_INF_OR_NAN_BLOCK_OUTPUT).createAndStore();
        }
        if (ExternalConfigSetUtils.getParameter(model, externalConfigSet, "CheckMatrixSingularityMsg").filter("error"::equalsIgnoreCase).isEmpty()) {
            this.buildFinding(DIVISION_BY_SINGULAR_MATRIX_FINDING_MESSAGE, this.buildLocation().forElement()).addFindingProperties(RECOMMENDED_ACTION_DIVISION_BY_SINGULAR_MATRIX).createAndStore();
        }
        if (ExternalConfigSetUtils.getParameter(model, externalConfigSet, "IntegerOverflowMsg").filter("error"::equalsIgnoreCase).isEmpty()) {
            this.buildFinding(NO_SATURATION_LIMITS_FINDING_MESSAGE, this.buildLocation().forElement()).addFindingProperties(RECOMMENDED_ACTION_WRAP_ON_OVERFLOW).createAndStore();
        }
        if (ExternalConfigSetUtils.getParameter(model, externalConfigSet, "IntegerSaturationMsg").filter("error"::equalsIgnoreCase).isEmpty()) {
            this.buildFinding(SATURATE_ON_WORKFLOW_FINDING_MESSAGE, this.buildLocation().forElement()).addFindingProperties(RECOMMENDED_ACTION_SATURATE_ON_WORKFLOW).createAndStore();
        }
    }
}

