/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink.phases;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.IExtractedValue;
import eu.cqse.check.framework.core.phase.IGlobalExtractionPhase;
import eu.cqse.check.framework.core.phase.ITokenElementContext;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.conqat.lib.commons.test.IndexValueClass;
import org.conqat.lib.simulink.builder.SimulinkDataDictionary;

public class SimulinkDataDictionaryLoadingPhase
implements IGlobalExtractionPhase<DataDictionaryContainer, SimulinkDataDictionary> {
    public EnumSet<ELanguage> getLanguages() {
        return EnumSet.of(ELanguage.SIMULINK);
    }

    public boolean needsAccessByValue() {
        return false;
    }

    public EnumSet<ECheckParameter> getRequiredContextParameters() {
        return EnumSet.of(ECheckParameter.RUN_ON_HIDDEN_ELEMENTS);
    }

    public List<DataDictionaryContainer> extract(ITokenElementContext fileContext) throws CheckException {
        Optional dictionary = fileContext.getSimulinkContext().getSimulinkDataDictionaryForDictionaryFile();
        if (dictionary.isPresent()) {
            String uniformPath = fileContext.getUniformPath();
            return Collections.singletonList(new DataDictionaryContainer(uniformPath, (SimulinkDataDictionary)dictionary.get()));
        }
        return Collections.emptyList();
    }

    public DataDictionaryContainer createValue(String uniformPath, String value, SimulinkDataDictionary additionalInformation) {
        return new DataDictionaryContainer(uniformPath, additionalInformation);
    }

    @IndexValueClass
    public static class DataDictionaryContainer
    implements IExtractedValue<SimulinkDataDictionary> {
        private final String uniformPath;
        private final SimulinkDataDictionary dictionary;

        public DataDictionaryContainer(String uniformPath, SimulinkDataDictionary dictionary) {
            this.uniformPath = uniformPath;
            this.dictionary = dictionary;
        }

        public String getUniformPath() {
            return this.uniformPath;
        }

        public String getValue() {
            return "";
        }

        public SimulinkDataDictionary getAdditionalInformation() {
            return this.dictionary;
        }
    }
}

