/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.stateflow;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.collections.IdentityHashSet;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowJunction;
import org.conqat.lib.simulink.model.stateflow.StateflowMachine;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.model.stateflow.StateflowTransition;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.hism.hisf_0014", languages={ELanguage.SIMULINK})
public class SimulinkUsageOfTransitionPathsCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE = "The transitions of the Stateflow junction do not end on a substate of the parent state";
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Remodel the junction such that transition paths going into/out of a state without ending on a substate are avoided.");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        StateflowMachine machine = model.getStateflowMachine();
        if (machine == null) {
            return;
        }
        machine.getCharts(false).forEach(this::analyzeStatesInChart);
    }

    private void analyzeStatesInChart(StateflowChart chart) {
        for (StateflowNodeBase node : StateflowUtils.listNodesRecursively((StateflowChart)chart, (boolean)false)) {
            if (!(node instanceof StateflowState)) continue;
            this.analyzeState((StateflowState)node);
        }
    }

    private void analyzeState(StateflowState state) {
        UnmodifiableSet contentNodes = state.getSubViewer() != null ? state.getSubViewer().getNodes() : state.getNodes();
        for (StateflowNodeBase node : contentNodes) {
            if (!(node instanceof StateflowJunction)) continue;
            this.analyzeJunction((StateflowJunction)node, state);
        }
    }

    private void analyzeJunction(StateflowJunction junction, StateflowState containerState) {
        if (SimulinkUsageOfTransitionPathsCheck.hasTransitionToOuterState(junction, containerState, StateflowNodeBase::getInTransitions, StateflowTransition::getSrc) && SimulinkUsageOfTransitionPathsCheck.hasTransitionToOuterState(junction, containerState, StateflowNodeBase::getOutTransitions, StateflowTransition::getDst)) {
            this.context.buildFinding(FINDING_MESSAGE, (ElementLocation)this.buildLocation().forStateflowNode((StateflowNodeBase)junction)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }

    private static boolean hasTransitionToOuterState(StateflowJunction junction, StateflowState containerState, Function<StateflowNodeBase, Set<StateflowTransition>> transitionGetter, Function<StateflowTransition, StateflowNodeBase> endpointGetter) {
        return SimulinkUsageOfTransitionPathsCheck.hasTransitionToOuterState(junction, containerState, transitionGetter, endpointGetter, (Set<StateflowJunction>)new IdentityHashSet());
    }

    private static boolean hasTransitionToOuterState(StateflowJunction junction, StateflowState containerState, Function<StateflowNodeBase, Set<StateflowTransition>> transitionGetter, Function<StateflowTransition, StateflowNodeBase> endpointGetter, Set<StateflowJunction> seenJunctions) {
        if (!seenJunctions.add(junction)) {
            return false;
        }
        for (StateflowTransition transition : transitionGetter.apply((StateflowNodeBase)junction)) {
            StateflowNodeBase endpoint = endpointGetter.apply(transition);
            if (SimulinkUsageOfTransitionPathsCheck.isOuterState(endpoint, containerState)) {
                return true;
            }
            if (!(endpoint instanceof StateflowJunction) || endpoint.getParent() != containerState || !SimulinkUsageOfTransitionPathsCheck.hasTransitionToOuterState((StateflowJunction)endpoint, containerState, transitionGetter, endpointGetter, seenJunctions)) continue;
            return true;
        }
        return false;
    }

    private static boolean isOuterState(StateflowNodeBase state, StateflowState containerState) {
        if (state == null || containerState.equals(state)) {
            return false;
        }
        Optional container = StateflowUtils.getNearestStateflowNodeAncestor((StateflowNodeBase)state);
        while (container.isPresent()) {
            if (((StateflowNodeBase)container.get()).equals(containerState)) {
                return false;
            }
            container = StateflowUtils.getNearestStateflowNodeAncestor((StateflowNodeBase)((StateflowNodeBase)container.get()));
        }
        return true;
    }
}

