/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.sqlscript;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.sqlscript.SqlStatementCheckBase;
import eu.cqse.check.sqlscript.sqlstatement.SqlStatement;
import java.util.ArrayList;
import java.util.List;

@Check(id="cqse-subquery-without-parentheses", languages={ELanguage.SQLSCRIPT}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class SubqueryWithoutParenthesesCheck
extends SqlStatementCheckBase {
    @CheckOption(name="Do not check for parantheses", description="SQL statements which do not require parentheses for sub-queries.")
    private List<String> excludeStatements = new ArrayList<String>(SqlStatement.SUBQUERY_TOLERANT_STATEMENTS);

    @Override
    protected void checkSqlStatement(SqlStatement statement) {
        for (IToken token : statement.findSubquerySelectTokensWithoutParentheses()) {
            this.buildFinding("Missing parentheses around sub-query in SQL statement", this.buildLocation().forToken(token)).createAndStore();
        }
    }

    @Override
    protected List<String> excludeStatements() {
        return this.excludeStatements;
    }
}

