/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.wia.parsable.rule;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.wia.parsable.rule.ParsableRule;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.function.FunctionWithException;

public class TypedListOptionRule<V, O>
extends ParsableRule {
    public final Set<V> values;
    public final List<O> options;

    public TypedListOptionRule(Set<String> itemTypes, Set<V> values, List<O> options) {
        super(itemTypes);
        this.values = values;
        this.options = options;
    }

    public static class Parser<V, O>
    extends ParsableRule.RuleParser {
        private FunctionWithException<String, V, CheckException> valueParser;
        private FunctionWithException<String, O, CheckException> optionParser;

        public Parser<V, O> withValueParser(FunctionWithException<String, V, CheckException> valueParser) {
            this.valueParser = valueParser;
            return this;
        }

        public Parser<V, O> withOptionParser(FunctionWithException<String, O, CheckException> optionParser) {
            this.optionParser = optionParser;
            return this;
        }

        @Override
        public TypedListOptionRule<V, O> parse(String rule) throws CheckException {
            Pair<String, String> assignment = Parser.parseAssignment(rule);
            LinkedList linkedObjects = (LinkedList)Parser.parseLinkedList((String)assignment.getSecond());
            if (linkedObjects.isEmpty()) {
                throw new CheckException("Unable to parse linked objects \"%s\", has to contain at least one element".formatted(assignment.getSecond()));
            }
            String rawValues = (String)linkedObjects.removeFirst();
            Set<String> stringSet = Parser.parseSet(rawValues);
            if (stringSet.isEmpty()) {
                throw new CheckException("Unable to parse set \"%s\", has to contain at least one element".formatted(rawValues));
            }
            HashSet<Object> values = new HashSet<Object>();
            for (String string : stringSet) {
                values.add(this.valueParser.apply((Object)string));
            }
            LinkedList<Object> options = new LinkedList<Object>();
            for (String string : linkedObjects) {
                options.add(this.optionParser.apply((Object)string));
            }
            return new TypedListOptionRule(Parser.parseSet((String)assignment.getFirst()), values, options);
        }
    }
}

