/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.xml;

import eu.cqse.check.xml.XmlCheckHandlerBase;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.xml.sax.Attributes;

public abstract class XmlElementCheckHandlerBase
extends XmlCheckHandlerBase {
    private final Set<String> xmlElementNames;
    private final String requiredAncestorXmlElementName;
    private int ancestorLevel = 0;
    private Map<String, String> currentAttributes;
    private Map<String, String> parentAttributes;
    private StringBuilder valueBuffer = null;

    protected XmlElementCheckHandlerBase(String parentXmlElementName, Set<String> xmlElementNames) {
        this.requiredAncestorXmlElementName = parentXmlElementName;
        this.xmlElementNames = xmlElementNames;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        this.updateAttributes(attributes);
        if (this.requiredAncestorXmlElementName != null && localName.equals(this.requiredAncestorXmlElementName)) {
            ++this.ancestorLevel;
            return;
        }
        if (this.isWithinRequiredAncestor() && this.xmlElementNames.contains(localName)) {
            this.valueBuffer = new StringBuilder();
            this.checkAttributes(attributes);
        }
    }

    private void updateAttributes(Attributes attributes) {
        this.parentAttributes = this.currentAttributes;
        this.currentAttributes = new HashMap<String, String>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            this.currentAttributes.put(attributes.getLocalName(i), attributes.getValue(i));
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (this.requiredAncestorXmlElementName != null && localName.equals(this.requiredAncestorXmlElementName)) {
            --this.ancestorLevel;
            return;
        }
        if (this.isWithinRequiredAncestor() && this.xmlElementNames.contains(localName)) {
            this.checkValue(this.valueBuffer.toString());
            this.valueBuffer = null;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.valueBuffer != null) {
            this.valueBuffer.append(ch, start, length);
        }
    }

    private boolean isWithinRequiredAncestor() {
        return this.requiredAncestorXmlElementName == null || this.ancestorLevel > 0;
    }

    protected String getParentAttributeValue(String name) {
        return this.parentAttributes.get(name);
    }
}

