/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.error;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;

@Consumes(value={"text/plain"})
public class GenericExceptionMessageBodyReader
implements MessageBodyReader<Object> {
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return MediaType.TEXT_PLAIN_TYPE.isCompatible(mediaType) && mediaType.getParameters().containsKey("exceptional");
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        Charset charset = Optional.ofNullable((String)mediaType.getParameters().get("charset")).map(Charset::forName).orElse(StandardCharsets.US_ASCII);
        String message = new String(entityStream.readAllBytes(), charset);
        throw new WebApplicationException(message);
    }
}

