/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.logging;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.splunk.logging.HttpEventCollectorEventInfo;
import java.util.List;

public class HttpEventCollectorErrorHandler {
    private static ErrorCallback errorCallback;

    public static void registerClassName(String errorCallbackClass) {
        if (errorCallbackClass == null || errorCallbackClass.trim().isEmpty()) {
            HttpEventCollectorErrorHandler.onError(null);
            return;
        }
        try {
            ErrorCallback callback = (ErrorCallback)Class.forName(errorCallbackClass).newInstance();
            HttpEventCollectorErrorHandler.onError(callback);
        }
        catch (Exception e) {
            System.err.println("Warning: cannot create ErrorCallback instance: " + e);
        }
    }

    public static void onError(ErrorCallback callback) {
        if (callback == null) {
            HttpEventCollectorErrorHandler.logInfo("Reset ErrorCallback to null (no error handling).");
        } else {
            HttpEventCollectorErrorHandler.logInfo("Register ErrorCallback implementation: " + callback);
            if (errorCallback != null && !errorCallback.equals(callback)) {
                HttpEventCollectorErrorHandler.logWarn("ErrorCallback instance of '" + errorCallback.getClass().getName() + "' will be replaced by handler instance of '" + callback.getClass().getName() + "'");
            }
        }
        errorCallback = callback;
    }

    public static void error(List<HttpEventCollectorEventInfo> data, Exception ex) {
        if (errorCallback != null) {
            errorCallback.error(data, ex);
        }
    }

    private static void logInfo(String message) {
        System.out.println("Info: " + message);
    }

    private static void logWarn(String message) {
        System.out.println("Warning: " + message);
    }

    public static interface ErrorCallback {
        public void error(List<HttpEventCollectorEventInfo> var1, Exception var2);
    }

    public static class ServerErrorException
    extends Exception {
        private String reply;
        private long errorCode = -1L;
        private String errorText;

        public ServerErrorException(String serverReply) {
            this.reply = serverReply;
            try {
                JsonObject json = JsonParser.parseString((String)serverReply).getAsJsonObject();
                this.errorCode = json.get("code").getAsLong();
                this.errorText = json.get("text").getAsString();
            }
            catch (Exception e) {
                this.errorText = e.getMessage();
            }
        }

        public String getReply() {
            return this.reply;
        }

        public long getErrorCode() {
            return this.errorCode;
        }

        public String getErrorText() {
            return this.errorText;
        }

        @Override
        public String getMessage() {
            return this.getErrorText();
        }

        @Override
        public String toString() {
            return this.getReply();
        }
    }
}

