/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.logging.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParser;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import com.splunk.logging.HttpEventCollectorEventInfo;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class EventInfoTypeAdapter
implements JsonSerializer<HttpEventCollectorEventInfo> {
    public JsonElement serialize(HttpEventCollectorEventInfo src, Type typeOfSrc, JsonSerializationContext context) {
        String markerString;
        Map<String, String> props;
        HashMap<String, Object> event = new HashMap<String, Object>();
        if (src.getSeverity() != null) {
            event.put("severity", src.getSeverity());
        }
        try {
            JsonElement parsed = JsonParser.parseString((String)src.getMessage());
            if (parsed instanceof JsonNull && !src.getMessage().isEmpty()) {
                event.put("message", src.getMessage());
            } else {
                event.put("message", parsed);
            }
        }
        catch (JsonSyntaxException e) {
            event.put("message", src.getMessage());
        }
        if (src.getLoggerName() != null && !src.getLoggerName().isEmpty()) {
            event.put("logger", src.getLoggerName());
        }
        if (src.getThreadName() != null && !src.getThreadName().isEmpty()) {
            event.put("thread", src.getThreadName());
        }
        if (src.getExceptionMessage() != null && !src.getExceptionMessage().isEmpty()) {
            event.put("exception", src.getExceptionMessage());
        }
        if ((props = src.getProperties()) != null && props.size() > 0) {
            event.put("properties", props);
        }
        if (src.getMarker() != null && !(markerString = src.getMarker().toString()).isEmpty()) {
            event.put("marker", src.getMarker().toString());
        }
        return context.serialize(event);
    }
}

