/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.dotnet.resource.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.core.pattern.PatternList;
import org.conqat.engine.dotnet.resource.parser.ESolutionFormatVersion;
import org.conqat.lib.commons.string.StringUtils;

public class SolutionParser {
    private static final String PROJECT_DEFINITION_LINE_PREFIX = "Project(\"{";
    private static final PatternList IGNORED_PROJECTS_PATTERN = new PatternList();
    private static final Pattern STRING_LITERAL_PATTERN = Pattern.compile("\"[^\"]*\"");
    private static final Logger LOGGER;

    public static Set<String> parse(String solutionFileContent) throws ConQATException {
        ESolutionFormatVersion.checkValidSolutionFormat(solutionFileContent);
        TreeSet<String> relativeProjectElementNames = new TreeSet<String>();
        for (String line : StringUtils.splitLines((String)solutionFileContent)) {
            if (!line.startsWith(PROJECT_DEFINITION_LINE_PREFIX)) continue;
            String relativeProjectElementName = SolutionParser.retrieveRelativeProjectElementName(line);
            if (!IGNORED_PROJECTS_PATTERN.matchesAny(relativeProjectElementName)) {
                relativeProjectElementNames.add(relativeProjectElementName);
                continue;
            }
            LOGGER.debug("Excluding solution item: " + relativeProjectElementName);
        }
        return relativeProjectElementNames;
    }

    private static String retrieveRelativeProjectElementName(String line) {
        return SolutionParser.retrieveStringLiterals(line).get(2).replace("\"", "");
    }

    private static List<String> retrieveStringLiterals(String projectLine) {
        Matcher matcher = STRING_LITERAL_PATTERN.matcher(projectLine);
        ArrayList<String> matches = new ArrayList<String>();
        while (matcher.find()) {
            matches.add(matcher.group());
        }
        return matches;
    }

    static {
        IGNORED_PROJECTS_PATTERN.add((Object)Pattern.compile("[^\\.]+"));
        LOGGER = LogManager.getLogger();
    }
}

