/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.index.shared;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@IndexValueClass
public final class UnresolvedCommitDescriptor
implements Serializable {
    public static final Pattern COMMIT_DESCRIPTOR_STRING_PATTERN = Pattern.compile("^(?:(.+):)?(HEAD|\\d+)(?:p(\\d+))?(e)?$");
    public static final UnresolvedCommitDescriptor DEFAULT_HEAD = new UnresolvedCommitDescriptor(null, Long.MAX_VALUE);
    private static final long serialVersionUID = 1L;
    public static final String UNRESOLVE_COMMIT_PARAMETER_DESCRIPTOR = " This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided or \"HEAD\" to refer to the most recent commit. This can optionally be prefixed by the name of the branch, followed by a colon (by default, we use the default branch). You can append a \"p1\" to resolve to the immediate parent of the most recent commit at the given branch/timestamp. p2 would resolve to the parent of the immediate parent and so on. In merge commits, the parent resolution considers only the first parent. You can append \"e\" to include the potential external report uploads of the commit. A parameter value that uses all features would be \"master:1601637680000p1e\"";
    private final String branchName;
    private final long timestamp;
    private final int parentIndex;
    private final boolean includeExternalUploads;

    public UnresolvedCommitDescriptor(CommitDescriptor commitDescriptor) {
        this(commitDescriptor.getBranchName(), commitDescriptor.getTimestamp(), 0);
    }

    public UnresolvedCommitDescriptor(String branchName, long timestamp) {
        this(branchName, timestamp, 0);
    }

    public UnresolvedCommitDescriptor(String branchName, long timestamp, int parentIndex) {
        this(branchName, timestamp, parentIndex, false);
    }

    public UnresolvedCommitDescriptor(String branchName, long timestamp, int parentIndex, boolean includeExternalUploads) {
        Preconditions.checkArgument((parentIndex >= 0 ? 1 : 0) != 0, (String)"Parent index %d must be positive!", (int)parentIndex);
        this.branchName = branchName;
        this.timestamp = timestamp;
        this.parentIndex = parentIndex;
        this.includeExternalUploads = includeExternalUploads;
    }

    public @Nullable String getBranchName() {
        return this.branchName;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getParentIndex() {
        return this.parentIndex;
    }

    public boolean isDefaultAtHead() {
        return this.branchName == null && this.timestamp == Long.MAX_VALUE;
    }

    public boolean isIncludeExternalUploads() {
        return this.includeExternalUploads;
    }

    @JsonValue
    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.branchName != null) {
            result.append(this.branchName);
            result.append(":");
        }
        if (this.timestamp == Long.MAX_VALUE) {
            result.append("HEAD");
        } else {
            result.append(this.timestamp);
        }
        if (this.parentIndex > 0) {
            result.append("p").append(this.parentIndex);
        }
        if (this.includeExternalUploads) {
            result.append("e");
        }
        return result.toString();
    }

    @JsonCreator
    public static @Nullable UnresolvedCommitDescriptor getInstance(String descriptorString) {
        if (descriptorString == null) {
            return DEFAULT_HEAD;
        }
        Matcher matcher = COMMIT_DESCRIPTOR_STRING_PATTERN.matcher(descriptorString);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("The given string '%s' is not a valid commit descriptor", descriptorString));
        }
        String branchName = matcher.group(1);
        String timestampString = matcher.group(2);
        String parentString = matcher.group(3);
        String externalIncludedString = matcher.group(4);
        long timestamp = UnresolvedCommitDescriptor.parseTimestamp(timestampString, descriptorString);
        int parentIndex = Optional.ofNullable(parentString).map(Integer::parseInt).orElse(0);
        boolean includeExternalUploads = externalIncludedString != null;
        return new UnresolvedCommitDescriptor(branchName, timestamp, parentIndex, includeExternalUploads);
    }

    private static long parseTimestamp(String timestampString, String descriptorString) {
        if ("HEAD".equals(timestampString)) {
            return Long.MAX_VALUE;
        }
        long timestamp = Long.parseLong(timestampString);
        if (timestamp <= 0L) {
            throw new IllegalArgumentException("Timestamp must be positive: " + descriptorString);
        }
        return timestamp;
    }

    public static UnresolvedCommitDescriptor latestOnBranch(String branchName) {
        return new UnresolvedCommitDescriptor(branchName, Long.MAX_VALUE);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnresolvedCommitDescriptor that = (UnresolvedCommitDescriptor)o;
        return this.timestamp == that.timestamp && this.parentIndex == that.parentIndex && Objects.equals(this.branchName, that.branchName) && this.includeExternalUploads == that.includeExternalUploads;
    }

    public int hashCode() {
        return Objects.hash(this.branchName, this.timestamp, this.parentIndex, this.includeExternalUploads);
    }
}

