/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import jetbrains.exodus.entitystore.iterate.IndexEntry;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0017\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0096\u0002J\u0010\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Ljetbrains/exodus/entitystore/iterate/BooleanIndexEntry;", "Ljetbrains/exodus/entitystore/iterate/IndexEntry;", "", "propValue", "localId", "", "(ZJ)V", "getPropValue", "()Ljava/lang/Boolean;", "compareTo", "", "other", "isEqual", "right", "isLessThanOrEqual", "max", "xodus-entity-store"})
final class BooleanIndexEntry
extends IndexEntry<Boolean> {
    private final boolean propValue;

    public BooleanIndexEntry(boolean propValue, long localId) {
        super(localId);
        this.propValue = propValue;
    }

    @Override
    @NotNull
    public Boolean getPropValue() {
        return this.propValue;
    }

    @Override
    public int compareTo(@NotNull IndexEntry<Boolean> other) {
        int n;
        Intrinsics.checkNotNullParameter(other, (String)"other");
        int n2 = ((BooleanIndexEntry)other).getPropValue().booleanValue();
        if (Intrinsics.compare((int)(this.getPropValue().booleanValue() ? 1 : 0), (int)n2) < 0) {
            n = -1;
        } else if (Intrinsics.compare((int)(this.getPropValue().booleanValue() ? 1 : 0), (int)n2) > 0) {
            n = 1;
        } else {
            long otherLocalId = other.getLocalId();
            n = this.getLocalId() < otherLocalId ? -1 : (this.getLocalId() > otherLocalId ? 1 : 0);
        }
        return n;
    }

    @Override
    public boolean isEqual(boolean right) {
        return this.getPropValue() == right;
    }

    @Override
    public boolean isLessThanOrEqual(boolean max) {
        return Intrinsics.compare((int)(this.getPropValue().booleanValue() ? 1 : 0), (int)(max ? 1 : 0)) <= 0;
    }
}

