/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.List;
import java.util.Objects;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.symbols.FunctionSymbol;
import org.sonar.php.symbols.Parameter;
import org.sonar.php.symbols.Symbols;
import org.sonar.php.utils.collections.ListUtils;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S930")
public class FunctionCallArgumentsNumberCheck
extends PHPVisitorCheck {
    private static final String MESSAGE = "\"%s\" expects %d argument%s, but %d %s provided. %s";
    private static final String MESSAGE_FEWER = "Add more arguments or define default values.";
    private static final String MESSAGE_MORE = "Reduce provided arguments or add more parameters.";
    private static final String SECONDARY_MESSAGE = "Function definition.";
    private int argumentCount;

    @Override
    public void visitFunctionCall(FunctionCallTree tree) {
        if (tree.callee().is(Tree.Kind.NAMESPACE_NAME) && !Objects.requireNonNull(tree.getParent()).is(Tree.Kind.NEW_EXPRESSION)) {
            this.checkArguments(tree);
        }
        super.visitFunctionCall(tree);
    }

    private void checkArguments(FunctionCallTree fct) {
        NamespaceNameTree callee = (NamespaceNameTree)fct.callee();
        FunctionSymbol symbol = Symbols.get(fct);
        if (!symbol.isUnknownSymbol() && !symbol.hasFuncGetArgs()) {
            this.argumentCount = fct.callArguments().size();
            List<Parameter> parameters = symbol.parameters();
            if (!FunctionCallArgumentsNumberCheck.hasEllipsisOperator(parameters) && this.argumentCount > FunctionCallArgumentsNumberCheck.maxArguments(parameters)) {
                this.addIssue(callee, symbol, MESSAGE_MORE, FunctionCallArgumentsNumberCheck.maxArguments(parameters));
            } else if (!FunctionCallArgumentsNumberCheck.hasSpreadArgument(fct) && this.argumentCount < FunctionCallArgumentsNumberCheck.minArguments(parameters)) {
                this.addIssue(callee, symbol, MESSAGE_FEWER, FunctionCallArgumentsNumberCheck.minArguments(parameters));
            }
        }
    }

    private void addIssue(NamespaceNameTree callee, FunctionSymbol symbol, String messageAddition, int expectedArguments) {
        String expectedWord = expectedArguments == 1 ? "" : "s";
        String actualWord = this.argumentCount == 1 ? "was" : "were";
        this.newIssue(callee, String.format(MESSAGE, callee.fullName(), expectedArguments, expectedWord, this.argumentCount, actualWord, messageAddition)).secondary(symbol.location(), SECONDARY_MESSAGE);
    }

    private static boolean hasEllipsisOperator(List<Parameter> parameters) {
        return !parameters.isEmpty() && ListUtils.getLast(parameters).hasEllipsisOperator();
    }

    private static boolean hasSpreadArgument(FunctionCallTree call) {
        return !CheckUtils.argumentsOfKind(call, Tree.Kind.SPREAD_ARGUMENT).isEmpty();
    }

    private static int minArguments(List<Parameter> parameters) {
        return (int)parameters.stream().filter(p -> !p.hasDefault()).filter(p -> !p.hasEllipsisOperator()).count();
    }

    private static int maxArguments(List<Parameter> parameters) {
        return parameters.size();
    }
}

