/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.tree.impl.expression.FunctionExpressionTreeImpl;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.expression.VariableIdentifierTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S2014")
public class ThisVariableUsageInStaticContextCheck
extends PHPVisitorCheck {
    public static final String KEY = "S2014";
    private static final String MESSAGE = "Remove this use of \"$this\".";
    private boolean inStaticContext = false;

    @Override
    public void visitCompilationUnit(CompilationUnitTree tree) {
        this.inStaticContext = false;
        super.visitCompilationUnit(tree);
    }

    @Override
    public void visitMethodDeclaration(MethodDeclarationTree methodDec) {
        this.inStaticContext = CheckUtils.hasModifier(methodDec.modifiers(), "static");
        super.visitMethodDeclaration(methodDec);
    }

    @Override
    public void visitVariableIdentifier(VariableIdentifierTree varIdentifier) {
        if (this.inStaticContext && "$this".equals(varIdentifier.variableExpression().text()) && !this.isWithinNonStaticFunctionExpression(varIdentifier)) {
            this.context().newIssue(this, varIdentifier.variableExpression(), MESSAGE);
        }
        super.visitVariableIdentifier(varIdentifier);
    }

    private boolean isWithinNonStaticFunctionExpression(VariableIdentifierTree varIdentifier) {
        for (Tree parent = varIdentifier.getParent(); parent != null; parent = parent.getParent()) {
            if (!parent.is(Tree.Kind.FUNCTION_EXPRESSION)) continue;
            FunctionExpressionTreeImpl functionExpressionTree = (FunctionExpressionTreeImpl)parent;
            return functionExpressionTree.staticToken() == null;
        }
        return false;
    }
}

