/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.sonar.php.checks.utils.AbstractDuplicateBranchCheck;
import org.sonar.php.checks.utils.SyntacticEquivalence;
import org.sonar.php.metrics.LineVisitor;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.statement.BlockTree;
import org.sonar.plugins.php.api.tree.statement.ElseClauseTree;
import org.sonar.plugins.php.api.tree.statement.ElseifClauseTree;
import org.sonar.plugins.php.api.tree.statement.IfStatementTree;
import org.sonar.plugins.php.api.tree.statement.StatementTree;
import org.sonar.plugins.php.api.tree.statement.SwitchCaseClauseTree;
import org.sonar.plugins.php.api.tree.statement.SwitchStatementTree;

public abstract class AbstractDuplicateBranchImplementationCheck
extends AbstractDuplicateBranchCheck {
    private void checkBranches(String branchType, List<List<StatementTree>> branches, boolean reportAllDuplicate, SyntaxToken keywordToken) {
        block4: {
            block2: {
                block3: {
                    if (!AbstractDuplicateBranchImplementationCheck.areAllEquivalent(branches)) break block2;
                    if (!reportAllDuplicate) break block3;
                    this.reportAllDuplicateBranches(keywordToken);
                    break block4;
                }
                if (branches.get(0).isEmpty()) break block4;
                branches.stream().skip(1L).forEach(branch -> this.reportTwoDuplicateBranches(branchType, (List)branches.get(0), (List<StatementTree>)branch));
                break block4;
            }
            block0: for (int i = 1; i < branches.size(); ++i) {
                for (int j = 0; j < i; ++j) {
                    List<StatementTree> originalBranch = branches.get(j);
                    List<StatementTree> duplicateBranch = branches.get(i);
                    if (!SyntacticEquivalence.areSyntacticallyEquivalent(duplicateBranch, originalBranch) || !AbstractDuplicateBranchImplementationCheck.isNontrivial(duplicateBranch)) continue;
                    this.reportTwoDuplicateBranches(branchType, originalBranch, duplicateBranch);
                    continue block0;
                }
            }
        }
    }

    @Override
    public void visitIfStatement(IfStatementTree tree) {
        if (!tree.is(Tree.Kind.IF_STATEMENT) || this.checkedIfStatements.contains(tree)) {
            super.visitIfStatement(tree);
            return;
        }
        boolean hasElse = false;
        ArrayList<List<StatementTree>> branches = new ArrayList<List<StatementTree>>();
        for (Tree clause : this.getClauses(tree)) {
            if (clause.is(Tree.Kind.IF_STATEMENT)) {
                IfStatementTree ifStatementTree = (IfStatementTree)clause;
                branches.add(ifStatementTree.statements());
                continue;
            }
            if (clause.is(Tree.Kind.ELSEIF_CLAUSE)) {
                ElseifClauseTree elseifClauseTree = (ElseifClauseTree)clause;
                branches.add(elseifClauseTree.statements());
                continue;
            }
            branches.add(((ElseClauseTree)clause).statements());
            hasElse = true;
        }
        boolean reportAllDuplicate = hasElse;
        this.checkBranches("branch", branches, reportAllDuplicate, tree.ifToken());
        super.visitIfStatement(tree);
    }

    @Override
    public void visitSwitchStatement(SwitchStatementTree tree) {
        ArrayList<List<StatementTree>> normalizedBranches = new ArrayList<List<StatementTree>>();
        boolean hasDefault = false;
        boolean hasFallthrough = false;
        int lastIndex = tree.cases().size() - 1;
        for (int i = 0; i < tree.cases().size(); ++i) {
            SwitchCaseClauseTree switchCaseClause = tree.cases().get(i);
            List<StatementTree> statements = switchCaseClause.statements();
            if (switchCaseClause.is(Tree.Kind.DEFAULT_CLAUSE)) {
                hasDefault = true;
            }
            if (statements.isEmpty()) continue;
            normalizedBranches.add(AbstractDuplicateBranchImplementationCheck.normalize(statements));
            if (i == lastIndex || AbstractDuplicateBranchImplementationCheck.endsWithBreak(statements)) continue;
            hasFallthrough = true;
        }
        if (!normalizedBranches.isEmpty()) {
            boolean reportAllDuplicate = hasDefault && !hasFallthrough;
            this.checkBranches("case", normalizedBranches, reportAllDuplicate, tree.switchToken());
        }
        super.visitSwitchStatement(tree);
    }

    private static List<StatementTree> normalize(List<StatementTree> statements) {
        if (AbstractDuplicateBranchImplementationCheck.endsWithBreak(statements)) {
            return statements.subList(0, statements.size() - 1);
        }
        return statements;
    }

    private static boolean endsWithBreak(List<StatementTree> statements) {
        return statements.get(statements.size() - 1).is(Tree.Kind.BREAK_STATEMENT);
    }

    private static boolean areAllEquivalent(List<List<StatementTree>> branches) {
        List<StatementTree> firstBranch = branches.get(0);
        return branches.stream().allMatch(branch -> SyntacticEquivalence.areSyntacticallyEquivalent(firstBranch, branch));
    }

    private static boolean isNontrivial(List<StatementTree> statements) {
        return statements.stream().flatMap(statement -> statement.is(Tree.Kind.BLOCK) ? ((BlockTree)statement).statements().stream() : Stream.of(statement)).mapToInt(LineVisitor::linesOfCode).sum() > 1;
    }

    protected abstract void reportAllDuplicateBranches(SyntaxToken var1);

    protected abstract void reportTwoDuplicateBranches(String var1, List<StatementTree> var2, List<StatementTree> var3);
}

