/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree.impl.statement;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.php.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.php.utils.collections.IteratorUtils;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.ParenthesisedExpressionTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.statement.SwitchCaseClauseTree;
import org.sonar.plugins.php.api.tree.statement.SwitchStatementTree;
import org.sonar.plugins.php.api.visitors.VisitorCheck;

public class SwitchStatementTreeImpl
extends PHPTree
implements SwitchStatementTree {
    private final Tree.Kind kind;
    private final InternalSyntaxToken switchToken;
    private final ParenthesisedExpressionTree expression;
    private final InternalSyntaxToken openCurlyBraceToken;
    private final InternalSyntaxToken colonToken;
    private final InternalSyntaxToken semicolonToken;
    private final List<SwitchCaseClauseTree> cases;
    private final InternalSyntaxToken closeCurlyBraceToken;
    private final InternalSyntaxToken endswitchToken;
    private final InternalSyntaxToken eosToken;

    public SwitchStatementTreeImpl(InternalSyntaxToken switchToken, ParenthesisedExpressionTree expression, InternalSyntaxToken openCurlyBraceToken, @Nullable InternalSyntaxToken semicolonToken, List<SwitchCaseClauseTree> cases, InternalSyntaxToken closeCurlyBraceToken) {
        this.kind = Tree.Kind.SWITCH_STATEMENT;
        this.switchToken = switchToken;
        this.expression = expression;
        this.openCurlyBraceToken = openCurlyBraceToken;
        this.semicolonToken = semicolonToken;
        this.cases = cases;
        this.closeCurlyBraceToken = closeCurlyBraceToken;
        this.colonToken = null;
        this.endswitchToken = null;
        this.eosToken = null;
    }

    public SwitchStatementTreeImpl(InternalSyntaxToken switchToken, ParenthesisedExpressionTree expression, InternalSyntaxToken colonToken, @Nullable InternalSyntaxToken semicolonToken, List<SwitchCaseClauseTree> cases, InternalSyntaxToken endswitchToken, InternalSyntaxToken eosToken) {
        this.kind = Tree.Kind.ALTERNATIVE_SWITCH_STATEMENT;
        this.switchToken = switchToken;
        this.expression = expression;
        this.openCurlyBraceToken = null;
        this.semicolonToken = semicolonToken;
        this.cases = cases;
        this.closeCurlyBraceToken = null;
        this.colonToken = colonToken;
        this.endswitchToken = endswitchToken;
        this.eosToken = eosToken;
    }

    @Override
    public Tree.Kind getKind() {
        return this.kind;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return IteratorUtils.concat(IteratorUtils.iteratorOf(this.switchToken, this.expression, this.openCurlyBraceToken, this.colonToken, this.semicolonToken), this.cases.iterator(), IteratorUtils.iteratorOf(this.closeCurlyBraceToken, this.endswitchToken, this.eosToken));
    }

    @Override
    public SyntaxToken switchToken() {
        return this.switchToken;
    }

    @Override
    public ParenthesisedExpressionTree expression() {
        return this.expression;
    }

    @Override
    @Nullable
    public SyntaxToken openCurlyBraceToken() {
        return this.openCurlyBraceToken;
    }

    @Override
    @Nullable
    public SyntaxToken colonToken() {
        return this.colonToken;
    }

    @Override
    @Nullable
    public SyntaxToken semicolonToken() {
        return this.semicolonToken;
    }

    @Override
    public List<SwitchCaseClauseTree> cases() {
        return this.cases;
    }

    @Override
    @Nullable
    public SyntaxToken closeCurlyBraceToken() {
        return this.closeCurlyBraceToken;
    }

    @Override
    @Nullable
    public SyntaxToken endswitchToken() {
        return this.endswitchToken;
    }

    @Override
    @Nullable
    public SyntaxToken eosToken() {
        return this.eosToken;
    }

    @Override
    public void accept(VisitorCheck visitor) {
        visitor.visitSwitchStatement(this);
    }
}

