/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.reports.phpstan;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.plugins.php.reports.ExternalIssuesSensor;
import org.sonar.plugins.php.reports.JsonReportReader;
import org.sonar.plugins.php.reports.phpstan.PhpStanJsonReportReader;
import org.sonar.plugins.php.reports.phpstan.PhpStanRulesDefinition;
import org.sonar.plugins.php.warning.AnalysisWarningsWrapper;
import org.sonarsource.analyzer.commons.internal.json.simple.parser.ParseException;

public class PhpStanSensor
extends ExternalIssuesSensor {
    private static final Logger LOG = LoggerFactory.getLogger(PhpStanSensor.class);
    public static final String PHPSTAN_REPORT_KEY = "phpstan";
    public static final String PHPSTAN_REPORT_NAME = "PHPStan";
    public static final String PHPSTAN_REPORT_PATH_KEY = "sonar.php.phpstan.reportPaths";

    public PhpStanSensor(PhpStanRulesDefinition phpStanRulesDefinition, AnalysisWarningsWrapper analysisWarningsWrapper) {
        super(phpStanRulesDefinition, analysisWarningsWrapper);
    }

    @Override
    public void importReport(File report, SensorContext context) throws IOException, ParseException {
        FileInputStream in = new FileInputStream(report);
        LOG.info("Importing {}", (Object)report);
        PhpStanJsonReportReader.read(in, issue -> this.saveIssue(context, (JsonReportReader.Issue)issue));
    }

    @Override
    public String reportName() {
        return PHPSTAN_REPORT_NAME;
    }

    @Override
    protected String reportKey() {
        return PHPSTAN_REPORT_KEY;
    }

    @Override
    public String reportPathKey() {
        return PHPSTAN_REPORT_PATH_KEY;
    }

    @Override
    public Logger logger() {
        return LOG;
    }
}

