/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.finders;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.sonarsource.analyzer.commons.regex.RegexIssueReporter;
import org.sonarsource.analyzer.commons.regex.RegexParseResult;
import org.sonarsource.analyzer.commons.regex.ast.AutomatonState;
import org.sonarsource.analyzer.commons.regex.ast.BoundaryTree;
import org.sonarsource.analyzer.commons.regex.ast.DisjunctionTree;
import org.sonarsource.analyzer.commons.regex.ast.LookAroundTree;
import org.sonarsource.analyzer.commons.regex.ast.RegexBaseVisitor;
import org.sonarsource.analyzer.commons.regex.ast.RegexTree;
import org.sonarsource.analyzer.commons.regex.helpers.RegexReachabilityChecker;

public class ImpossibleBoundaryFinder
extends RegexBaseVisitor {
    private static final String MESSAGE = "Remove or replace this boundary that will never match because it appears %s mandatory input.";
    private static final String SOFT_MESSAGE = "Remove or replace this boundary that can only match if the previous part matched the empty string because it appears %s mandatory input.";
    private final Set<RegexTree> excluded = new HashSet<RegexTree>();
    private final RegexReachabilityChecker regexReachabilityChecker = new RegexReachabilityChecker(false);
    private final RegexIssueReporter.ElementIssue regexElementIssueReporter;
    private AutomatonState start;
    private AutomatonState end;

    public ImpossibleBoundaryFinder(RegexIssueReporter.ElementIssue regexElementIssueReporter) {
        this.regexElementIssueReporter = regexElementIssueReporter;
    }

    @Override
    public void visit(RegexParseResult regexParseResult) {
        this.regexReachabilityChecker.clearCache();
        this.start = regexParseResult.getStartState();
        this.end = regexParseResult.getFinalState();
        super.visit(regexParseResult);
    }

    @Override
    public void visitLookAround(LookAroundTree tree) {
        if (tree.getDirection() == LookAroundTree.Direction.BEHIND) {
            AutomatonState oldStart = this.start;
            this.start = tree.getElement();
            super.visitLookAround(tree);
            this.start = oldStart;
        } else {
            AutomatonState oldEnd = this.end;
            this.end = tree.getElement().continuation();
            super.visitLookAround(tree);
            this.end = oldEnd;
        }
    }

    @Override
    public void visitDisjunction(DisjunctionTree tree) {
        BoundaryInDisjunctionFinder boundaryInDisjunctionFinder = new BoundaryInDisjunctionFinder();
        boundaryInDisjunctionFinder.visit(tree);
        this.excluded.addAll(boundaryInDisjunctionFinder.foundBoundaries());
        super.visitDisjunction(tree);
    }

    @Override
    public void visitBoundary(BoundaryTree boundaryTree) {
        switch (boundaryTree.type()) {
            case LINE_START: {
                if (boundaryTree.activeFlags().contains(8)) break;
                this.checkStartBoundary(boundaryTree);
                break;
            }
            case INPUT_START: {
                this.checkStartBoundary(boundaryTree);
                break;
            }
            case LINE_END: {
                if (boundaryTree.activeFlags().contains(8)) break;
                this.checkEndBoundary(boundaryTree);
                break;
            }
            case INPUT_END: 
            case INPUT_END_FINAL_TERMINATOR: {
                this.checkEndBoundary(boundaryTree);
                break;
            }
        }
    }

    private void checkStartBoundary(BoundaryTree boundaryTree) {
        if (!RegexReachabilityChecker.canReachWithoutConsumingInput(this.start, boundaryTree)) {
            this.regexElementIssueReporter.report(boundaryTree, String.format(MESSAGE, "after"), null, Collections.emptyList());
        } else if (!this.excluded.contains(boundaryTree) && this.probablyShouldConsumeInput(this.start, boundaryTree)) {
            this.regexElementIssueReporter.report(boundaryTree, String.format(SOFT_MESSAGE, "after"), null, Collections.emptyList());
        }
    }

    private void checkEndBoundary(BoundaryTree boundaryTree) {
        if (!RegexReachabilityChecker.canReachWithoutConsumingInput(boundaryTree, this.end)) {
            this.regexElementIssueReporter.report(boundaryTree, String.format(MESSAGE, "before"), null, Collections.emptyList());
        } else if (!this.excluded.contains(boundaryTree) && this.probablyShouldConsumeInput(boundaryTree, this.end)) {
            this.regexElementIssueReporter.report(boundaryTree, String.format(SOFT_MESSAGE, "before"), null, Collections.emptyList());
        }
    }

    private boolean probablyShouldConsumeInput(AutomatonState start, AutomatonState goal) {
        return this.regexReachabilityChecker.canReachWithConsumingInput(start, goal, new HashSet<AutomatonState>());
    }

    private static class BoundaryInDisjunctionFinder
    extends RegexBaseVisitor {
        private final Set<BoundaryTree> foundBoundaries = new HashSet<BoundaryTree>();

        private BoundaryInDisjunctionFinder() {
        }

        @Override
        public void visitBoundary(BoundaryTree boundaryTree) {
            this.foundBoundaries.add(boundaryTree);
        }

        public Set<BoundaryTree> foundBoundaries() {
            return new HashSet<BoundaryTree>(this.foundBoundaries);
        }
    }
}

