/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jspecify.annotations.Nullable;

public final class SecurityUtils {
    private static final Pattern UNDERSCORE_OR_HYPHEN = Pattern.compile("[_-]");
    public static final String DISABLE_HTTPS_REDIRECT_SYSTEM_PROPERTY = "com.teamscale.ssl.disable-redirect";
    public static final String DISABLE_HSTS_SYSTEM_PROPERTY = "com.teamscale.ssl.disable-hsts";
    private static final String BASIC_AUTHENTICATION_PREFIX = "Basic ";
    private static final Charset AUTHENTICATION_DEFAULT_ENCODING = StandardCharsets.ISO_8859_1;
    static final String USERNAME_PASSWORD_SEPARATOR = ":";
    private static final SecureRandom RANDOM = SecurityUtils.getSecureRandom();

    private static SecureRandom getSecureRandom() {
        try {
            return SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError("Standard secure random algorithm SAH1PRNG not found!", e);
        }
    }

    public static String getRandomString(int length) {
        CCSMAssert.isTrue((length > 0 ? 1 : 0) != 0, (String)"Length must be positive");
        byte[] randomBytes = new byte[length * 2];
        RANDOM.nextBytes(randomBytes);
        String encoded = Base64.encodeBase64URLSafeString((byte[])randomBytes);
        encoded = UNDERSCORE_OR_HYPHEN.matcher(encoded).replaceAll("");
        encoded = encoded.substring(0, length);
        if (encoded.length() < length) {
            return SecurityUtils.getRandomString(length);
        }
        return encoded;
    }

    public static String getBasicAuthenticationHeader(String username, String accessKey) {
        String userAndPass = username + USERNAME_PASSWORD_SEPARATOR + accessKey;
        byte[] encoded = Base64.encodeBase64((byte[])userAndPass.getBytes(AUTHENTICATION_DEFAULT_ENCODING));
        return BASIC_AUTHENTICATION_PREFIX + new String(encoded, StandardCharsets.UTF_8);
    }

    public static Pair<String, String> getBasicAuthenticationCredentials(String authHeader) {
        if (authHeader == null || !authHeader.startsWith(BASIC_AUTHENTICATION_PREFIX)) {
            return null;
        }
        String userAndPass = StringUtils.stripPrefix((String)authHeader, (String)BASIC_AUTHENTICATION_PREFIX);
        byte[] decoded = Base64.decodeBase64((String)userAndPass);
        return SecurityUtils.splitUsernameAndPassword(new String(decoded, AUTHENTICATION_DEFAULT_ENCODING));
    }

    static Pair<String, String> splitUsernameAndPassword(String combined) {
        String[] parts = combined.split(USERNAME_PASSWORD_SEPARATOR, 2);
        return new Pair((Object)parts[0], (Object)parts[1]);
    }

    public static byte @Nullable [] asByteArray(char[] password) {
        if (password == null) {
            return null;
        }
        CharBuffer charBuffer = CharBuffer.wrap(password);
        ByteBuffer byteBuffer = StandardCharsets.UTF_8.encode(charBuffer);
        byte[] bytes = Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
        Arrays.fill(byteBuffer.array(), (byte)0);
        return bytes;
    }

    private SecurityUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

