/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.github.client;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.authenticate.github.GitHubApplicationDescription;
import com.teamscale.core.authenticate.github.client.GitHubClientBase;
import com.teamscale.core.authenticate.github.client.IGitHubAppApi;
import com.teamscale.core.authenticate.github.dto.App;
import com.teamscale.core.authenticate.github.dto.Installation;
import com.teamscale.core.authenticate.github.dto.InstallationRepositories;
import com.teamscale.core.authenticate.github.dto.InstallationToken;
import com.teamscale.core.authenticate.index.AccessTokenIndex;
import com.teamscale.core.rest.client.HttpPaginationUtils;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.KeyPair;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.time.Duration;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.util.encoders.DecoderException;
import org.conqat.engine.persistence.store.StorageException;

public class GitHubAppClient
extends GitHubClientBase<IGitHubAppApi> {
    private static final String INSTALLATION_ACCESS_TOKEN_PREFIX = "github-installation-access-token:";
    @JsonProperty(value="accessTokenIndex")
    private final AccessTokenIndex accessTokenIndex;
    @JsonProperty(value="applicationDescription")
    private final GitHubApplicationDescription applicationDescription;
    @JsonProperty(value="authorizationHeader")
    private String appAuthorizationHeader;

    public GitHubAppClient(GitHubApplicationDescription applicationDescription, AccessTokenIndex accessTokenIndex, Logger interactionLogger) {
        super(applicationDescription.getApiServer(), interactionLogger, IGitHubAppApi.class);
        this.applicationDescription = applicationDescription;
        this.accessTokenIndex = accessTokenIndex;
    }

    private String getAppAuthorizationHeader() throws ServiceCallException {
        if (this.appAuthorizationHeader == null) {
            try (PEMParser pemParser = new PEMParser((Reader)new StringReader(this.applicationDescription.privateKey));){
                JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
                Object object = pemParser.readObject();
                KeyPair kp = converter.getKeyPair((PEMKeyPair)object);
                RSAPrivateKey privateKey = (RSAPrivateKey)kp.getPrivate();
                RSAPublicKey publicKey = (RSAPublicKey)kp.getPublic();
                Algorithm algorithm = Algorithm.RSA256((RSAPublicKey)publicKey, (RSAPrivateKey)privateKey);
                String jwt = JWT.create().withIssuedAt(new Date()).withExpiresAt(new Date(new Date().getTime() + 570000L)).withIssuer(this.applicationDescription.appId).sign(algorithm);
                this.appAuthorizationHeader = GitHubAppClient.createBearerAuthorizationHeader(jwt);
            }
            catch (DecoderException e) {
                throw new ServiceCallException("Invalid application private key. Make sure that key is in PEM format.", (Throwable)e);
            }
            catch (IOException e) {
                throw new ServiceCallException("Failed to construct JWT for authentication: " + e.getMessage(), (Throwable)e);
            }
        }
        return this.appAuthorizationHeader;
    }

    public App getApp() throws ServiceCallException {
        return ((IGitHubAppApi)this.gitHubApi).getApp(this.getAppAuthorizationHeader());
    }

    public List<Installation> getAllInstallations() throws ServiceCallException {
        String authorizationHeader = this.getAppAuthorizationHeader();
        return HttpPaginationUtils.executeGetWithLinkHeaderPagination(() -> ((IGitHubAppApi)this.gitHubApi).getAppInstallations(authorizationHeader), url -> ((IGitHubAppApi)this.gitHubApi).getAppInstallationsFromNextPage((String)url, authorizationHeader));
    }

    public String getOrCreateInstallationToken(long installationId) throws ServiceCallException, StorageException {
        return this.accessTokenIndex.getOrCreateToken(INSTALLATION_ACCESS_TOKEN_PREFIX + installationId, Duration.ofMinutes(30L), () -> this.requestInstallationToken(installationId));
    }

    private AccessTokenIndex.AccessToken requestInstallationToken(long installationId) throws ServiceCallException {
        InstallationToken installationToken = ((IGitHubAppApi)this.gitHubApi).createInstallationToken(this.getAppAuthorizationHeader(), installationId);
        return new AccessTokenIndex.AccessToken(installationToken.getToken(), installationToken.getExpiresAt());
    }

    public InstallationRepositories getInstallationRepositories(long installationId) throws ServiceCallException, StorageException {
        String accessToken = this.getOrCreateInstallationToken(installationId);
        String authorizationHeader = GitHubAppClient.createBearerAuthorizationHeader(accessToken);
        List installationRepositories = HttpPaginationUtils.executeGetWithLinkHeaderPagination(() -> ((IGitHubAppApi)this.gitHubApi).getInstallationRepositories(authorizationHeader), url -> ((IGitHubAppApi)this.gitHubApi).getInstallationRepositoriesFromNextPage((String)url, authorizationHeader), InstallationRepositories::getRepositories);
        InstallationRepositories repositories = new InstallationRepositories();
        repositories.addAll(installationRepositories);
        return repositories;
    }

    public String getApplicationDescriptionServerUrl() {
        return this.applicationDescription.serverUrl;
    }

    public String getApplicationId() {
        return this.applicationDescription.appId;
    }

    private static String createBearerAuthorizationHeader(String token) {
        return "Bearer " + token;
    }
}

