/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.metrics.directory;

import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageStringAbbreviator;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

final class MetricsSerializationUtils {
    public static void serializeMetricDirectoryEntry(MetricDirectoryEntry entry, DataOutputStream out, Map<String, Integer> abbreviationMap) throws IOException, StorageException {
        out.writeInt(abbreviationMap.get(entry.getUniformPath()));
        MetricsSerializationUtils.writeObjectArray(entry.getValues(), out);
        out.writeInt(entry.getChildMetricsMap().size());
        for (Map.Entry childEntry : entry.getChildMetricsMap().entrySet()) {
            out.writeInt(abbreviationMap.get(childEntry.getKey()));
            MetricsSerializationUtils.writeObjectArray((Object[])childEntry.getValue(), out);
        }
    }

    public static MetricDirectoryEntry deserializeMetricDirectoryEntry(DataInputStream in, StorageStringAbbreviator abbreviator) throws IOException, StorageException {
        String uniformPath = abbreviator.unabbreviate(in.readInt());
        MetricDirectoryEntry entry = new MetricDirectoryEntry(uniformPath, MetricsSerializationUtils.readObjectArray(in));
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            entry.setChildMetrics(abbreviator.unabbreviate(in.readInt()), MetricsSerializationUtils.readObjectArray(in));
        }
        return entry;
    }

    public static void writeObjectArray(Object[] values, DataOutputStream out) throws IOException {
        out.writeInt(values.length);
        for (Object value : values) {
            StorageUtils.writeCompactObject((Object)value, (DataOutput)out);
        }
    }

    public static Object[] readObjectArray(DataInputStream in) throws IOException {
        int size = in.readInt();
        Object[] result = new Object[size];
        for (int i = 0; i < size; ++i) {
            result[i] = StorageUtils.readCompactObject((DataInput)in);
        }
        return result;
    }

    private MetricsSerializationUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

