/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.option;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.option.IOption;
import java.lang.reflect.InvocationTargetException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.jetbrains.annotations.TestOnly;

public abstract class OptionScheduledRunnable
implements Runnable {
    private IndexLayer indexLayer;
    private String optionName;

    @TestOnly
    public void initForTests(IndexLayer indexLayer, String optionName) {
        this.init(indexLayer, optionName);
    }

    void init(IndexLayer indexLayer, String optionName) {
        CCSMAssert.isNotNull((Object)indexLayer, () -> String.format("Expected \"%s\" to be not null", "indexLayer"));
        CCSMAssert.isNotNull((Object)optionName, () -> String.format("Expected \"%s\" to be not null", "optionName"));
        this.indexLayer = indexLayer;
        this.optionName = optionName;
    }

    protected final IndexLayer getIndexLayer() {
        return this.indexLayer;
    }

    protected final <T extends IOption> T getTriggeringOption(Class<T> optionClass) throws StorageException {
        return (T)IOption.getServerOptionForName(optionClass, this.optionName, this.indexLayer).orElseGet(() -> (IOption)CCSMAssert.fail((String)"Triggering option not found!"));
    }

    public static <T extends OptionScheduledRunnable> T createInstance(Class<T> runnableClass, String optionName, IndexLayer indexLayer) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        CCSMAssert.isNotNull(runnableClass, () -> String.format("Expected \"%s\" to be not null", "runnableClass"));
        CCSMAssert.isNotNull((Object)optionName, () -> String.format("Expected \"%s\" to be not null", "optionName"));
        CCSMAssert.isNotNull((Object)indexLayer, () -> String.format("Expected \"%s\" to be not null", "indexLayer"));
        OptionScheduledRunnable instance = (OptionScheduledRunnable)runnableClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        instance.init(indexLayer, optionName);
        return (T)instance;
    }
}

