/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.permissions;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.permissions.roles.ProjectRole;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;

public class DefaultProjectRoles {
    public static final String PROJECT_ADMIN_ROLE_NAME = "Project Administrator";
    public static final ProjectRole PROJECT_ADMIN = new ProjectRole("Project Administrator", "Project administrators have all available project permissions for a project. This role is not editable.", false, CollectionUtils.asHashSet((Object[])EProjectPermission.values()));
    public static final ProjectRole DEVELOPER = new ProjectRole("Developer", "Developers can just view the project.", EProjectPermission.VIEW, EProjectPermission.EXCLUDE_RED_FINDINGS, EProjectPermission.RETRIEVE_TEST_SUGGESTIONS, EProjectPermission.EXCLUDE_YELLOW_FINDINGS, EProjectPermission.TEST_SELECTION_RANKING);
    public static final ProjectRole PROJECT_LEAD = new ProjectRole("Project Lead", "Project leads may view a project and additionally manage baselines and tasks.", EProjectPermission.VIEW, EProjectPermission.RETRIEVE_TEST_SUGGESTIONS, EProjectPermission.EDIT_BASELINES, EProjectPermission.EDIT_TASKS, EProjectPermission.EXCLUDE_RED_FINDINGS, EProjectPermission.APPROVE_RED_FINDINGS_EXCLUSION, EProjectPermission.EXCLUDE_YELLOW_FINDINGS, EProjectPermission.APPROVE_YELLOW_FINDINGS_EXCLUSION, EProjectPermission.TEST_SELECTION_RANKING);
    public static final ProjectRole ARCHITECT = new ProjectRole("Architect", "Architects may view a project and create and edit architectures for it.", EProjectPermission.VIEW, EProjectPermission.RETRIEVE_TEST_SUGGESTIONS, EProjectPermission.EDIT_ARCHITECTURES, EProjectPermission.EXCLUDE_RED_FINDINGS, EProjectPermission.EXCLUDE_YELLOW_FINDINGS, EProjectPermission.TEST_SELECTION_RANKING);
    public static final ProjectRole BUILD = new ProjectRole("Build", "Build permissions allow uploading external data and trigger information on commit hooks for a project.", EProjectPermission.RETRIEVE_TEST_SUGGESTIONS, EProjectPermission.EXTERNAL_UPLOADS, EProjectPermission.TRIGGER_COMMIT_HOOK);
    public static final ProjectRole TECHNICAL_QUALITY_ENGINEER = new ProjectRole("Technical Quality Engineer", "A Technical Quality Engineer (TQE) can flag findings and edit retrospectives, baselines, architectures and tasks.", EProjectPermission.VIEW, EProjectPermission.RETRIEVE_TEST_SUGGESTIONS, EProjectPermission.EXCLUDE_YELLOW_FINDINGS, EProjectPermission.APPROVE_YELLOW_FINDINGS_EXCLUSION, EProjectPermission.EXCLUDE_RED_FINDINGS, EProjectPermission.APPROVE_RED_FINDINGS_EXCLUSION, EProjectPermission.EDIT_BASELINES, EProjectPermission.EDIT_ARCHITECTURES, EProjectPermission.EDIT_TASKS, EProjectPermission.UPDATE_TASK_RESOLUTION, EProjectPermission.UPDATE_TASK_STATUS, EProjectPermission.EDIT_ISSUE_QUERIES);
    public static final UnmodifiableSet<ProjectRole> CHANGEABLE_PROJECT_ROLES = CollectionUtils.asUnmodifiable(Set.of(DEVELOPER, PROJECT_LEAD, ARCHITECT, BUILD, TECHNICAL_QUALITY_ENGINEER));
    public static final UnmodifiableSet<ProjectRole> FIXED_PROJECT_ROLES = CollectionUtils.asUnmodifiable(Set.of(PROJECT_ADMIN));
}

