/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.analysis.step;

import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.trigger.AnalysisStepBase;
import com.teamscale.core.runtime.impl.analysis.step.AnalysisStepMemberAccessorBase;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.conqat.engine.persistence.index.IProjectIndexWithDynamicName;
import org.conqat.engine.persistence.index.IStorageIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.lib.commons.collections.PairList;

public abstract class AnalysisStepFieldAccessorBase
extends AnalysisStepMemberAccessorBase {
    private final Field field;

    protected AnalysisStepFieldAccessorBase(Field field, List<Field> fieldStack) throws TriggerCompilationException {
        super(fieldStack);
        this.field = field;
        field.setAccessible(true);
        if (Modifier.isStatic(field.getModifiers()) && Arrays.stream(field.getDeclaredAnnotations()).anyMatch(annotation -> annotation.annotationType().equals(IndexAccess.class))) {
            throw new TriggerCompilationException("AnalysisStep field accessors may not be static! Field: '" + field.getDeclaringClass().getName() + "#" + field.getName());
        }
    }

    protected Field getField() {
        return this.field;
    }

    protected void set(AnalysisStepBase analysisStepInstance, Object value) {
        try {
            Collection currentValue;
            Object instance = this.getInstanceFromFieldStack(analysisStepInstance);
            if (Collection.class.isAssignableFrom(this.field.getType())) {
                if (!(value instanceof Collection)) {
                    throw new AssertionError((Object)("Expecting collection as value for collection field " + this.toString() + " but received " + String.valueOf(value.getClass())));
                }
                currentValue = (Collection)this.field.get(instance);
                if (currentValue != null) {
                    currentValue.addAll((Collection)value);
                    return;
                }
            }
            if (PairList.class.isAssignableFrom(this.field.getType())) {
                if (!(value instanceof PairList)) {
                    throw new AssertionError((Object)("Expecting pair list as value for pair list field " + this.toString() + " but received " + String.valueOf(value.getClass())));
                }
                currentValue = (PairList)this.field.get(instance);
                if (currentValue != null) {
                    currentValue.addAll((PairList)value);
                    return;
                }
            }
            this.field.set(instance, value);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError("Illegal access: " + e.getMessage(), e);
        }
    }

    protected static String resolveIndexNameFromIndexClass(Class<? extends IStorageIndex> indexClass, Field field) throws TriggerCompilationException {
        if (IProjectIndexWithDynamicName.class.isAssignableFrom(indexClass)) {
            throw new TriggerCompilationException("Explicit store name must be provided for index with dynamic name referenced by field " + String.valueOf(field));
        }
        Index indexAnnotation = indexClass.getAnnotation(Index.class);
        if (indexAnnotation == null) {
            throw new TriggerCompilationException(Index.class.getSimpleName() + " annotation missing on index " + indexClass.getSimpleName() + " referenced by field " + String.valueOf(field));
        }
        return indexAnnotation.name();
    }

    @Override
    protected String getMemberName() {
        return this.field.getName();
    }
}

