/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.model.datahandler;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.js_export.ExportToTypeScript;

@ExportToTypeScript
public enum EOrientation {
    RIGHT(0),
    DOWN(270),
    LEFT(180),
    UP(90);

    private static final Logger LOGGER;
    private final int direction;

    private EOrientation(int direction) {
        this.direction = direction;
    }

    public boolean isRotated() {
        return this == DOWN || this == UP;
    }

    public boolean isLeftOrUp() {
        return this == LEFT || this == UP;
    }

    public boolean isLeftOrDown() {
        return this == LEFT || this == DOWN;
    }

    public static EOrientation getOrientationFromDirection(double direction) {
        for (EOrientation orientation : EOrientation.values()) {
            if ((double)orientation.direction != direction) continue;
            return orientation;
        }
        return null;
    }

    public int getDirection() {
        return this.direction;
    }

    public EOrientation getOpposite() {
        switch (this.ordinal()) {
            case 1: {
                return UP;
            }
            case 2: {
                return RIGHT;
            }
            case 0: {
                return LEFT;
            }
            case 3: {
                return DOWN;
            }
        }
        throw new AssertionError((Object)("Unknown orientation: " + String.valueOf((Object)this)));
    }

    public static EOrientation fromRotationValue(String rotationValue) {
        switch (rotationValue) {
            case "0": 
            case "359": {
                return RIGHT;
            }
            case "90": {
                return DOWN;
            }
            case "180": {
                return LEFT;
            }
            case "270": {
                return UP;
            }
        }
        LOGGER.error("Unknown rotation value: " + rotationValue + ". Using default.");
        return RIGHT;
    }

    static {
        LOGGER = LogManager.getLogger();
    }
}

