/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.alm.client.HttpMethod;
import com.microsoft.alm.client.VssRestClientHandler;
import com.microsoft.alm.client.VssRestClientHandlerBase;
import com.microsoft.alm.client.VssRestRequest;
import com.microsoft.alm.client.VssRestResponse;
import com.microsoft.alm.client.model.VssResourceNotFoundException;
import com.microsoft.alm.client.model.VssServiceException;
import com.microsoft.alm.client.utils.JsonHelper;
import com.microsoft.alm.visualstudio.services.webapi.ApiResourceLocation;
import com.microsoft.alm.visualstudio.services.webapi.ApiResourceLocationCollection;
import com.microsoft.alm.visualstudio.services.webapi.ApiResourceVersion;
import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.httpclient.Header;
import com.microsoft.tfs.core.httpclient.HttpClient;
import com.microsoft.tfs.core.httpclient.HttpException;
import com.microsoft.tfs.core.httpclient.HttpMethodBase;
import com.microsoft.tfs.core.httpclient.HttpStatus;
import com.microsoft.tfs.core.httpclient.methods.DeleteMethod;
import com.microsoft.tfs.core.httpclient.methods.EntityEnclosingMethod;
import com.microsoft.tfs.core.httpclient.methods.GetMethod;
import com.microsoft.tfs.core.httpclient.methods.InputStreamRequestEntity;
import com.microsoft.tfs.core.httpclient.methods.OptionsMethod;
import com.microsoft.tfs.core.httpclient.methods.PatchMethod;
import com.microsoft.tfs.core.httpclient.methods.PostMethod;
import com.microsoft.tfs.core.httpclient.methods.PutMethod;
import com.microsoft.tfs.core.httpclient.methods.RequestEntity;
import com.microsoft.tfs.core.httpclient.methods.StringRequestEntity;
import com.microsoft.tfs.core.product.CoreVersionInfo;
import com.microsoft.tfs.core.util.URIUtils;
import com.microsoft.tfs.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TeeClientHandler
extends VssRestClientHandlerBase
implements VssRestClientHandler {
    private static final Log log = LogFactory.getLog(TeeClientHandler.class);
    private static final String MEDIA_TYPE_PARAMETERS_SEPARATOR = ";";
    private final HttpClient httpClient;

    public TeeClientHandler(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkConnection() {
        block8: {
            log.debug((Object)"Checking REST client connection");
            URI connectionDataTarget = URIUtils.resolve(this.getBaseUrl(), "_apis/connectiondata");
            HttpMethodBase request = this.createHttpMethod(HttpMethod.GET, connectionDataTarget);
            request.setFollowRedirects(true);
            try {
                request.setRequestHeader("Accept", "application/json");
                int statusCode = this.httpClient.executeMethod(request);
                if (HttpStatus.isSuccessFamily(statusCode)) {
                    byte[] input = request.getResponseBody();
                    if (input != null && input.length > 0) {
                        boolean bl = true;
                        return bl;
                    }
                    break block8;
                }
                throw new HttpException(HttpStatus.getStatusText(statusCode));
            }
            catch (Exception e) {
                log.error((Object)"Connection check failed. Probably the used PAT has expired or has been revoked.", (Throwable)e);
                log.error((Object)e.getMessage(), (Throwable)e);
                this.setLastException(e);
            }
            finally {
                request.releaseConnection();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiResourceLocationCollection loadLocations() {
        URI optionsTarget = URIUtils.resolve(this.getBaseUrl(), "_apis");
        HttpMethodBase request = this.createHttpMethod(HttpMethod.OPTIONS, optionsTarget);
        request.setFollowRedirects(true);
        try {
            request.setRequestHeader("Accept", "application/json");
            int statusCode = this.httpClient.executeMethod(request);
            if (HttpStatus.isSuccessFamily(statusCode)) {
                ApiResourceLocationCollection apiResourceLocationCollection = (ApiResourceLocationCollection)JsonHelper.deserializeResponce((HttpMethodBase)request, ApiResourceLocationCollection.class);
                return apiResourceLocationCollection;
            }
            try {
                throw new HttpException(HttpStatus.getStatusText(statusCode));
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                this.setLastException(e);
                ApiResourceLocationCollection apiResourceLocationCollection = null;
                return apiResourceLocationCollection;
            }
        }
        finally {
            request.releaseConnection();
        }
    }

    @Override
    public <TEntity> VssRestRequest createRequest(HttpMethod method, UUID locationId, Map<String, Object> routeValues, ApiResourceVersion version, TEntity value, String contentMediaType, Map<String, String> queryParameters, String acceptMediaType) {
        URI target = this.createTarget(locationId, routeValues, queryParameters);
        return this.createRequest(method, target, locationId, version, value, contentMediaType, queryParameters, acceptMediaType);
    }

    protected <TEntity> VssRestRequest createRequest(HttpMethod method, URI target, UUID locationId, ApiResourceVersion version, TEntity value, String contentMediaType, Map<String, String> queryParameters, String acceptMediaType) {
        HttpMethodBase request;
        String acceptType = this.getMediaTypeWithQualityHeaderValue(acceptMediaType, this.negotiateRequestVersion(locationId, version));
        if (this.shouldOverrideHttpMethod(method)) {
            request = this.createHttpMethod(HttpMethod.POST, target);
            request.setRequestHeader("X-HTTP-Method-Override", method.toString());
        } else {
            request = this.createHttpMethod(method, target);
        }
        request.setRequestHeader("Accept", acceptType);
        request.setRequestHeader("X-TFS-Version", CoreVersionInfo.getVersion());
        if (request instanceof EntityEnclosingMethod) {
            String contentType = this.getMediaTypeWithQualityHeaderValue(contentMediaType);
            EntityEnclosingMethod entityMethod = (EntityEnclosingMethod)request;
            RequestEntity entity = null;
            if (value != null && value instanceof InputStream) {
                entity = new InputStreamRequestEntity((InputStream)value, contentMediaType);
            } else {
                String content = value != null ? JsonHelper.serializeRequestToString(value) : "";
                try {
                    entity = new StringRequestEntity(content, contentType, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    log.error((Object)"Illegal content encoding found.", (Throwable)e);
                }
            }
            entityMethod.setRequestEntity(entity);
            entityMethod.setRequestHeader("Content-Length", String.valueOf(entity.getContentLength()));
        }
        return new TeeRestRequest(request);
    }

    private URI createTarget(UUID locationId, Map<String, Object> routeValues, Map<String, String> queryParameters) {
        ApiResourceLocation location = this.getLocation(locationId);
        if (location == null) {
            throw new VssResourceNotFoundException(locationId, this.getBaseUrl(), this.getLastException());
        }
        Map<String, Object> dictionary = this.toRouteDictionary(routeValues, location.getArea(), location.getResourceName());
        String routeTemplate = location.getRouteTemplate();
        String actualTemplate = this.replaceRouteValues(routeTemplate, dictionary);
        URI target = URIUtils.resolve(this.getBaseUrl(), actualTemplate);
        return URIUtils.addQueryParameters(target, queryParameters);
    }

    private String replaceRouteValues(String template, Map<String, Object> routeValues) {
        String[] templateParameters = template.split("/");
        ArrayList<String> actualParameters = new ArrayList<String>();
        for (int i = 0; i < templateParameters.length; ++i) {
            String parameter = templateParameters[i];
            if (parameter.startsWith("{")) {
                String name = parameter.startsWith("{*") ? parameter.substring(2, parameter.length() - 1) : parameter.substring(1, parameter.length() - 1);
                Object value = routeValues.get(name);
                if (value == null) continue;
                actualParameters.add(value.toString());
                continue;
            }
            actualParameters.add(parameter);
        }
        return StringUtil.join("/", actualParameters);
    }

    private String getMediaTypeWithQualityHeaderValue(String baseMediaType, ApiResourceVersion version) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (version != null) {
            parameters.put("api-version", version.toString());
        }
        parameters.put("charset", "UTF-8");
        return this.getMediaTypeWithQualityHeaderValue(baseMediaType, parameters);
    }

    private String getMediaTypeWithQualityHeaderValue(String baseMediaType) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("charset", "UTF-8");
        return this.getMediaTypeWithQualityHeaderValue(baseMediaType, parameters);
    }

    private String getMediaTypeWithQualityHeaderValue(String baseMediaType, Map<String, String> parameters) {
        StringBuilder mediaType = new StringBuilder(StringUtil.isNullOrEmpty(baseMediaType) ? "application/json" : baseMediaType);
        for (Map.Entry<String, String> e : parameters.entrySet()) {
            this.addMediaTypeParameter(mediaType, e.getKey(), e.getValue());
        }
        return mediaType.toString();
    }

    private StringBuilder addMediaTypeParameter(StringBuilder mediaType, String parameterName, String parameterValue) {
        mediaType.append(MEDIA_TYPE_PARAMETERS_SEPARATOR);
        mediaType.append(parameterName);
        mediaType.append("=");
        mediaType.append(parameterValue);
        return mediaType;
    }

    private HttpMethodBase createHttpMethod(HttpMethod method, URI target) {
        if (HttpMethod.GET.equals((Object)method)) {
            return new GetMethod(target.toString());
        }
        if (HttpMethod.PUT.equals((Object)method)) {
            return new PutMethod(target.toString());
        }
        if (HttpMethod.POST.equals((Object)method)) {
            return new PostMethod(target.toString());
        }
        if (HttpMethod.DELETE.equals((Object)method)) {
            return new DeleteMethod(target.toString());
        }
        if (HttpMethod.OPTIONS.equals((Object)method)) {
            return new OptionsMethod(target.toString());
        }
        if (HttpMethod.PATCH.equals((Object)method)) {
            return new PatchMethod(target.toString());
        }
        throw new IllegalArgumentException(MessageFormat.format(Messages.getString("VssHttpClientBase.IncorrectHttpMethodNameFormat"), new Object[]{method}));
    }

    public class TeeRestResponse
    implements VssRestResponse {
        private final HttpMethodBase response;

        public TeeRestResponse(HttpMethodBase response) {
            this.response = response;
        }

        @Override
        public boolean isJsonResponse() {
            Header responseContentTypeHeader = this.response.getResponseHeader("Content-Type");
            Header contentLengthHeader = this.response.getResponseHeader("Content-Length");
            if (responseContentTypeHeader != null && contentLengthHeader != null) {
                return StringUtil.startsWithIgnoreCase(responseContentTypeHeader.getValue(), "application/json") && !"0".equals(contentLengthHeader.getValue());
            }
            return false;
        }

        @Override
        public boolean isProxyAuthRequired() {
            return this.response.getStatusCode() == 407;
        }

        @Override
        public boolean isSuccessResponse() {
            return HttpStatus.isSuccessFamily(this.response.getStatusCode());
        }

        @Override
        public <TEntity> TEntity readEntity(Class<TEntity> resultClass) {
            return (TEntity)JsonHelper.deserializeResponce((HttpMethodBase)this.response, resultClass);
        }

        @Override
        public <TEntity> TEntity readEntity(TypeReference<TEntity> resultClass) {
            return (TEntity)JsonHelper.deserializeResponce((HttpMethodBase)this.response, resultClass);
        }

        @Override
        public String getHeader(String headerName) {
            return this.response.getResponseHeader(headerName).getValue();
        }

        @Override
        public String getStatusText() {
            return this.response.getStatusText();
        }

        @Override
        public int getStatusCode() {
            return this.response.getStatusCode();
        }
    }

    public class TeeRestRequest
    implements VssRestRequest {
        private final HttpMethodBase request;

        public TeeRestRequest(HttpMethodBase request) {
            this.request = request;
        }

        @Override
        public VssRestResponse sendRequest() {
            try {
                TeeClientHandler.this.httpClient.executeMethod(this.request);
            }
            catch (HttpException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new VssServiceException(e.getMessage(), e);
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            return new TeeRestResponse(this.request);
        }

        public void setFollowRedirects(boolean followRedirects) {
            this.request.setFollowRedirects(followRedirects);
        }
    }
}

