/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.teamfoundation.chat.webapi;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.alm.client.HttpMethod;
import com.microsoft.alm.client.VssHttpClientBase;
import com.microsoft.alm.client.VssRestClientHandler;
import com.microsoft.alm.client.VssRestRequest;
import com.microsoft.alm.teamfoundation.chat.webapi.Message;
import com.microsoft.alm.teamfoundation.chat.webapi.MessageData;
import com.microsoft.alm.teamfoundation.chat.webapi.Room;
import com.microsoft.alm.teamfoundation.chat.webapi.RoomData;
import com.microsoft.alm.teamfoundation.chat.webapi.User;
import com.microsoft.alm.teamfoundation.chat.webapi.UserData;
import com.microsoft.alm.visualstudio.services.webapi.ApiResourceVersion;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public abstract class ChatHttpClientBase
extends VssHttpClientBase {
    private static final Map<String, Class<? extends Exception>> TRANSLATED_EXCEPTIONS = new HashMap<String, Class<? extends Exception>>();

    protected ChatHttpClientBase(VssRestClientHandler clientHandler, URI baseUrl) {
        super(clientHandler, baseUrl);
    }

    @Override
    protected Map<String, Class<? extends Exception>> getTranslatedExceptions() {
        return TRANSLATED_EXCEPTIONS;
    }

    public void deleteMessage(int roomId, int messageId) {
        UUID locationId = UUID.fromString("7d11c820-4bdc-4bca-8957-9d74e32cdd20");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("roomId", roomId);
        routeValues.put("messageId", messageId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public ArrayList<Message> getChatRoomMessages(int roomId) {
        UUID locationId = UUID.fromString("7d11c820-4bdc-4bca-8957-9d74e32cdd20");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("roomId", roomId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<Message>>(){});
    }

    public Message getChatRoomMessageById(int roomId, int messageId) {
        UUID locationId = UUID.fromString("7d11c820-4bdc-4bca-8957-9d74e32cdd20");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("roomId", roomId);
        routeValues.put("messageId", messageId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, Message.class);
    }

    public Message sendMessageToRoom(MessageData messageUpdate, int roomId) {
        UUID locationId = UUID.fromString("7d11c820-4bdc-4bca-8957-9d74e32cdd20");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("roomId", roomId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, messageUpdate, "application/json", "application/json");
        return super.sendRequest(httpRequest, Message.class);
    }

    public Message updateChatMessage(MessageData messageUpdate, int roomId, int messageId) {
        UUID locationId = UUID.fromString("7d11c820-4bdc-4bca-8957-9d74e32cdd20");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("roomId", roomId);
        routeValues.put("messageId", messageId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, messageUpdate, "application/json", "application/json");
        return super.sendRequest(httpRequest, Message.class);
    }

    public Room createChatRoom(RoomData roomUpdate) {
        UUID locationId = UUID.fromString("3d0e7ee0-a6c9-497e-9a2c-23b687e860e2");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, apiVersion, roomUpdate, "application/json", "application/json");
        return super.sendRequest(httpRequest, Room.class);
    }

    public void deleteChatRoom(int roomId) {
        UUID locationId = UUID.fromString("3d0e7ee0-a6c9-497e-9a2c-23b687e860e2");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("roomId", roomId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public ArrayList<Room> getRooms() {
        UUID locationId = UUID.fromString("3d0e7ee0-a6c9-497e-9a2c-23b687e860e2");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<Room>>(){});
    }

    public Room getChatRoomById(int roomId) {
        UUID locationId = UUID.fromString("3d0e7ee0-a6c9-497e-9a2c-23b687e860e2");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("roomId", roomId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, Room.class);
    }

    public Room updateChatRoom(RoomData roomUpdate, int roomId) {
        UUID locationId = UUID.fromString("3d0e7ee0-a6c9-497e-9a2c-23b687e860e2");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("roomId", roomId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, roomUpdate, "application/json", "application/json");
        return super.sendRequest(httpRequest, Room.class);
    }

    public ArrayList<User> getChatRoomUsers(int roomId) {
        UUID locationId = UUID.fromString("01408881-1a9a-4cc9-981d-9333e354e9d9");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("roomId", roomId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<User>>(){});
    }

    public User getChatRoomUserById(int roomId, UUID userId) {
        UUID locationId = UUID.fromString("01408881-1a9a-4cc9-981d-9333e354e9d9");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("roomId", roomId);
        routeValues.put("userId", userId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, User.class);
    }

    public void joinRoom(UserData userUpdate, int roomId, UUID userId) {
        UUID locationId = UUID.fromString("01408881-1a9a-4cc9-981d-9333e354e9d9");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("roomId", roomId);
        routeValues.put("userId", userId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, userUpdate, "application/json", "application/json");
        super.sendRequest(httpRequest);
    }

    public void leaveRoom(int roomId, UUID userId) {
        UUID locationId = UUID.fromString("01408881-1a9a-4cc9-981d-9333e354e9d9");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("roomId", roomId);
        routeValues.put("userId", userId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }
}

