/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.visualstudio.services.releasemanagement.webapi;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.alm.client.HttpMethod;
import com.microsoft.alm.client.VssHttpClientBase;
import com.microsoft.alm.client.VssRestClientHandler;
import com.microsoft.alm.client.VssRestRequest;
import com.microsoft.alm.client.model.NameValueCollection;
import com.microsoft.alm.visualstudio.services.forminput.InputValuesQuery;
import com.microsoft.alm.visualstudio.services.releasemanagement.webapi.ApprovalStatus;
import com.microsoft.alm.visualstudio.services.releasemanagement.webapi.ApprovalType;
import com.microsoft.alm.visualstudio.services.releasemanagement.webapi.Deployment;
import com.microsoft.alm.visualstudio.services.releasemanagement.webapi.DeploymentOperationStatus;
import com.microsoft.alm.visualstudio.services.releasemanagement.webapi.DeploymentQueryParameters;
import com.microsoft.alm.visualstudio.services.releasemanagement.webapi.DeploymentStatus;
import com.microsoft.alm.visualstudio.services.releasemanagement.webapi.MailMessage;
import com.microsoft.alm.visualstudio.services.releasemanagement.webapi.ManualIntervention;
import com.microsoft.alm.visualstudio.services.releasemanagement.webapi.ManualInterventionUpdateMetadata;
import com.microsoft.alm.visualstudio.services.releasemanagement.webapi.QueuedReleaseData;
import com.microsoft.alm.visualstudio.services.releasemanagement.webapi.Release;
import com.microsoft.alm.visualstudio.services.releasemanagement.webapi.ReleaseApproval;
import com.microsoft.alm.visualstudio.services.releasemanagement.webapi.ReleaseDefinition;
import com.microsoft.alm.visualstudio.services.releasemanagement.webapi.ReleaseEnvironment;
import com.microsoft.alm.visualstudio.services.releasemanagement.webapi.ReleaseEnvironmentUpdateMetadata;
import com.microsoft.alm.visualstudio.services.releasemanagement.webapi.ReleaseQueryOrder;
import com.microsoft.alm.visualstudio.services.releasemanagement.webapi.ReleaseSettings;
import com.microsoft.alm.visualstudio.services.releasemanagement.webapi.ReleaseStartMetadata;
import com.microsoft.alm.visualstudio.services.releasemanagement.webapi.ReleaseStatus;
import com.microsoft.alm.visualstudio.services.releasemanagement.webapi.ReleaseTask;
import com.microsoft.alm.visualstudio.services.releasemanagement.webapi.ReleaseUpdateMetadata;
import com.microsoft.alm.visualstudio.services.releasemanagement.webapi.SummaryMailSection;
import com.microsoft.alm.visualstudio.services.releasemanagement.webapi.contracts.AgentArtifactDefinition;
import com.microsoft.alm.visualstudio.services.releasemanagement.webapi.contracts.Artifact;
import com.microsoft.alm.visualstudio.services.releasemanagement.webapi.contracts.ArtifactTypeDefinition;
import com.microsoft.alm.visualstudio.services.releasemanagement.webapi.contracts.ArtifactVersionQueryResult;
import com.microsoft.alm.visualstudio.services.releasemanagement.webapi.contracts.Change;
import com.microsoft.alm.visualstudio.services.releasemanagement.webapi.contracts.ReleaseDefinitionEnvironmentTemplate;
import com.microsoft.alm.visualstudio.services.releasemanagement.webapi.contracts.ReleaseDefinitionExpands;
import com.microsoft.alm.visualstudio.services.releasemanagement.webapi.contracts.ReleaseDefinitionRevision;
import com.microsoft.alm.visualstudio.services.releasemanagement.webapi.contracts.ReleaseDefinitionSummary;
import com.microsoft.alm.visualstudio.services.releasemanagement.webapi.contracts.ReleaseExpands;
import com.microsoft.alm.visualstudio.services.releasemanagement.webapi.contracts.ReleaseRevision;
import com.microsoft.alm.visualstudio.services.releasemanagement.webapi.contracts.ReleaseWorkItemRef;
import com.microsoft.alm.visualstudio.services.webapi.ApiResourceVersion;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public abstract class ReleaseHttpClientBase
extends VssHttpClientBase {
    private static final Map<String, Class<? extends Exception>> TRANSLATED_EXCEPTIONS = new HashMap<String, Class<? extends Exception>>();

    protected ReleaseHttpClientBase(VssRestClientHandler clientHandler, URI baseUrl) {
        super(clientHandler, baseUrl);
    }

    @Override
    protected Map<String, Class<? extends Exception>> getTranslatedExceptions() {
        return TRANSLATED_EXCEPTIONS;
    }

    public ArrayList<AgentArtifactDefinition> getAgentArtifactDefinitions(String project, int releaseId) {
        UUID locationId = UUID.fromString("f2571c27-bf50-4938-b396-32d109ddef26");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("releaseId", releaseId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<AgentArtifactDefinition>>(){});
    }

    public ArrayList<AgentArtifactDefinition> getAgentArtifactDefinitions(UUID project, int releaseId) {
        UUID locationId = UUID.fromString("f2571c27-bf50-4938-b396-32d109ddef26");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("releaseId", releaseId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<AgentArtifactDefinition>>(){});
    }

    public ReleaseApproval getApprovalHistory(String project, int approvalStepId) {
        UUID locationId = UUID.fromString("250c7158-852e-4130-a00f-a0cce9b72d05");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("approvalStepId", approvalStepId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, ReleaseApproval.class);
    }

    public ReleaseApproval getApprovalHistory(UUID project, int approvalStepId) {
        UUID locationId = UUID.fromString("250c7158-852e-4130-a00f-a0cce9b72d05");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("approvalStepId", approvalStepId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, ReleaseApproval.class);
    }

    public ReleaseApproval getApproval(String project, int approvalId, Boolean includeHistory) {
        UUID locationId = UUID.fromString("9328e074-59fb-465a-89d9-b09c82ee5109");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("approvalId", approvalId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeHistory", includeHistory);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, ReleaseApproval.class);
    }

    public ReleaseApproval getApproval(UUID project, int approvalId, Boolean includeHistory) {
        UUID locationId = UUID.fromString("9328e074-59fb-465a-89d9-b09c82ee5109");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("approvalId", approvalId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeHistory", includeHistory);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, ReleaseApproval.class);
    }

    public ReleaseApproval updateReleaseApproval(ReleaseApproval approval, String project, int approvalId) {
        UUID locationId = UUID.fromString("9328e074-59fb-465a-89d9-b09c82ee5109");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("approvalId", approvalId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, approval, "application/json", "application/json");
        return super.sendRequest(httpRequest, ReleaseApproval.class);
    }

    public ReleaseApproval updateReleaseApproval(ReleaseApproval approval, UUID project, int approvalId) {
        UUID locationId = UUID.fromString("9328e074-59fb-465a-89d9-b09c82ee5109");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("approvalId", approvalId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, approval, "application/json", "application/json");
        return super.sendRequest(httpRequest, ReleaseApproval.class);
    }

    public ArrayList<ReleaseApproval> getApprovals(String project, String assignedToFilter, ApprovalStatus statusFilter, List<Integer> releaseIdsFilter, ApprovalType typeFilter, Integer top, Integer continuationToken, ReleaseQueryOrder queryOrder, Boolean includeMyGroupApprovals) {
        UUID locationId = UUID.fromString("b47c6458-e73b-47cb-a770-4df1e8813a91");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("assignedToFilter", assignedToFilter);
        queryParameters.addIfNotNull("statusFilter", statusFilter);
        queryParameters.addIfNotNull("releaseIdsFilter", releaseIdsFilter);
        queryParameters.addIfNotNull("typeFilter", typeFilter);
        queryParameters.addIfNotNull("top", top);
        queryParameters.addIfNotNull("continuationToken", continuationToken);
        queryParameters.addIfNotNull("queryOrder", queryOrder);
        queryParameters.addIfNotNull("includeMyGroupApprovals", includeMyGroupApprovals);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ReleaseApproval>>(){});
    }

    public ArrayList<ReleaseApproval> getApprovals(UUID project, String assignedToFilter, ApprovalStatus statusFilter, List<Integer> releaseIdsFilter, ApprovalType typeFilter, Integer top, Integer continuationToken, ReleaseQueryOrder queryOrder, Boolean includeMyGroupApprovals) {
        UUID locationId = UUID.fromString("b47c6458-e73b-47cb-a770-4df1e8813a91");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("assignedToFilter", assignedToFilter);
        queryParameters.addIfNotNull("statusFilter", statusFilter);
        queryParameters.addIfNotNull("releaseIdsFilter", releaseIdsFilter);
        queryParameters.addIfNotNull("typeFilter", typeFilter);
        queryParameters.addIfNotNull("top", top);
        queryParameters.addIfNotNull("continuationToken", continuationToken);
        queryParameters.addIfNotNull("queryOrder", queryOrder);
        queryParameters.addIfNotNull("includeMyGroupApprovals", includeMyGroupApprovals);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ReleaseApproval>>(){});
    }

    public ArrayList<Change> getReleaseChanges(String project, int releaseId, Integer baseReleaseId, Integer top) {
        UUID locationId = UUID.fromString("8dcf9fe9-ca37-4113-8ee1-37928e98407c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("releaseId", releaseId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("baseReleaseId", baseReleaseId);
        queryParameters.addIfNotNull("$top", top);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<Change>>(){});
    }

    public ArrayList<Change> getReleaseChanges(UUID project, int releaseId, Integer baseReleaseId, Integer top) {
        UUID locationId = UUID.fromString("8dcf9fe9-ca37-4113-8ee1-37928e98407c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("releaseId", releaseId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("baseReleaseId", baseReleaseId);
        queryParameters.addIfNotNull("$top", top);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<Change>>(){});
    }

    public ReleaseDefinition createReleaseDefinition(ReleaseDefinition releaseDefinition, String project) {
        UUID locationId = UUID.fromString("d8f96f24-8ea7-4cb6-baab-2df8fc515665");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.3");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, releaseDefinition, "application/json", "application/json");
        return super.sendRequest(httpRequest, ReleaseDefinition.class);
    }

    public ReleaseDefinition createReleaseDefinition(ReleaseDefinition releaseDefinition, UUID project) {
        UUID locationId = UUID.fromString("d8f96f24-8ea7-4cb6-baab-2df8fc515665");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.3");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, releaseDefinition, "application/json", "application/json");
        return super.sendRequest(httpRequest, ReleaseDefinition.class);
    }

    public void deleteReleaseDefinition(String project, int definitionId) {
        UUID locationId = UUID.fromString("d8f96f24-8ea7-4cb6-baab-2df8fc515665");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.3");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("definitionId", definitionId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void deleteReleaseDefinition(UUID project, int definitionId) {
        UUID locationId = UUID.fromString("d8f96f24-8ea7-4cb6-baab-2df8fc515665");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.3");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("definitionId", definitionId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public ReleaseDefinition getReleaseDefinition(String project, int definitionId) {
        UUID locationId = UUID.fromString("d8f96f24-8ea7-4cb6-baab-2df8fc515665");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.3");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("definitionId", definitionId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, ReleaseDefinition.class);
    }

    public ReleaseDefinition getReleaseDefinition(UUID project, int definitionId) {
        UUID locationId = UUID.fromString("d8f96f24-8ea7-4cb6-baab-2df8fc515665");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.3");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("definitionId", definitionId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, ReleaseDefinition.class);
    }

    public InputStream getReleaseDefinitionRevision(String project, int definitionId, int revision) {
        UUID locationId = UUID.fromString("d8f96f24-8ea7-4cb6-baab-2df8fc515665");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.3");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("definitionId", definitionId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put("revision", String.valueOf(revision));
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "text/plaint");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getReleaseDefinitionRevision(UUID project, int definitionId, int revision) {
        UUID locationId = UUID.fromString("d8f96f24-8ea7-4cb6-baab-2df8fc515665");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.3");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("definitionId", definitionId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put("revision", String.valueOf(revision));
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "text/plaint");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public ArrayList<ReleaseDefinition> getReleaseDefinitions(String project, String searchText, ReleaseDefinitionExpands expand) {
        UUID locationId = UUID.fromString("d8f96f24-8ea7-4cb6-baab-2df8fc515665");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.3");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("searchText", searchText);
        queryParameters.addIfNotNull("$expand", expand);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ReleaseDefinition>>(){});
    }

    public ArrayList<ReleaseDefinition> getReleaseDefinitions(UUID project, String searchText, ReleaseDefinitionExpands expand) {
        UUID locationId = UUID.fromString("d8f96f24-8ea7-4cb6-baab-2df8fc515665");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.3");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("searchText", searchText);
        queryParameters.addIfNotNull("$expand", expand);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ReleaseDefinition>>(){});
    }

    public ArrayList<ReleaseDefinition> getReleaseDefinitionsForArtifactSource(String project, String artifactType, String artifactSourceId, ReleaseDefinitionExpands expand) {
        UUID locationId = UUID.fromString("d8f96f24-8ea7-4cb6-baab-2df8fc515665");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.3");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("artifactType", artifactType);
        queryParameters.addIfNotEmpty("artifactSourceId", artifactSourceId);
        queryParameters.addIfNotNull("$expand", expand);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ReleaseDefinition>>(){});
    }

    public ArrayList<ReleaseDefinition> getReleaseDefinitionsForArtifactSource(UUID project, String artifactType, String artifactSourceId, ReleaseDefinitionExpands expand) {
        UUID locationId = UUID.fromString("d8f96f24-8ea7-4cb6-baab-2df8fc515665");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.3");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("artifactType", artifactType);
        queryParameters.addIfNotEmpty("artifactSourceId", artifactSourceId);
        queryParameters.addIfNotNull("$expand", expand);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ReleaseDefinition>>(){});
    }

    public ReleaseDefinition updateReleaseDefinition(ReleaseDefinition releaseDefinition, String project) {
        UUID locationId = UUID.fromString("d8f96f24-8ea7-4cb6-baab-2df8fc515665");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.3");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, releaseDefinition, "application/json", "application/json");
        return super.sendRequest(httpRequest, ReleaseDefinition.class);
    }

    public ReleaseDefinition updateReleaseDefinition(ReleaseDefinition releaseDefinition, UUID project) {
        UUID locationId = UUID.fromString("d8f96f24-8ea7-4cb6-baab-2df8fc515665");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.3");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, releaseDefinition, "application/json", "application/json");
        return super.sendRequest(httpRequest, ReleaseDefinition.class);
    }

    public ArrayList<Deployment> getDeployments(String project, Integer definitionId, Integer definitionEnvironmentId, String createdBy, Date minModifiedTime, Date maxModifiedTime, DeploymentStatus deploymentStatus, DeploymentOperationStatus operationStatus, Boolean latestAttemptsOnly, ReleaseQueryOrder queryOrder, Integer top, Integer continuationToken) {
        UUID locationId = UUID.fromString("b005ef73-cddc-448e-9ba2-5193bf36b19f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("definitionId", definitionId);
        queryParameters.addIfNotNull("definitionEnvironmentId", definitionEnvironmentId);
        queryParameters.addIfNotEmpty("createdBy", createdBy);
        queryParameters.addIfNotNull("minModifiedTime", minModifiedTime);
        queryParameters.addIfNotNull("maxModifiedTime", maxModifiedTime);
        queryParameters.addIfNotNull("deploymentStatus", deploymentStatus);
        queryParameters.addIfNotNull("operationStatus", operationStatus);
        queryParameters.addIfNotNull("latestAttemptsOnly", latestAttemptsOnly);
        queryParameters.addIfNotNull("queryOrder", queryOrder);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("continuationToken", continuationToken);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<Deployment>>(){});
    }

    public ArrayList<Deployment> getDeployments(UUID project, Integer definitionId, Integer definitionEnvironmentId, String createdBy, Date minModifiedTime, Date maxModifiedTime, DeploymentStatus deploymentStatus, DeploymentOperationStatus operationStatus, Boolean latestAttemptsOnly, ReleaseQueryOrder queryOrder, Integer top, Integer continuationToken) {
        UUID locationId = UUID.fromString("b005ef73-cddc-448e-9ba2-5193bf36b19f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("definitionId", definitionId);
        queryParameters.addIfNotNull("definitionEnvironmentId", definitionEnvironmentId);
        queryParameters.addIfNotEmpty("createdBy", createdBy);
        queryParameters.addIfNotNull("minModifiedTime", minModifiedTime);
        queryParameters.addIfNotNull("maxModifiedTime", maxModifiedTime);
        queryParameters.addIfNotNull("deploymentStatus", deploymentStatus);
        queryParameters.addIfNotNull("operationStatus", operationStatus);
        queryParameters.addIfNotNull("latestAttemptsOnly", latestAttemptsOnly);
        queryParameters.addIfNotNull("queryOrder", queryOrder);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("continuationToken", continuationToken);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<Deployment>>(){});
    }

    public ArrayList<Deployment> getDeploymentsForMultipleEnvironments(DeploymentQueryParameters queryParameters, String project) {
        UUID locationId = UUID.fromString("b005ef73-cddc-448e-9ba2-5193bf36b19f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, queryParameters, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<Deployment>>(){});
    }

    public ArrayList<Deployment> getDeploymentsForMultipleEnvironments(DeploymentQueryParameters queryParameters, UUID project) {
        UUID locationId = UUID.fromString("b005ef73-cddc-448e-9ba2-5193bf36b19f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, queryParameters, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<Deployment>>(){});
    }

    public ReleaseEnvironment getReleaseEnvironment(String project, int releaseId, int environmentId) {
        UUID locationId = UUID.fromString("a7e426b1-03dc-48af-9dfe-c98bac612dcb");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.4");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("releaseId", releaseId);
        routeValues.put("environmentId", environmentId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, ReleaseEnvironment.class);
    }

    public ReleaseEnvironment getReleaseEnvironment(UUID project, int releaseId, int environmentId) {
        UUID locationId = UUID.fromString("a7e426b1-03dc-48af-9dfe-c98bac612dcb");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.4");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("releaseId", releaseId);
        routeValues.put("environmentId", environmentId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, ReleaseEnvironment.class);
    }

    public ReleaseEnvironment updateReleaseEnvironment(ReleaseEnvironmentUpdateMetadata environmentUpdateData, String project, int releaseId, int environmentId) {
        UUID locationId = UUID.fromString("a7e426b1-03dc-48af-9dfe-c98bac612dcb");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.4");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("releaseId", releaseId);
        routeValues.put("environmentId", environmentId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, environmentUpdateData, "application/json", "application/json");
        return super.sendRequest(httpRequest, ReleaseEnvironment.class);
    }

    public ReleaseEnvironment updateReleaseEnvironment(ReleaseEnvironmentUpdateMetadata environmentUpdateData, UUID project, int releaseId, int environmentId) {
        UUID locationId = UUID.fromString("a7e426b1-03dc-48af-9dfe-c98bac612dcb");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.4");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("releaseId", releaseId);
        routeValues.put("environmentId", environmentId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, environmentUpdateData, "application/json", "application/json");
        return super.sendRequest(httpRequest, ReleaseEnvironment.class);
    }

    public ReleaseDefinitionEnvironmentTemplate createDefinitionEnvironmentTemplate(ReleaseDefinitionEnvironmentTemplate template, String project) {
        UUID locationId = UUID.fromString("6b03b696-824e-4479-8eb2-6644a51aba89");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, template, "application/json", "application/json");
        return super.sendRequest(httpRequest, ReleaseDefinitionEnvironmentTemplate.class);
    }

    public ReleaseDefinitionEnvironmentTemplate createDefinitionEnvironmentTemplate(ReleaseDefinitionEnvironmentTemplate template, UUID project) {
        UUID locationId = UUID.fromString("6b03b696-824e-4479-8eb2-6644a51aba89");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, template, "application/json", "application/json");
        return super.sendRequest(httpRequest, ReleaseDefinitionEnvironmentTemplate.class);
    }

    public void deleteDefinitionEnvironmentTemplate(String project, UUID templateId) {
        UUID locationId = UUID.fromString("6b03b696-824e-4479-8eb2-6644a51aba89");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("templateId", templateId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, queryParameters, "application/json");
        super.sendRequest(httpRequest);
    }

    public void deleteDefinitionEnvironmentTemplate(UUID project, UUID templateId) {
        UUID locationId = UUID.fromString("6b03b696-824e-4479-8eb2-6644a51aba89");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("templateId", templateId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, queryParameters, "application/json");
        super.sendRequest(httpRequest);
    }

    public ReleaseDefinitionEnvironmentTemplate getDefinitionEnvironmentTemplate(String project, UUID templateId) {
        UUID locationId = UUID.fromString("6b03b696-824e-4479-8eb2-6644a51aba89");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("templateId", templateId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, ReleaseDefinitionEnvironmentTemplate.class);
    }

    public ReleaseDefinitionEnvironmentTemplate getDefinitionEnvironmentTemplate(UUID project, UUID templateId) {
        UUID locationId = UUID.fromString("6b03b696-824e-4479-8eb2-6644a51aba89");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("templateId", templateId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, ReleaseDefinitionEnvironmentTemplate.class);
    }

    public ArrayList<ReleaseDefinitionEnvironmentTemplate> listDefinitionEnvironmentTemplates(String project) {
        UUID locationId = UUID.fromString("6b03b696-824e-4479-8eb2-6644a51aba89");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ReleaseDefinitionEnvironmentTemplate>>(){});
    }

    public ArrayList<ReleaseDefinitionEnvironmentTemplate> listDefinitionEnvironmentTemplates(UUID project) {
        UUID locationId = UUID.fromString("6b03b696-824e-4479-8eb2-6644a51aba89");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ReleaseDefinitionEnvironmentTemplate>>(){});
    }

    public ArrayList<ReleaseRevision> getReleaseHistory(String project, int releaseId) {
        UUID locationId = UUID.fromString("23f461c8-629a-4144-a076-3054fa5f268a");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("releaseId", releaseId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ReleaseRevision>>(){});
    }

    public ArrayList<ReleaseRevision> getReleaseHistory(UUID project, int releaseId) {
        UUID locationId = UUID.fromString("23f461c8-629a-4144-a076-3054fa5f268a");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("releaseId", releaseId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ReleaseRevision>>(){});
    }

    public InputValuesQuery getInputValues(InputValuesQuery query, String project) {
        UUID locationId = UUID.fromString("71dd499b-317d-45ea-9134-140ea1932b5e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, query, "application/json", "application/json");
        return super.sendRequest(httpRequest, InputValuesQuery.class);
    }

    public InputValuesQuery getInputValues(InputValuesQuery query, UUID project) {
        UUID locationId = UUID.fromString("71dd499b-317d-45ea-9134-140ea1932b5e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, query, "application/json", "application/json");
        return super.sendRequest(httpRequest, InputValuesQuery.class);
    }

    public InputStream getLog(String project, int releaseId, int environmentId, int taskId, Integer attemptId) {
        UUID locationId = UUID.fromString("e71ba1ed-c0a4-4a28-a61f-2dd5f68cf3fd");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("releaseId", releaseId);
        routeValues.put("environmentId", environmentId);
        routeValues.put("taskId", taskId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("attemptId", attemptId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "text/plaint");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getLog(UUID project, int releaseId, int environmentId, int taskId, Integer attemptId) {
        UUID locationId = UUID.fromString("e71ba1ed-c0a4-4a28-a61f-2dd5f68cf3fd");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("releaseId", releaseId);
        routeValues.put("environmentId", environmentId);
        routeValues.put("taskId", taskId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("attemptId", attemptId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "text/plaint");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getLogs(String project, int releaseId) {
        UUID locationId = UUID.fromString("c37fbab5-214b-48e4-a55b-cb6b4f6e4038");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("releaseId", releaseId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/zip");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getLogs(UUID project, int releaseId) {
        UUID locationId = UUID.fromString("c37fbab5-214b-48e4-a55b-cb6b4f6e4038");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("releaseId", releaseId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/zip");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getTaskLog(String project, int releaseId, int environmentId, int releaseDeployPhaseId, int taskId) {
        UUID locationId = UUID.fromString("17c91af7-09fd-4256-bff1-c24ee4f73bc0");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("releaseId", releaseId);
        routeValues.put("environmentId", environmentId);
        routeValues.put("releaseDeployPhaseId", releaseDeployPhaseId);
        routeValues.put("taskId", taskId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "text/plaint");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getTaskLog(UUID project, int releaseId, int environmentId, int releaseDeployPhaseId, int taskId) {
        UUID locationId = UUID.fromString("17c91af7-09fd-4256-bff1-c24ee4f73bc0");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("releaseId", releaseId);
        routeValues.put("environmentId", environmentId);
        routeValues.put("releaseDeployPhaseId", releaseDeployPhaseId);
        routeValues.put("taskId", taskId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "text/plaint");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public ManualIntervention getManualIntervention(String project, int releaseId, int manualInterventionId) {
        UUID locationId = UUID.fromString("616c46e4-f370-4456-adaa-fbaf79c7b79e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("releaseId", releaseId);
        routeValues.put("manualInterventionId", manualInterventionId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, ManualIntervention.class);
    }

    public ManualIntervention getManualIntervention(UUID project, int releaseId, int manualInterventionId) {
        UUID locationId = UUID.fromString("616c46e4-f370-4456-adaa-fbaf79c7b79e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("releaseId", releaseId);
        routeValues.put("manualInterventionId", manualInterventionId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, ManualIntervention.class);
    }

    public ArrayList<ManualIntervention> getManualInterventions(String project, int releaseId) {
        UUID locationId = UUID.fromString("616c46e4-f370-4456-adaa-fbaf79c7b79e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("releaseId", releaseId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ManualIntervention>>(){});
    }

    public ArrayList<ManualIntervention> getManualInterventions(UUID project, int releaseId) {
        UUID locationId = UUID.fromString("616c46e4-f370-4456-adaa-fbaf79c7b79e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("releaseId", releaseId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ManualIntervention>>(){});
    }

    public ManualIntervention updateManualIntervention(ManualInterventionUpdateMetadata manualInterventionUpdateMetadata, String project, int releaseId, int manualInterventionId) {
        UUID locationId = UUID.fromString("616c46e4-f370-4456-adaa-fbaf79c7b79e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("releaseId", releaseId);
        routeValues.put("manualInterventionId", manualInterventionId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, manualInterventionUpdateMetadata, "application/json", "application/json");
        return super.sendRequest(httpRequest, ManualIntervention.class);
    }

    public ManualIntervention updateManualIntervention(ManualInterventionUpdateMetadata manualInterventionUpdateMetadata, UUID project, int releaseId, int manualInterventionId) {
        UUID locationId = UUID.fromString("616c46e4-f370-4456-adaa-fbaf79c7b79e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("releaseId", releaseId);
        routeValues.put("manualInterventionId", manualInterventionId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, manualInterventionUpdateMetadata, "application/json", "application/json");
        return super.sendRequest(httpRequest, ManualIntervention.class);
    }

    public Release createRelease(ReleaseStartMetadata releaseStartMetadata, String project) {
        UUID locationId = UUID.fromString("a166fde7-27ad-408e-ba75-703c2cc9d500");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.4");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, releaseStartMetadata, "application/json", "application/json");
        return super.sendRequest(httpRequest, Release.class);
    }

    public Release createRelease(ReleaseStartMetadata releaseStartMetadata, UUID project) {
        UUID locationId = UUID.fromString("a166fde7-27ad-408e-ba75-703c2cc9d500");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.4");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, releaseStartMetadata, "application/json", "application/json");
        return super.sendRequest(httpRequest, Release.class);
    }

    public void deleteRelease(String project, int releaseId, String comment) {
        UUID locationId = UUID.fromString("a166fde7-27ad-408e-ba75-703c2cc9d500");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.4");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("releaseId", releaseId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("comment", comment);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, queryParameters, "application/json");
        super.sendRequest(httpRequest);
    }

    public void deleteRelease(UUID project, int releaseId, String comment) {
        UUID locationId = UUID.fromString("a166fde7-27ad-408e-ba75-703c2cc9d500");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.4");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("releaseId", releaseId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("comment", comment);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, queryParameters, "application/json");
        super.sendRequest(httpRequest);
    }

    public Release getRelease(String project, int releaseId, Boolean includeAllApprovals) {
        UUID locationId = UUID.fromString("a166fde7-27ad-408e-ba75-703c2cc9d500");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.4");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("releaseId", releaseId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeAllApprovals", includeAllApprovals);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, Release.class);
    }

    public Release getRelease(UUID project, int releaseId, Boolean includeAllApprovals) {
        UUID locationId = UUID.fromString("a166fde7-27ad-408e-ba75-703c2cc9d500");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.4");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("releaseId", releaseId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeAllApprovals", includeAllApprovals);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, Release.class);
    }

    public ReleaseDefinitionSummary getReleaseDefinitionSummary(String project, int definitionId, int releaseCount, Boolean includeArtifact, List<Integer> definitionEnvironmentIdsFilter) {
        UUID locationId = UUID.fromString("a166fde7-27ad-408e-ba75-703c2cc9d500");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.4");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put("definitionId", String.valueOf(definitionId));
        queryParameters.put("releaseCount", String.valueOf(releaseCount));
        queryParameters.addIfNotNull("includeArtifact", includeArtifact);
        queryParameters.addIfNotNull("definitionEnvironmentIdsFilter", definitionEnvironmentIdsFilter);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, ReleaseDefinitionSummary.class);
    }

    public ReleaseDefinitionSummary getReleaseDefinitionSummary(UUID project, int definitionId, int releaseCount, Boolean includeArtifact, List<Integer> definitionEnvironmentIdsFilter) {
        UUID locationId = UUID.fromString("a166fde7-27ad-408e-ba75-703c2cc9d500");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.4");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put("definitionId", String.valueOf(definitionId));
        queryParameters.put("releaseCount", String.valueOf(releaseCount));
        queryParameters.addIfNotNull("includeArtifact", includeArtifact);
        queryParameters.addIfNotNull("definitionEnvironmentIdsFilter", definitionEnvironmentIdsFilter);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, ReleaseDefinitionSummary.class);
    }

    public InputStream getReleaseRevision(String project, int releaseId, int definitionSnapshotRevision) {
        UUID locationId = UUID.fromString("a166fde7-27ad-408e-ba75-703c2cc9d500");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.4");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("releaseId", releaseId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put("definitionSnapshotRevision", String.valueOf(definitionSnapshotRevision));
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "text/plaint");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getReleaseRevision(UUID project, int releaseId, int definitionSnapshotRevision) {
        UUID locationId = UUID.fromString("a166fde7-27ad-408e-ba75-703c2cc9d500");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.4");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("releaseId", releaseId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put("definitionSnapshotRevision", String.valueOf(definitionSnapshotRevision));
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "text/plaint");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public ArrayList<Release> getReleases(String project, Integer definitionId, Integer definitionEnvironmentId, String searchText, String createdBy, ReleaseStatus statusFilter, Integer environmentStatusFilter, Date minCreatedTime, Date maxCreatedTime, ReleaseQueryOrder queryOrder, Integer top, Integer continuationToken, ReleaseExpands expand, String artifactTypeId, String sourceId, String artifactVersionId, String sourceBranchFilter, Boolean isDeleted) {
        UUID locationId = UUID.fromString("a166fde7-27ad-408e-ba75-703c2cc9d500");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.4");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("definitionId", definitionId);
        queryParameters.addIfNotNull("definitionEnvironmentId", definitionEnvironmentId);
        queryParameters.addIfNotEmpty("searchText", searchText);
        queryParameters.addIfNotEmpty("createdBy", createdBy);
        queryParameters.addIfNotNull("statusFilter", statusFilter);
        queryParameters.addIfNotNull("environmentStatusFilter", environmentStatusFilter);
        queryParameters.addIfNotNull("minCreatedTime", minCreatedTime);
        queryParameters.addIfNotNull("maxCreatedTime", maxCreatedTime);
        queryParameters.addIfNotNull("queryOrder", queryOrder);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("continuationToken", continuationToken);
        queryParameters.addIfNotNull("$expand", expand);
        queryParameters.addIfNotEmpty("artifactTypeId", artifactTypeId);
        queryParameters.addIfNotEmpty("sourceId", sourceId);
        queryParameters.addIfNotEmpty("artifactVersionId", artifactVersionId);
        queryParameters.addIfNotEmpty("sourceBranchFilter", sourceBranchFilter);
        queryParameters.addIfNotNull("isDeleted", isDeleted);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<Release>>(){});
    }

    public ArrayList<Release> getReleases(UUID project, Integer definitionId, Integer definitionEnvironmentId, String searchText, String createdBy, ReleaseStatus statusFilter, Integer environmentStatusFilter, Date minCreatedTime, Date maxCreatedTime, ReleaseQueryOrder queryOrder, Integer top, Integer continuationToken, ReleaseExpands expand, String artifactTypeId, String sourceId, String artifactVersionId, String sourceBranchFilter, Boolean isDeleted) {
        UUID locationId = UUID.fromString("a166fde7-27ad-408e-ba75-703c2cc9d500");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.4");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("definitionId", definitionId);
        queryParameters.addIfNotNull("definitionEnvironmentId", definitionEnvironmentId);
        queryParameters.addIfNotEmpty("searchText", searchText);
        queryParameters.addIfNotEmpty("createdBy", createdBy);
        queryParameters.addIfNotNull("statusFilter", statusFilter);
        queryParameters.addIfNotNull("environmentStatusFilter", environmentStatusFilter);
        queryParameters.addIfNotNull("minCreatedTime", minCreatedTime);
        queryParameters.addIfNotNull("maxCreatedTime", maxCreatedTime);
        queryParameters.addIfNotNull("queryOrder", queryOrder);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("continuationToken", continuationToken);
        queryParameters.addIfNotNull("$expand", expand);
        queryParameters.addIfNotEmpty("artifactTypeId", artifactTypeId);
        queryParameters.addIfNotEmpty("sourceId", sourceId);
        queryParameters.addIfNotEmpty("artifactVersionId", artifactVersionId);
        queryParameters.addIfNotEmpty("sourceBranchFilter", sourceBranchFilter);
        queryParameters.addIfNotNull("isDeleted", isDeleted);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<Release>>(){});
    }

    public void undeleteRelease(String project, int releaseId, String comment) {
        UUID locationId = UUID.fromString("a166fde7-27ad-408e-ba75-703c2cc9d500");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.4");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("releaseId", releaseId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("comment", comment);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, queryParameters, "application/json");
        super.sendRequest(httpRequest);
    }

    public void undeleteRelease(UUID project, int releaseId, String comment) {
        UUID locationId = UUID.fromString("a166fde7-27ad-408e-ba75-703c2cc9d500");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.4");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("releaseId", releaseId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("comment", comment);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, queryParameters, "application/json");
        super.sendRequest(httpRequest);
    }

    public Release updateRelease(Release release, String project, int releaseId) {
        UUID locationId = UUID.fromString("a166fde7-27ad-408e-ba75-703c2cc9d500");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.4");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("releaseId", releaseId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, release, "application/json", "application/json");
        return super.sendRequest(httpRequest, Release.class);
    }

    public Release updateRelease(Release release, UUID project, int releaseId) {
        UUID locationId = UUID.fromString("a166fde7-27ad-408e-ba75-703c2cc9d500");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.4");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("releaseId", releaseId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, release, "application/json", "application/json");
        return super.sendRequest(httpRequest, Release.class);
    }

    public Release updateReleaseResource(ReleaseUpdateMetadata releaseUpdateMetadata, String project, int releaseId) {
        UUID locationId = UUID.fromString("a166fde7-27ad-408e-ba75-703c2cc9d500");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.4");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("releaseId", releaseId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, releaseUpdateMetadata, "application/json", "application/json");
        return super.sendRequest(httpRequest, Release.class);
    }

    public Release updateReleaseResource(ReleaseUpdateMetadata releaseUpdateMetadata, UUID project, int releaseId) {
        UUID locationId = UUID.fromString("a166fde7-27ad-408e-ba75-703c2cc9d500");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.4");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("releaseId", releaseId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, releaseUpdateMetadata, "application/json", "application/json");
        return super.sendRequest(httpRequest, Release.class);
    }

    public ReleaseSettings getReleaseSettings(String project) {
        UUID locationId = UUID.fromString("c63c3718-7cfd-41e0-b89b-81c1ca143437");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, ReleaseSettings.class);
    }

    public ReleaseSettings getReleaseSettings(UUID project) {
        UUID locationId = UUID.fromString("c63c3718-7cfd-41e0-b89b-81c1ca143437");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, ReleaseSettings.class);
    }

    public ReleaseSettings updateReleaseSettings(ReleaseSettings releaseSettings, String project) {
        UUID locationId = UUID.fromString("c63c3718-7cfd-41e0-b89b-81c1ca143437");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, releaseSettings, "application/json", "application/json");
        return super.sendRequest(httpRequest, ReleaseSettings.class);
    }

    public ReleaseSettings updateReleaseSettings(ReleaseSettings releaseSettings, UUID project) {
        UUID locationId = UUID.fromString("c63c3718-7cfd-41e0-b89b-81c1ca143437");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, releaseSettings, "application/json", "application/json");
        return super.sendRequest(httpRequest, ReleaseSettings.class);
    }

    public InputStream getDefinitionRevision(String project, int definitionId, int revision) {
        UUID locationId = UUID.fromString("258b82e0-9d41-43f3-86d6-fef14ddd44bc");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("definitionId", definitionId);
        routeValues.put("revision", revision);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "text/plaint");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getDefinitionRevision(UUID project, int definitionId, int revision) {
        UUID locationId = UUID.fromString("258b82e0-9d41-43f3-86d6-fef14ddd44bc");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("definitionId", definitionId);
        routeValues.put("revision", revision);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "text/plaint");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public ArrayList<ReleaseDefinitionRevision> getReleaseDefinitionHistory(String project, int definitionId) {
        UUID locationId = UUID.fromString("258b82e0-9d41-43f3-86d6-fef14ddd44bc");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("definitionId", definitionId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ReleaseDefinitionRevision>>(){});
    }

    public ArrayList<ReleaseDefinitionRevision> getReleaseDefinitionHistory(UUID project, int definitionId) {
        UUID locationId = UUID.fromString("258b82e0-9d41-43f3-86d6-fef14ddd44bc");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("definitionId", definitionId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ReleaseDefinitionRevision>>(){});
    }

    public ArrayList<SummaryMailSection> getSummaryMailSections(String project, int releaseId) {
        UUID locationId = UUID.fromString("224e92b2-8d13-4c14-b120-13d877c516f8");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("releaseId", releaseId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<SummaryMailSection>>(){});
    }

    public ArrayList<SummaryMailSection> getSummaryMailSections(UUID project, int releaseId) {
        UUID locationId = UUID.fromString("224e92b2-8d13-4c14-b120-13d877c516f8");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("releaseId", releaseId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<SummaryMailSection>>(){});
    }

    public void sendSummaryMail(MailMessage mailMessage, String project, int releaseId) {
        UUID locationId = UUID.fromString("224e92b2-8d13-4c14-b120-13d877c516f8");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("releaseId", releaseId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, mailMessage, "application/json", "application/json");
        super.sendRequest(httpRequest);
    }

    public void sendSummaryMail(MailMessage mailMessage, UUID project, int releaseId) {
        UUID locationId = UUID.fromString("224e92b2-8d13-4c14-b120-13d877c516f8");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("releaseId", releaseId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, mailMessage, "application/json", "application/json");
        super.sendRequest(httpRequest);
    }

    public ArrayList<String> getSourceBranches(String project, int definitionId) {
        UUID locationId = UUID.fromString("0e5def23-78b3-461f-8198-1558f25041c8");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("definitionId", definitionId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<String>>(){});
    }

    public ArrayList<String> getSourceBranches(UUID project, int definitionId) {
        UUID locationId = UUID.fromString("0e5def23-78b3-461f-8198-1558f25041c8");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("definitionId", definitionId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<String>>(){});
    }

    public ArrayList<ReleaseTask> getTasks(String project, int releaseId, int environmentId, Integer attemptId) {
        UUID locationId = UUID.fromString("36b276e0-3c70-4320-a63c-1a2e1466a0d1");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("releaseId", releaseId);
        routeValues.put("environmentId", environmentId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("attemptId", attemptId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ReleaseTask>>(){});
    }

    public ArrayList<ReleaseTask> getTasks(UUID project, int releaseId, int environmentId, Integer attemptId) {
        UUID locationId = UUID.fromString("36b276e0-3c70-4320-a63c-1a2e1466a0d1");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("releaseId", releaseId);
        routeValues.put("environmentId", environmentId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("attemptId", attemptId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ReleaseTask>>(){});
    }

    public ArrayList<ReleaseTask> getTasksForTaskGroup(String project, int releaseId, int environmentId, int releaseDeployPhaseId) {
        UUID locationId = UUID.fromString("4259191d-4b0a-4409-9fb3-09f22ab9bc47");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("releaseId", releaseId);
        routeValues.put("environmentId", environmentId);
        routeValues.put("releaseDeployPhaseId", releaseDeployPhaseId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ReleaseTask>>(){});
    }

    public ArrayList<ReleaseTask> getTasksForTaskGroup(UUID project, int releaseId, int environmentId, int releaseDeployPhaseId) {
        UUID locationId = UUID.fromString("4259191d-4b0a-4409-9fb3-09f22ab9bc47");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("releaseId", releaseId);
        routeValues.put("environmentId", environmentId);
        routeValues.put("releaseDeployPhaseId", releaseDeployPhaseId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ReleaseTask>>(){});
    }

    public ArrayList<QueuedReleaseData> getQueuedReleases(String projectId, Integer releaseId) {
        UUID locationId = UUID.fromString("cf6fc7ba-4ad9-403b-86e6-e372cd3b2327");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("projectId", projectId);
        queryParameters.addIfNotNull("releaseId", releaseId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<QueuedReleaseData>>(){});
    }

    public ArrayList<ArtifactTypeDefinition> getArtifactTypeDefinitions(String project) {
        UUID locationId = UUID.fromString("8efc2a3c-1fc8-4f6d-9822-75e98cecb48f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ArtifactTypeDefinition>>(){});
    }

    public ArrayList<ArtifactTypeDefinition> getArtifactTypeDefinitions(UUID project) {
        UUID locationId = UUID.fromString("8efc2a3c-1fc8-4f6d-9822-75e98cecb48f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ArtifactTypeDefinition>>(){});
    }

    public ArtifactVersionQueryResult getArtifactVersions(String project, int releaseDefinitionId) {
        UUID locationId = UUID.fromString("30fc787e-a9e0-4a07-9fbc-3e903aa051d2");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put("releaseDefinitionId", String.valueOf(releaseDefinitionId));
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, ArtifactVersionQueryResult.class);
    }

    public ArtifactVersionQueryResult getArtifactVersions(UUID project, int releaseDefinitionId) {
        UUID locationId = UUID.fromString("30fc787e-a9e0-4a07-9fbc-3e903aa051d2");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put("releaseDefinitionId", String.valueOf(releaseDefinitionId));
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, ArtifactVersionQueryResult.class);
    }

    public ArtifactVersionQueryResult getArtifactVersionsForSources(List<Artifact> artifacts, String project) {
        UUID locationId = UUID.fromString("30fc787e-a9e0-4a07-9fbc-3e903aa051d2");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, artifacts, "application/json", "application/json");
        return super.sendRequest(httpRequest, ArtifactVersionQueryResult.class);
    }

    public ArtifactVersionQueryResult getArtifactVersionsForSources(List<Artifact> artifacts, UUID project) {
        UUID locationId = UUID.fromString("30fc787e-a9e0-4a07-9fbc-3e903aa051d2");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, artifacts, "application/json", "application/json");
        return super.sendRequest(httpRequest, ArtifactVersionQueryResult.class);
    }

    public ArrayList<ReleaseWorkItemRef> getReleaseWorkItemsRefs(String project, int releaseId, Integer baseReleaseId, Integer top) {
        UUID locationId = UUID.fromString("4f165cc0-875c-4768-b148-f12f78769fab");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("releaseId", releaseId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("baseReleaseId", baseReleaseId);
        queryParameters.addIfNotNull("$top", top);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ReleaseWorkItemRef>>(){});
    }

    public ArrayList<ReleaseWorkItemRef> getReleaseWorkItemsRefs(UUID project, int releaseId, Integer baseReleaseId, Integer top) {
        UUID locationId = UUID.fromString("4f165cc0-875c-4768-b148-f12f78769fab");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("releaseId", releaseId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("baseReleaseId", baseReleaseId);
        queryParameters.addIfNotNull("$top", top);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ReleaseWorkItemRef>>(){});
    }
}

