/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.build.internal.soapextensions;

import com.microsoft.tfs.core.clients.build.IBuildDefinition;
import com.microsoft.tfs.core.clients.build.IBuildDefinitionSpec;
import com.microsoft.tfs.core.clients.build.flags.QueryOptions;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.TFS2010Helper;
import com.microsoft.tfs.core.clients.build.soapextensions.ContinuousIntegrationType;
import com.microsoft.tfs.core.clients.build.soapextensions.DefinitionTriggerType;
import com.microsoft.tfs.core.clients.build.utils.BuildPath;
import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import com.microsoft.tfs.util.StringUtil;
import ms.tfs.build.buildservice._04._BuildDefinitionSpec;

public class BuildDefinitionSpec
extends WebServiceObjectWrapper
implements IBuildDefinitionSpec {
    private String name;
    private String teamProject;

    private BuildDefinitionSpec() {
        super(new _BuildDefinitionSpec());
    }

    public BuildDefinitionSpec(_BuildDefinitionSpec value) {
        super(value);
        String fullPath = value.getFullPath();
        if (fullPath != null) {
            this.name = BuildPath.getItemName(fullPath);
            this.teamProject = BuildPath.getTeamProject(fullPath);
        }
        if (StringUtil.isNullOrEmpty(this.name)) {
            this.name = "*";
        }
        if (StringUtil.isNullOrEmpty(this.teamProject)) {
            this.teamProject = "*";
        }
    }

    public BuildDefinitionSpec(IBuildDefinition definition) {
        this(definition.getTeamProject(), definition.getName());
    }

    public BuildDefinitionSpec(String teamProject) {
        this(teamProject, "*");
    }

    public BuildDefinitionSpec(String teamProject, String definitionName) {
        this(teamProject, definitionName, null);
    }

    public BuildDefinitionSpec(String teamProject, String name, String[] propertyNameFilters) {
        this();
        _BuildDefinitionSpec spec = this.getWebServiceObject();
        this.name = StringUtil.isNullOrEmpty(name) ? "*" : name;
        this.teamProject = StringUtil.isNullOrEmpty(teamProject) ? "*" : teamProject;
        spec.setFullPath(BuildPath.combine(teamProject, name));
        if (propertyNameFilters != null) {
            spec.setPropertyNameFilters(propertyNameFilters);
        }
    }

    public _BuildDefinitionSpec getWebServiceObject() {
        return (_BuildDefinitionSpec)this.webServiceObject;
    }

    @Override
    public QueryOptions getOptions() {
        return QueryOptions.fromWebServiceObject(this.getWebServiceObject().getOptions());
    }

    @Override
    public void setOptions(QueryOptions value) {
        this.getWebServiceObject().setOptions(value.getWebServiceObject());
    }

    @Override
    public DefinitionTriggerType getTriggerType() {
        return new DefinitionTriggerType(this.getWebServiceObject().getTriggerType());
    }

    @Override
    public void setTriggerType(DefinitionTriggerType value) {
        this.getWebServiceObject().setTriggerType(value.getWebServiceObject());
    }

    @Override
    public String getFullPath() {
        return this.getWebServiceObject().getFullPath();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String value) {
        this.name = value;
        this.getWebServiceObject().setFullPath(BuildPath.root(this.teamProject, this.name));
    }

    @Override
    public String getTeamProject() {
        return this.teamProject;
    }

    public void setTeamProject(String value) {
        this.teamProject = value;
        this.getWebServiceObject().setFullPath(BuildPath.root(this.teamProject, this.name));
    }

    @Override
    public ContinuousIntegrationType getContinuousIntegrationType() {
        return TFS2010Helper.convert(new DefinitionTriggerType(this.getWebServiceObject().getTriggerType()));
    }

    @Override
    public void setContinuousIntegrationType(ContinuousIntegrationType value) {
        this.getWebServiceObject().setTriggerType(TFS2010Helper.convert(value).getWebServiceObject());
    }

    @Override
    public String[] getPropertyNameFilters() {
        return this.getWebServiceObject().getPropertyNameFilters();
    }

    @Override
    public void setPropertyNameFilters(String[] value) {
        this.getWebServiceObject().setPropertyNameFilters(value);
    }
}

