/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.build.internal.soapextensions;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.clients.build.AdministrationWebService4;
import com.microsoft.tfs.core.clients.build.BuildConstants;
import com.microsoft.tfs.core.clients.build.BuildQueueWebService4;
import com.microsoft.tfs.core.clients.build.BuildWebService4;
import com.microsoft.tfs.core.clients.build.IBuildAgent;
import com.microsoft.tfs.core.clients.build.IBuildAgentQueryResult;
import com.microsoft.tfs.core.clients.build.IBuildAgentSpec;
import com.microsoft.tfs.core.clients.build.IBuildController;
import com.microsoft.tfs.core.clients.build.IBuildControllerQueryResult;
import com.microsoft.tfs.core.clients.build.IBuildControllerSpec;
import com.microsoft.tfs.core.clients.build.IBuildDefinition;
import com.microsoft.tfs.core.clients.build.IBuildDefinitionQueryResult;
import com.microsoft.tfs.core.clients.build.IBuildDefinitionSpec;
import com.microsoft.tfs.core.clients.build.IBuildDeletionResult;
import com.microsoft.tfs.core.clients.build.IBuildDetail;
import com.microsoft.tfs.core.clients.build.IBuildDetailSpec;
import com.microsoft.tfs.core.clients.build.IBuildQueryResult;
import com.microsoft.tfs.core.clients.build.IBuildRequest;
import com.microsoft.tfs.core.clients.build.IBuildServer;
import com.microsoft.tfs.core.clients.build.IBuildServiceHost;
import com.microsoft.tfs.core.clients.build.IFailure;
import com.microsoft.tfs.core.clients.build.IProcessTemplate;
import com.microsoft.tfs.core.clients.build.IQueuedBuild;
import com.microsoft.tfs.core.clients.build.IQueuedBuildQueryResult;
import com.microsoft.tfs.core.clients.build.IQueuedBuildSpec;
import com.microsoft.tfs.core.clients.build.exceptions.BuildAgentNotFoundForURIException;
import com.microsoft.tfs.core.clients.build.exceptions.BuildAgentNotReadyToSaveException;
import com.microsoft.tfs.core.clients.build.exceptions.BuildControllerNotFoundException;
import com.microsoft.tfs.core.clients.build.exceptions.BuildControllerNotFoundForURIException;
import com.microsoft.tfs.core.clients.build.exceptions.BuildControllerNotReadyToSaveException;
import com.microsoft.tfs.core.clients.build.exceptions.BuildControllerSpecNotUniqueException;
import com.microsoft.tfs.core.clients.build.exceptions.BuildDefinitionFailureException;
import com.microsoft.tfs.core.clients.build.exceptions.BuildDefinitionNotFoundException;
import com.microsoft.tfs.core.clients.build.exceptions.BuildDefinitionNotFoundForURIException;
import com.microsoft.tfs.core.clients.build.exceptions.BuildDefinitionSpecNotUniqueException;
import com.microsoft.tfs.core.clients.build.exceptions.BuildFailureException;
import com.microsoft.tfs.core.clients.build.exceptions.BuildNotFoundException;
import com.microsoft.tfs.core.clients.build.exceptions.BuildNotFoundForURIException;
import com.microsoft.tfs.core.clients.build.exceptions.BuildServiceHostNotFoundException;
import com.microsoft.tfs.core.clients.build.exceptions.BuildServiceHostNotFoundForURIException;
import com.microsoft.tfs.core.clients.build.exceptions.BuildServiceHostSpecNotUniqueException;
import com.microsoft.tfs.core.clients.build.exceptions.BuildSpecNotUniqueException;
import com.microsoft.tfs.core.clients.build.flags.BuildAgentUpdate;
import com.microsoft.tfs.core.clients.build.flags.BuildControllerUpdate;
import com.microsoft.tfs.core.clients.build.flags.BuildQueryOrder;
import com.microsoft.tfs.core.clients.build.flags.BuildServerVersion;
import com.microsoft.tfs.core.clients.build.flags.BuildServiceHostUpdate;
import com.microsoft.tfs.core.clients.build.flags.DeleteOptions;
import com.microsoft.tfs.core.clients.build.flags.QueryDeletedOption;
import com.microsoft.tfs.core.clients.build.flags.QueryOptions;
import com.microsoft.tfs.core.clients.build.flags.QueueOptions;
import com.microsoft.tfs.core.clients.build.flags.QueuedBuildRetryOption;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.Build2008Helper;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.Build2010Helper;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildAgent;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildAgentSpec;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildAgentUpdateOptions;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildController;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildControllerSpec;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildControllerUpdateOptions;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildDefinition;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildDefinitionSpec;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildDetail;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildDetailSpec;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildEnumerationHelper;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildQueueSpec;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildRequest;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildServiceHost;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildServiceHostUpdateOptions;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildUpdateOptions;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.ProcessTemplate;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.QueuedBuild;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.QueuedBuildUpdateOptions;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.TFS2010Helper;
import com.microsoft.tfs.core.clients.build.soapextensions.Agent2008Status;
import com.microsoft.tfs.core.clients.build.soapextensions.ContinuousIntegrationType;
import com.microsoft.tfs.core.clients.build.soapextensions.DefinitionTriggerType;
import com.microsoft.tfs.core.clients.build.soapextensions.ProcessTemplateType;
import com.microsoft.tfs.core.clients.registration.RegistrationClient;
import com.microsoft.tfs.core.clients.registration.ServiceInterface;
import com.microsoft.tfs.core.clients.webservices.IdentityHelper;
import com.microsoft.tfs.core.exceptions.NotSupportedException;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.TreeMap;

public class BuildServer
implements IBuildServer {
    private final TFSTeamProjectCollection tfs;
    private BuildServerVersion serverVersion;
    private Build2008Helper build2008Helper;
    private Build2010Helper build2010Helper;
    private BuildWebService4 buildService4;
    private BuildQueueWebService4 buildQueueService4;
    private AdministrationWebService4 buildAdminService4;
    private static boolean COMPATIBILITY_ENABLED = true;
    private static ProcessTemplateType[] ALL_PROCESS_TEMPLATE_TYPES = new ProcessTemplateType[]{ProcessTemplateType.CUSTOM, ProcessTemplateType.DEFAULT, ProcessTemplateType.UPGRADE};

    public BuildServer(TFSTeamProjectCollection tfs) {
        Check.notNull(tfs, "tfs");
        this.tfs = tfs;
        this.initialize(tfs);
    }

    void initialize(TFSTeamProjectCollection tfs) {
        RegistrationClient registrationClient = tfs.getRegistrationClient();
        ServiceInterface buildService = registrationClient.getServiceInterface("Build", "BuildService4");
        this.serverVersion = buildService != null ? BuildServerVersion.V4 : ((buildService = registrationClient.getServiceInterface("Build", "BuildService3")) != null ? BuildServerVersion.V3 : BuildServerVersion.V2);
        if (this.serverVersion.isLessThanV3() && (!BuildServer.isCompatibilityEnabled() || this.serverVersion.isLessThanV2())) {
            throw new NotSupportedException(Messages.getString("BuildServer2012.ServerNotSupported"));
        }
    }

    public static boolean isCompatibilityEnabled() {
        return COMPATIBILITY_ENABLED;
    }

    public static void setCompatibilityEnabled(boolean value) {
        COMPATIBILITY_ENABLED = value;
    }

    @Override
    public BuildServerVersion getBuildServerVersion() {
        return this.serverVersion;
    }

    @Override
    public String getNoCICheckInComment() {
        return "***NO_CI***";
    }

    @Override
    public TFSTeamProjectCollection getConnection() {
        return this.tfs;
    }

    @Override
    public IBuildDefinition createBuildDefinition(String teamProject) {
        return new BuildDefinition((IBuildServer)this, teamProject);
    }

    @Override
    public IBuildDetailSpec createBuildDetailSpec(String teamProject) {
        return new BuildDetailSpec(teamProject);
    }

    @Override
    public IBuildDetailSpec createBuildDetailSpec(String teamProject, String definitionName) {
        return new BuildDetailSpec(teamProject, definitionName);
    }

    @Override
    public IBuildDetailSpec createBuildDetailSpec(IBuildDefinitionSpec definitionSpec) {
        return new BuildDetailSpec(definitionSpec);
    }

    @Override
    public IBuildDetailSpec createBuildDetailSpec(IBuildDefinition definition) {
        return new BuildDetailSpec(definition);
    }

    @Override
    public IBuildAgentSpec createBuildAgentSpec() {
        return new BuildAgentSpec("*", "*");
    }

    @Override
    public IBuildAgentSpec createBuildAgentSpec(IBuildAgent agent) {
        return new BuildAgentSpec(agent.getName(), agent.getServiceHost().getName(), agent.getTags());
    }

    @Override
    public IBuildAgentSpec createBuildAgentSpec(String name, String computer, String[] tags) {
        return new BuildAgentSpec(name, computer, tags);
    }

    @Override
    public IBuildAgentSpec createBuildAgentSpec(String name, String computer, String[] propertyNameFilters, String[] tags) {
        return new BuildAgentSpec(name, computer, propertyNameFilters, tags);
    }

    @Override
    public IBuildControllerSpec createBuildControllerSpec() {
        return new BuildControllerSpec("*", "*");
    }

    @Override
    public IBuildControllerSpec createBuildControllerSpec(String name, String computer) {
        return new BuildControllerSpec(name, computer);
    }

    @Override
    public IBuildControllerSpec createBuildControllerSpec(String name, String computer, String[] propertyNameFilters, boolean includeAgents) {
        return new BuildControllerSpec(name, computer, propertyNameFilters, includeAgents);
    }

    @Override
    public IBuildDefinitionSpec createBuildDefinitionSpec(IBuildDefinition definition) {
        return new BuildDefinitionSpec(definition);
    }

    @Override
    public IBuildDefinitionSpec createBuildDefinitionSpec(String teamProject) {
        return new BuildDefinitionSpec(teamProject);
    }

    @Override
    public IBuildDefinitionSpec createBuildDefinitionSpec(String teamProject, String definitionName) {
        return new BuildDefinitionSpec(teamProject, definitionName);
    }

    @Override
    public IBuildDefinitionSpec createBuildDefinitionSpec(String teamProject, String definitionName, String[] propertyNameFilters) {
        return new BuildDefinitionSpec(teamProject, definitionName, propertyNameFilters);
    }

    @Override
    public IQueuedBuildSpec createBuildQueueSpec(String teamProject) {
        return new BuildQueueSpec(teamProject);
    }

    @Override
    public IQueuedBuildSpec createBuildQueueSpec(String teamProject, String definitionName) {
        return new BuildQueueSpec(teamProject, definitionName);
    }

    @Override
    public IQueuedBuildSpec createBuildQueueSpec(String[] definitionUris) {
        if (this.getBuildServerVersion().isV3OrGreater()) {
            return new BuildQueueSpec(definitionUris);
        }
        this.throwOperationNotSupported("IQueuedBuildSpec CreateBuildQueueSpec(IEnumerable<Uri>)");
        return null;
    }

    @Override
    public IBuildRequest createBuildRequest(String buildDefinitionUri) {
        return new BuildRequest(this, buildDefinitionUri, null);
    }

    @Override
    public IBuildRequest createBuildRequest(String buildDefinitionUri, String buildControllerUri) {
        return new BuildRequest(this, buildDefinitionUri, buildControllerUri);
    }

    @Override
    public IBuildServiceHost createBuildServiceHost(String name, String baseUrl) {
        return new BuildServiceHost(this, name, baseUrl);
    }

    @Override
    public IBuildServiceHost createBuildServiceHost(String name, String scheme, String host, int port) {
        String uriString;
        try {
            uriString = new URI(scheme, null, host, port, "Build/v3.0/Services", null, null).toString();
        }
        catch (URISyntaxException e) {
            uriString = scheme + ":\\" + host + ":" + port;
        }
        return new BuildServiceHost(this, name, uriString);
    }

    @Override
    public IBuildDefinition[] getAffectedBuildDefinitions(String[] serverItems) {
        return this.getAffectedBuildDefinitions(serverItems, DefinitionTriggerType.ALL);
    }

    @Override
    public IBuildDefinition[] getAffectedBuildDefinitions(String[] serverItems, ContinuousIntegrationType continuousIntegrationType) {
        return this.getAffectedBuildDefinitions(serverItems, TFS2010Helper.convert(continuousIntegrationType));
    }

    @Override
    public IBuildDefinition[] getAffectedBuildDefinitions(String[] serverItems, DefinitionTriggerType triggerType) {
        if (this.getBuildServerVersion().isV2()) {
            return this.getBuild2008Helper().getAffectedBuildDefinitions(serverItems, triggerType);
        }
        if (this.getBuildServerVersion().isV3()) {
            return this.getBuild2010Helper().getAffectedBuildDefinitions(serverItems, triggerType);
        }
        return this.getBuildService().getAffectedBuildDefinitions(serverItems, triggerType);
    }

    @Override
    public IBuildDetail getMinimalBuildDetails(String buildUri) {
        return this.getBuild(buildUri, null, QueryOptions.CONTROLLERS);
    }

    @Override
    public IBuildDetail getAllBuildDetails(String buildUri) {
        return this.getBuild(buildUri, BuildConstants.ALL_INFORMATION_TYPES, QueryOptions.ALL);
    }

    @Override
    public IBuildDetail getBuild(String buildUri) {
        return this.getBuild(buildUri, BuildConstants.ALL_INFORMATION_TYPES, QueryOptions.ALL);
    }

    @Override
    public IBuildDetail getBuild(String buildUri, String[] informationTypes, QueryOptions queryOptions) {
        return this.getBuild(buildUri, informationTypes, queryOptions, QueryDeletedOption.EXCLUDE_DELETED);
    }

    @Override
    public IBuildDetail getBuild(String buildUri, String[] informationTypes, QueryOptions queryOptions, QueryDeletedOption queryDeletedOption) {
        IBuildDetail[] results = this.queryBuildsByURI(new String[]{buildUri}, informationTypes, queryOptions, queryDeletedOption);
        if (results[0] == null) {
            throw new BuildNotFoundForURIException(buildUri, this.getDomainUserName());
        }
        return results[0];
    }

    @Override
    public IBuildDetail getBuild(IBuildDefinitionSpec buildDefinitionSpec, String buildNumber, String[] informationTypes, QueryOptions queryOptions) {
        BuildDetailSpec buildSpec = new BuildDetailSpec(buildDefinitionSpec);
        buildSpec.setBuildNumber(buildNumber);
        buildSpec.setInformationTypes(informationTypes);
        buildSpec.setQueryOptions(queryOptions);
        IBuildQueryResult queryResult = this.queryBuilds(buildSpec);
        if (queryResult.getBuilds().length == 0) {
            throw new BuildNotFoundException(buildNumber, buildDefinitionSpec.getFullPath());
        }
        if (queryResult.getBuilds().length > 1) {
            throw new BuildSpecNotUniqueException(buildNumber, buildDefinitionSpec.getFullPath());
        }
        return queryResult.getBuilds()[0];
    }

    @Override
    public IBuildDetail[] queryBuildsByURI(String[] buildUris, String[] informationTypes, QueryOptions queryOptions) {
        return this.queryBuildsByURI(buildUris, informationTypes, queryOptions, QueryDeletedOption.EXCLUDE_DELETED);
    }

    @Override
    public IBuildDetail[] queryBuildsByURI(String[] buildUris, String[] informationTypes, QueryOptions queryOptions, QueryDeletedOption queryDeletedOption) {
        if (this.getBuildServerVersion().isV2()) {
            return this.getBuild2008Helper().queryBuildsByUri(buildUris, informationTypes, queryOptions, queryDeletedOption);
        }
        if (this.getBuildServerVersion().isV3()) {
            return this.getBuild2010Helper().queryBuildsByUri(buildUris, informationTypes, queryOptions, queryDeletedOption);
        }
        return this.getBuildService().queryBuildsByUri(buildUris, informationTypes, queryOptions, queryDeletedOption).getBuilds();
    }

    @Override
    public IBuildDetail[] queryBuilds(String teamProject) {
        return this.queryBuilds(this.createBuildDefinitionSpec(teamProject));
    }

    @Override
    public IBuildDetail[] queryBuilds(String teamProject, String definitionName) {
        return this.queryBuilds(this.createBuildDefinitionSpec(teamProject, definitionName));
    }

    @Override
    public IBuildDetail[] queryBuilds(IBuildDefinitionSpec definitionSpec) {
        IBuildQueryResult queryResult = this.queryBuilds(this.createBuildDetailSpec(definitionSpec));
        if (queryResult.getFailures().length > 0) {
            IFailure failure = queryResult.getFailures()[0];
            throw new BuildFailureException(definitionSpec.getTeamProject(), definitionSpec.getName(), failure);
        }
        return queryResult.getBuilds();
    }

    @Override
    public IBuildDetail[] queryBuilds(IBuildDefinition definition) {
        return this.queryBuilds(new BuildDefinitionSpec(definition));
    }

    @Override
    public IBuildQueryResult queryBuilds(IBuildDetailSpec buildDetailSpec) {
        return this.queryBuilds(new IBuildDetailSpec[]{buildDetailSpec})[0];
    }

    @Override
    public IBuildQueryResult[] queryBuilds(IBuildDetailSpec[] buildDetailSpecs) {
        IBuildQueryResult[] results = null;
        results = this.getBuildServerVersion().isV2() ? this.getBuild2008Helper().queryBuilds(buildDetailSpecs) : (this.getBuildServerVersion().isV3() ? this.getBuild2010Helper().queryBuilds(buildDetailSpecs) : this.getBuildService().queryBuilds(buildDetailSpecs));
        BuildServer.sortBuildsOfResults(buildDetailSpecs, results);
        return results;
    }

    private static void sortBuildsOfResults(IBuildDetailSpec[] buildDetailSpecs, IBuildQueryResult[] results) {
        for (int i = 0; i < buildDetailSpecs.length; ++i) {
            IBuildDetailSpec buildDetailSpec = buildDetailSpecs[i];
            BuildQueryOrder order = buildDetailSpec.getQueryOrder();
            Comparator<IBuildDetail> comparer = order.equals(BuildQueryOrder.FINISH_TIME_ASCENDING) ? new Comparator<IBuildDetail>(){

                @Override
                public int compare(IBuildDetail o1, IBuildDetail o2) {
                    return o1.getFinishTime().compareTo(o2.getFinishTime());
                }
            } : (order.equals(BuildQueryOrder.FINISH_TIME_DESCENDING) ? new Comparator<IBuildDetail>(){

                @Override
                public int compare(IBuildDetail o1, IBuildDetail o2) {
                    return -1 * o1.getFinishTime().compareTo(o2.getFinishTime());
                }
            } : (order.equals(BuildQueryOrder.START_TIME_DESCENDING) ? new Comparator<IBuildDetail>(){

                @Override
                public int compare(IBuildDetail o1, IBuildDetail o2) {
                    return -1 * o1.getStartTime().compareTo(o2.getStartTime());
                }
            } : new Comparator<IBuildDetail>(){

                @Override
                public int compare(IBuildDetail o1, IBuildDetail o2) {
                    return o1.getStartTime().compareTo(o2.getStartTime());
                }
            }));
            Arrays.sort(results[i].getBuilds(), comparer);
        }
    }

    @Override
    public IBuildDeletionResult[] deleteBuilds(IBuildDetail[] builds) {
        return this.deleteBuilds(builds, DeleteOptions.ALL);
    }

    @Override
    public IBuildDeletionResult[] deleteBuilds(IBuildDetail[] builds, DeleteOptions options) {
        return this.deleteBuilds(BuildServer.getUrisForBuilds(builds), options);
    }

    @Override
    public IBuildDeletionResult[] deleteBuilds(String[] uris) {
        return this.deleteBuilds(uris, DeleteOptions.ALL);
    }

    @Override
    public IBuildDeletionResult[] deleteBuilds(String[] uris, DeleteOptions options) {
        if (uris == null || uris.length == 0) {
            return new IBuildDeletionResult[0];
        }
        if (this.getBuildServerVersion().isLessThanV3() && !options.equals(DeleteOptions.ALL)) {
            String format = Messages.getString("BuildServer2012.DeleteOptionsNotSupportedFormat");
            throw new NotSupportedException(MessageFormat.format(format, options));
        }
        if (this.getBuildServerVersion().isV2()) {
            return this.getBuild2008Helper().deleteBuilds(uris, options);
        }
        if (this.getBuildServerVersion().isV3()) {
            return this.getBuild2010Helper().deleteBuilds(uris, options);
        }
        return this.getBuildService().deleteBuilds(uris, options);
    }

    @Override
    public void destroyBuilds(IBuildDetail[] builds) {
        this.destroyBuilds(BuildServer.getUrisForBuilds(builds));
    }

    @Override
    public void destroyBuilds(String[] buildUris) {
        if (this.getBuildServerVersion().isV3()) {
            this.getBuild2010Helper().destroyBuilds(buildUris);
        } else if (this.getBuildServerVersion().isV4()) {
            this.getBuildService().destroyBuilds(buildUris);
        }
    }

    @Override
    public IBuildDetail[] saveBuilds(IBuildDetail[] builds) {
        if (builds == null || builds.length == 0) {
            return builds;
        }
        BuildUpdateOptions[] updateOptions = new BuildUpdateOptions[builds.length];
        HashMap<String, BuildUpdateOptions> actualUpdates = new HashMap<String, BuildUpdateOptions>();
        for (int i = 0; i < builds.length; ++i) {
            updateOptions[i] = ((BuildDetail)builds[i]).getUpdateOptions();
        }
        IBuildDetail[] result = this.getBuildServerVersion().isV2() ? this.getBuild2008Helper().updateBuilds(updateOptions) : (this.getBuildServerVersion().isV3() ? this.getBuild2010Helper().updateBuilds(updateOptions) : this.getBuildService().updateBuilds(updateOptions));
        for (BuildDetail buildDetail : result) {
            if (buildDetail == null) continue;
            BuildDetail build = buildDetail;
            actualUpdates.put(buildDetail.getURI(), build.getUpdateOptions());
        }
        for (IBuildDetail iBuildDetail : builds) {
            if (iBuildDetail == null) continue;
            ((BuildDetail)iBuildDetail).setUpdateOptions((BuildUpdateOptions)actualUpdates.get(iBuildDetail.getURI()));
        }
        return result;
    }

    @Override
    public IBuildDefinition getBuildDefinition(String buildDefinitionUri) {
        return this.getBuildDefinition(buildDefinitionUri, BuildConstants.NO_PROPERTY_NAMES, QueryOptions.CONTROLLERS);
    }

    @Override
    public IBuildDefinition getBuildDefinition(String buildDefinitionUri, QueryOptions options) {
        return this.getBuildDefinition(buildDefinitionUri, BuildConstants.NO_PROPERTY_NAMES, options);
    }

    @Override
    public IBuildDefinition getBuildDefinition(String buildDefinitionUri, String[] propertyNameFilters, QueryOptions options) {
        IBuildDefinition[] results = this.queryBuildDefinitionsByURI(new String[]{buildDefinitionUri}, propertyNameFilters, options);
        if (results[0] == null) {
            throw new BuildDefinitionNotFoundForURIException(buildDefinitionUri, this.getDomainUserName());
        }
        return results[0];
    }

    @Override
    public IBuildDefinition getBuildDefinition(String teamProject, String name) {
        return this.getBuildDefinition(teamProject, name, QueryOptions.CONTROLLERS);
    }

    @Override
    public IBuildDefinition getBuildDefinition(String teamProject, String name, QueryOptions options) {
        BuildDefinitionSpec definitionSpec = new BuildDefinitionSpec(teamProject, name);
        definitionSpec.setOptions(options);
        IBuildDefinitionQueryResult queryResult = this.queryBuildDefinitions(definitionSpec);
        if (queryResult.getFailures().length > 0) {
            IFailure failure = queryResult.getFailures()[0];
            throw new BuildDefinitionFailureException(teamProject, name, failure);
        }
        if (queryResult.getDefinitions().length == 0) {
            throw new BuildDefinitionNotFoundException(teamProject, name);
        }
        if (queryResult.getDefinitions().length > 1) {
            throw new BuildDefinitionSpecNotUniqueException(teamProject, name);
        }
        return queryResult.getDefinitions()[0];
    }

    @Override
    public IBuildDefinition[] queryBuildDefinitionsByURI(String[] buildDefinitionUris) {
        return this.queryBuildDefinitionsByURI(buildDefinitionUris, BuildConstants.NO_PROPERTY_NAMES, QueryOptions.NONE);
    }

    @Override
    public IBuildDefinition[] queryBuildDefinitionsByURI(String[] buildDefinitionUris, QueryOptions options) {
        return this.queryBuildDefinitionsByURI(buildDefinitionUris, BuildConstants.NO_PROPERTY_NAMES, options);
    }

    @Override
    public IBuildDefinition[] queryBuildDefinitionsByURI(String[] buildDefinitionUris, String[] propertyNameFilters, QueryOptions options) {
        if (this.getBuildServerVersion().isV2()) {
            return this.getBuild2008Helper().queryBuildDefinitionsByUri(buildDefinitionUris).getDefinitions();
        }
        if (this.getBuildServerVersion().isV3()) {
            return this.getBuild2010Helper().queryBuildDefinitionsByUri(buildDefinitionUris, options).getDefinitions();
        }
        return this.getBuildService().queryBuildDefinitionsByUri(buildDefinitionUris, propertyNameFilters, options).getDefinitions();
    }

    @Override
    public IBuildDefinition[] queryBuildDefinitions(String teamProject) {
        return this.queryBuildDefinitions(teamProject, QueryOptions.CONTROLLERS);
    }

    @Override
    public IBuildDefinition[] queryBuildDefinitions(String teamProject, QueryOptions options) {
        IBuildDefinitionSpec definitionSpec = this.createBuildDefinitionSpec(teamProject);
        definitionSpec.setOptions(options);
        IBuildDefinitionQueryResult queryResult = this.queryBuildDefinitions(definitionSpec);
        if (queryResult.getFailures().length > 0) {
            IFailure failure = queryResult.getFailures()[0];
            throw new BuildDefinitionFailureException(teamProject, "*", failure);
        }
        return queryResult.getDefinitions();
    }

    @Override
    public IBuildDefinitionQueryResult queryBuildDefinitions(IBuildDefinitionSpec buildDefinitionSpec) {
        return this.queryBuildDefinitions(new IBuildDefinitionSpec[]{buildDefinitionSpec})[0];
    }

    @Override
    public IBuildDefinitionQueryResult[] queryBuildDefinitions(IBuildDefinitionSpec[] buildDefinitionSpecs) {
        if (this.getBuildServerVersion().isV2()) {
            return this.getBuild2008Helper().queryBuildDefinitions(buildDefinitionSpecs);
        }
        if (this.getBuildServerVersion().isV3()) {
            return this.getBuild2010Helper().queryBuildDefinitions(buildDefinitionSpecs);
        }
        return this.getBuildService().queryBuildDefinitions(buildDefinitionSpecs);
    }

    @Override
    public void deleteBuildDefinitions(IBuildDefinition[] definitions) {
        if (definitions == null || definitions.length == 0) {
            return;
        }
        String[] uris = new String[definitions.length];
        for (int i = 0; i < definitions.length; ++i) {
            uris[i] = definitions[i].getURI();
        }
        this.deleteBuildDefinitions(uris);
    }

    @Override
    public void deleteBuildDefinitions(String[] definitionUris) {
        if (definitionUris == null || definitionUris.length == 0) {
            return;
        }
        if (this.getBuildServerVersion().isV2()) {
            this.getBuild2008Helper().deleteBuildDefinitions(definitionUris);
        } else if (this.getBuildServerVersion().isV3()) {
            this.getBuild2010Helper().deleteBuildDefinitions(definitionUris);
        } else {
            this.getBuildService().deleteBuildDefinitions(definitionUris);
        }
    }

    @Override
    public IBuildDefinition[] saveBuildDefinitions(IBuildDefinition[] definitions) {
        ArrayList<BuildDefinition> definitionsToAdd = new ArrayList<BuildDefinition>();
        ArrayList<BuildDefinition> definitionsToUpdate = new ArrayList<BuildDefinition>();
        HashMap<Integer, Integer> addIndices = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> updateIndices = new HashMap<Integer, Integer>();
        HashMap<String, IBuildDefinition> updatedDefinitions = new HashMap<String, IBuildDefinition>();
        IBuildDefinition[] result = new IBuildDefinition[definitions.length];
        for (int i = 0; i < definitions.length; ++i) {
            BuildDefinition definition = (BuildDefinition)definitions[i];
            definition.prepareToSave();
            if (definition.getURI() == null) {
                definitionsToAdd.add(definition);
                addIndices.put(definitionsToAdd.size() - 1, i);
                continue;
            }
            definitionsToUpdate.add(definition);
            updateIndices.put(definitionsToUpdate.size() - 1, i);
        }
        if (definitionsToAdd.size() > 0) {
            IBuildDefinition[] toAdd = definitionsToAdd.toArray(new BuildDefinition[definitionsToAdd.size()]);
            IBuildDefinition[] addResult = this.getBuildServerVersion().isV2() ? this.getBuild2008Helper().addBuildDefinitions((BuildDefinition[])toAdd) : (this.getBuildServerVersion().isV3() ? this.getBuild2010Helper().addBuildDefinitions((BuildDefinition[])toAdd) : this.getBuildService().addBuildDefinitions(toAdd));
            for (int i = 0; i < addResult.length; ++i) {
                BuildDefinition definition = (BuildDefinition)addResult[i];
                definition.setAttachedProperties(((BuildDefinition)definitionsToAdd.get(i)).getAttachedProperties());
                definition.getAttachedProperties().clearChangedProperties();
                ((BuildDefinition)definitionsToAdd.get(i)).setURI(addResult[i].getURI());
                result[((Integer)addIndices.get((Object)Integer.valueOf((int)i))).intValue()] = addResult[i];
            }
        }
        if (definitionsToUpdate.size() > 0) {
            IBuildDefinition[] toUpdate = definitionsToUpdate.toArray(new BuildDefinition[definitionsToUpdate.size()]);
            IBuildDefinition[] updateResult = this.getBuildServerVersion().isV2() ? this.getBuild2008Helper().updateBuildDefinitions((BuildDefinition[])toUpdate) : (this.getBuildServerVersion().isV3() ? this.getBuild2010Helper().updateBuildDefinitions((BuildDefinition[])toUpdate) : this.getBuildService().updateBuildDefinitions(toUpdate));
            if (definitionsToAdd.size() == 0) {
                return updateResult;
            }
            for (IBuildDefinition updatedDefinition : updateResult) {
                updatedDefinitions.put(updatedDefinition.getURI(), updatedDefinition);
            }
            for (int i = 0; i < definitionsToUpdate.size(); ++i) {
                int updatedIndex = (Integer)updateIndices.get(i);
                result[updatedIndex] = (IBuildDefinition)updatedDefinitions.get(definitions[updatedIndex].getURI());
                BuildDefinition definition = (BuildDefinition)result[updatedIndex];
                definition.setAttachedProperties(((BuildDefinition)definitions[updatedIndex]).getAttachedProperties());
                definition.getAttachedProperties().clearChangedProperties();
            }
        }
        return result;
    }

    @Override
    public void deleteBuildServiceHost(String serviceHostUri) {
        if (this.getBuildServerVersion().isV2()) {
            this.throwMethodNotSupported("DeleteBuildServiceHost");
        }
        if (this.getBuildServerVersion().isV3()) {
            this.getBuild2010Helper().deleteBuildServiceHost(serviceHostUri);
        } else {
            this.getAdministrationService().deleteBuildServiceHost(serviceHostUri);
        }
    }

    @Override
    public IBuildServiceHost getBuildServiceHostByName(String computer) {
        IBuildServiceHost[] results;
        if (this.getBuildServerVersion().isV2()) {
            this.throwMethodNotSupported("GetBuildServiceHost");
        }
        if ((results = this.queryBuildServiceHosts(computer)).length == 0) {
            throw new BuildServiceHostNotFoundException(computer);
        }
        if (results.length > 1) {
            throw new BuildServiceHostSpecNotUniqueException(computer);
        }
        return results[0];
    }

    @Override
    public IBuildServiceHost getBuildServiceHostByURI(String buildServiceHostUri) {
        IBuildServiceHost[] results;
        if (this.getBuildServerVersion().isV2()) {
            this.throwMethodNotSupported("GetBuildServiceHost");
        }
        if ((results = this.queryBuildServiceHostsByURI(new String[]{buildServiceHostUri}))[0] == null) {
            throw new BuildServiceHostNotFoundForURIException(buildServiceHostUri, this.getDomainUserName());
        }
        return results[0];
    }

    @Override
    public IBuildServiceHost[] queryBuildServiceHosts(String computer) {
        if (this.getBuildServerVersion().isLessThanV3()) {
            this.throwMethodNotSupported("QueryBuildServiceHosts");
        }
        if (this.getBuildServerVersion().isV3()) {
            return this.getBuild2010Helper().queryBuildServiceHosts(computer).getServiceHosts();
        }
        return this.getAdministrationService().queryBuildServiceHosts(computer).getServiceHosts();
    }

    @Override
    public IBuildServiceHost[] queryBuildServiceHostsByURI(String[] buildServiceHostUris) {
        if (this.getBuildServerVersion().isLessThanV3()) {
            this.throwMethodNotSupported("QueryBuildServiceHostsByUri");
        }
        if (this.getBuildServerVersion().isV3()) {
            return this.getBuild2010Helper().queryBuildServiceHostsByUri(buildServiceHostUris).getServiceHosts();
        }
        return this.getAdministrationService().queryBuildServiceHostsByUri(buildServiceHostUris).getServiceHosts();
    }

    @Override
    public void saveBuildServiceHost(IBuildServiceHost serviceHost) {
        if (this.getBuildServerVersion().isV2()) {
            this.throwMethodNotSupported("SaveBuildServiceHost");
        }
        if (serviceHost.getURI() == null) {
            BuildServiceHost result = this.getBuildServerVersion().isV3() ? this.getBuild2010Helper().addBuildServiceHost((BuildServiceHost)serviceHost) : this.getAdministrationService().addBuildServiceHost((BuildServiceHost)serviceHost);
            ((BuildServiceHost)serviceHost).setURI(result.getURI());
            if (serviceHost.getController() != null) {
                ((BuildController)serviceHost.getController()).setServiceHost(serviceHost);
            }
            for (IBuildAgent agent : serviceHost.getAgents()) {
                ((BuildAgent)agent).setServiceHost(serviceHost);
            }
        } else {
            BuildServiceHostUpdateOptions update = ((BuildServiceHost)serviceHost).getUpdateOptions();
            if (!update.getFields().equals(BuildServiceHostUpdate.NONE)) {
                if (this.getBuildServerVersion().isV3()) {
                    this.getBuild2010Helper().updateBuildServiceHost(update);
                } else if (this.getBuildServerVersion().isV4()) {
                    this.getAdministrationService().updateBuildServiceHost(update);
                }
                ((BuildServiceHost)serviceHost).setUpdateOptions(update);
            }
        }
    }

    @Override
    public void testConnectionsForBuildMachine(IBuildServiceHost host) {
        IBuildServiceHost result;
        if (this.getBuildServerVersion().isLessThanV3()) {
            this.throwMethodNotSupported("TestConnectionForBuildMachine");
        }
        if (this.getBuildServerVersion().isV3() && (result = this.getBuild2010Helper().testBuildServiceHostConnections(host.getURI()).getServiceHosts()[0]) == null) {
            throw new BuildServiceHostNotFoundForURIException(host.getURI(), this.getDomainUserName());
        }
    }

    @Override
    public void testConnectionForBuildController(IBuildController controller) {
        IBuildController result;
        if (this.getBuildServerVersion().isLessThanV3()) {
            this.throwMethodNotSupported("TestConnectionForBuildController");
        }
        if (this.getBuildServerVersion().isV3() && (result = this.getBuild2010Helper().testBuildControllerConnection(controller.getURI()).getControllers()[0]) == null) {
            throw new BuildControllerNotFoundForURIException(controller.getURI(), this.getDomainUserName());
        }
    }

    @Override
    public void testConnectionForBuildAgent(IBuildAgent agent) {
        IBuildAgent result;
        if (this.getBuildServerVersion().isLessThanV3()) {
            this.throwMethodNotSupported("TestConnectionForBuildAgent");
        }
        if (this.getBuildServerVersion().isV3() && (result = this.getBuild2010Helper().testBuildAgentConnection(agent.getURI()).getAgents()[0]) == null) {
            throw new BuildAgentNotFoundForURIException(agent.getURI(), this.getDomainUserName());
        }
    }

    @Override
    public IBuildAgent getBuildAgent(String buildAgentUri) {
        return this.getBuildAgent(buildAgentUri, BuildConstants.NO_PROPERTY_NAMES);
    }

    @Override
    public IBuildAgent getBuildAgent(String buildAgentUri, String[] propertyNameFilters) {
        IBuildAgent[] results;
        if (this.getBuildServerVersion().isLessThanV3()) {
            this.throwMethodNotSupported("GetBuildAgent");
        }
        if ((results = this.queryBuildAgentsByURI(new String[]{buildAgentUri}, propertyNameFilters))[0] == null) {
            throw new BuildAgentNotFoundForURIException(buildAgentUri, this.getDomainUserName());
        }
        return results[0];
    }

    @Override
    public IBuildAgent[] queryBuildAgentsByURI(String[] buildAgentUris) {
        return this.queryBuildAgentsByURI(buildAgentUris, BuildConstants.NO_PROPERTY_NAMES);
    }

    @Override
    public IBuildAgent[] queryBuildAgentsByURI(String[] buildAgentUris, String[] propertyNameFilters) {
        if (this.getBuildServerVersion().isLessThanV3()) {
            this.throwMethodNotSupported("QueryBuildAgentsByUri");
        }
        if (this.getBuildServerVersion().isV3()) {
            return this.getBuild2010Helper().queryBuildAgentsByUri(buildAgentUris).getAgents();
        }
        return this.getAdministrationService().queryBuildAgentsByUri(buildAgentUris, propertyNameFilters).getAgents();
    }

    @Override
    public IBuildAgentQueryResult queryBuildAgents(IBuildAgentSpec buildAgentSpec) {
        return this.queryBuildAgents(new IBuildAgentSpec[]{buildAgentSpec})[0];
    }

    @Override
    public IBuildAgentQueryResult[] queryBuildAgents(IBuildAgentSpec[] buildAgentSpecs) {
        if (this.getBuildServerVersion().isLessThanV3()) {
            this.throwMethodNotSupported("QueryBuildAgents");
        }
        if (this.getBuildServerVersion().isV3()) {
            return this.getBuild2010Helper().queryBuildAgents(buildAgentSpecs);
        }
        return this.getAdministrationService().queryBuildAgents(buildAgentSpecs);
    }

    @Override
    public void deleteBuildAgents(IBuildAgent[] agents) {
        if (this.getBuildServerVersion().isLessThanV3()) {
            this.throwMethodNotSupported("DeleteBuildAgents");
        }
        if (agents == null || agents.length == 0) {
            return;
        }
        String[] uris = new String[agents.length];
        for (int i = 0; i < agents.length; ++i) {
            uris[i] = agents[i].getURI();
        }
        this.deleteBuildAgents(uris);
    }

    @Override
    public void deleteBuildAgents(String[] agentUris) {
        if (this.getBuildServerVersion().isLessThanV3()) {
            this.throwMethodNotSupported("DeleteBuildAgents");
        }
        if (agentUris == null || agentUris.length == 0) {
            return;
        }
        if (this.getBuildServerVersion().isV3()) {
            this.getBuild2010Helper().deleteBuildAgents(agentUris);
        } else {
            this.getAdministrationService().deleteBuildAgents(agentUris);
        }
    }

    @Override
    public IBuildAgent[] saveBuildAgents(IBuildAgent[] agents) {
        if (this.getBuildServerVersion().isLessThanV3()) {
            this.throwMethodNotSupported("SaveBuildAgents");
        }
        ArrayList<BuildAgent> agentsToUpdate = new ArrayList<BuildAgent>();
        TreeMap<String, BuildAgent> agentsToAdd = new TreeMap<String, BuildAgent>(String.CASE_INSENSITIVE_ORDER);
        for (int i = 0; i < agents.length; ++i) {
            BuildAgent agent = (BuildAgent)agents[i];
            if (agent.getServiceHostURI() == null || agent.getControllerURI() == null) {
                throw new BuildAgentNotReadyToSaveException(agent.getName());
            }
            agent.prepareToSave();
            if (agent.getURI() == null) {
                String key = agent.getServiceHostURI() + "." + agent.getName();
                agentsToAdd.put(key, agent);
                continue;
            }
            agentsToUpdate.add(agent);
        }
        if (agentsToAdd.size() > 0) {
            BuildAgent[] addRequests = new BuildAgent[agentsToAdd.size()];
            agentsToAdd.values().toArray(addRequests);
            BuildAgent[] addResults = this.getBuildServerVersion().isV3() ? this.getBuild2010Helper().addBuildAgents(addRequests) : this.getAdministrationService().addBuildAgents(addRequests);
            for (BuildAgent addResult : addResults) {
                String key = addResult.getServiceHostURI() + "." + addResult.getName();
                ((BuildAgent)agentsToAdd.get(key)).setURI(addResult.getURI());
                ((BuildAgent)agentsToAdd.get(key)).setUpdateOptions(addResult.getUpdateOptions());
            }
        }
        if (agentsToUpdate.size() > 0) {
            int i;
            ArrayList<BuildAgentUpdateOptions> actualUpdates = new ArrayList<BuildAgentUpdateOptions>();
            ArrayList<BuildAgentUpdateOptions> updateOptions = new ArrayList<BuildAgentUpdateOptions>(agentsToUpdate.size());
            for (i = 0; i < agentsToUpdate.size(); ++i) {
                BuildAgentUpdateOptions update = ((BuildAgent)agentsToUpdate.get(i)).getUpdateOptions();
                if (!update.getFields().equals(BuildAgentUpdate.NONE)) {
                    actualUpdates.add(update);
                    updateOptions.add(i, update);
                    continue;
                }
                updateOptions.add(i, null);
            }
            if (actualUpdates.size() > 0) {
                if (this.getBuildServerVersion().isV3()) {
                    this.getBuild2010Helper().updateBuildAgents(actualUpdates.toArray(new BuildAgentUpdateOptions[actualUpdates.size()]));
                } else {
                    this.getAdministrationService().updateBuildAgents(actualUpdates.toArray(new BuildAgentUpdateOptions[actualUpdates.size()]));
                }
                for (i = 0; i < agentsToUpdate.size(); ++i) {
                    if (updateOptions.get(i) == null) continue;
                    ((BuildAgent)agentsToUpdate.get(i)).setUpdateOptions((BuildAgentUpdateOptions)updateOptions.get(i));
                }
            }
        }
        return agents;
    }

    @Override
    public IBuildController getBuildController(String buildControllerUri, boolean includeAgents) {
        return this.getBuildController(buildControllerUri, BuildConstants.NO_PROPERTY_NAMES, includeAgents);
    }

    @Override
    public IBuildController getBuildController(String buildControllerUri, String[] propertyNameFilters, boolean includeAgents) {
        IBuildController[] results = this.queryBuildControllersByURI(new String[]{buildControllerUri}, propertyNameFilters, includeAgents);
        if (results[0] == null) {
            throw new BuildControllerNotFoundForURIException(buildControllerUri, this.getDomainUserName());
        }
        return results[0];
    }

    @Override
    public IBuildController getBuildController(String name) {
        IBuildControllerQueryResult result = this.queryBuildControllers(new BuildControllerSpec(name, "*", BuildConstants.NO_PROPERTY_NAMES, true));
        if (result.getControllers().length == 0) {
            throw new BuildControllerNotFoundException(name);
        }
        if (result.getControllers().length > 1) {
            throw new BuildControllerSpecNotUniqueException(name);
        }
        return result.getControllers()[0];
    }

    @Override
    public IBuildController[] queryBuildControllers() {
        return this.queryBuildControllers(true);
    }

    @Override
    public IBuildController[] queryBuildControllers(boolean includeAgents) {
        IBuildControllerSpec spec = this.createBuildControllerSpec("*", "*");
        spec.setIncludeAgents(includeAgents);
        return this.queryBuildControllers(spec).getControllers();
    }

    @Override
    public IBuildController[] queryBuildControllersByURI(String[] buildControllerUris, boolean includeAgents) {
        return this.queryBuildControllersByURI(buildControllerUris, BuildConstants.NO_PROPERTY_NAMES, includeAgents);
    }

    @Override
    public IBuildController[] queryBuildControllersByURI(String[] buildControllerUris, String[] propertyNameFilters, boolean includeAgents) {
        if (this.getBuildServerVersion().isV2()) {
            return this.getBuild2008Helper().queryBuildControllersByUri(buildControllerUris, includeAgents).getControllers();
        }
        if (this.getBuildServerVersion().isV3()) {
            return this.getBuild2010Helper().queryBuildControllersByUri(buildControllerUris, includeAgents).getControllers();
        }
        return this.getAdministrationService().queryBuildControllersByUri(buildControllerUris, propertyNameFilters, includeAgents).getControllers();
    }

    @Override
    public IBuildControllerQueryResult queryBuildControllers(IBuildControllerSpec buildControllerSpec) {
        return this.queryBuildControllers(new IBuildControllerSpec[]{buildControllerSpec})[0];
    }

    @Override
    public IBuildControllerQueryResult[] queryBuildControllers(IBuildControllerSpec[] buildControllerSpecs) {
        if (this.getBuildServerVersion().isV2()) {
            return this.getBuild2008Helper().queryBuildControllers(buildControllerSpecs);
        }
        if (this.getBuildServerVersion().isV3()) {
            return this.getBuild2010Helper().queryBuildControllers(buildControllerSpecs);
        }
        return this.getAdministrationService().queryBuildControllers(buildControllerSpecs);
    }

    @Override
    public void deleteBuildControllers(IBuildController[] controllers) {
        if (this.getBuildServerVersion().isLessThanV3()) {
            this.throwMethodNotSupported("DeleteBuildControllers");
        }
        if (controllers == null || controllers.length == 0) {
            return;
        }
        String[] controllerUris = new String[controllers.length];
        for (int i = 0; i < controllers.length; ++i) {
            controllerUris[i] = controllers[i].getURI();
        }
        this.deleteBuildControllers(controllerUris);
    }

    @Override
    public void deleteBuildControllers(String[] controllerUris) {
        if (this.getBuildServerVersion().isLessThanV3()) {
            this.throwMethodNotSupported("DeleteBuildControllers");
        }
        if (this.getBuildServerVersion().isV3()) {
            this.getBuild2010Helper().deleteBuildControllers(controllerUris);
        } else {
            this.getAdministrationService().deleteBuildControllers(controllerUris);
        }
    }

    @Override
    public IBuildController[] saveBuildControllers(IBuildController[] controllers) {
        if (this.getBuildServerVersion().isLessThanV3()) {
            this.throwMethodNotSupported("SaveBuildControllers");
        }
        ArrayList<BuildController> controllersToUpdate = new ArrayList<BuildController>();
        HashMap<String, BuildController> controllersToAdd = new HashMap<String, BuildController>();
        for (int i = 0; i < controllers.length; ++i) {
            BuildController controller = (BuildController)controllers[i];
            if (controller.getServiceHostURI() == null) {
                throw new BuildControllerNotReadyToSaveException(controller.getName());
            }
            controller.prepareToSave();
            if (controller.getURI() == null) {
                controllersToAdd.put(controller.getServiceHostURI(), controller);
                continue;
            }
            controllersToUpdate.add(controller);
        }
        if (controllersToAdd.size() > 0) {
            BuildController[] addRequests = new BuildController[controllersToAdd.size()];
            controllersToAdd.values().toArray(addRequests);
            BuildController[] addResults = this.getBuildServerVersion().isV3() ? this.getBuild2010Helper().addBuildControllers(addRequests) : this.getAdministrationService().addBuildControllers(addRequests);
            for (BuildController addResult : addResults) {
                BuildController controller = (BuildController)controllersToAdd.get(addResult.getServiceHostURI());
                controller.setURI(addResult.getURI());
                ((BuildController)controllersToAdd.get(addResult.getServiceHostURI())).setUpdateOptions(addResult.getUpdateOptions());
                ArrayList<IBuildAgent> agents = new ArrayList<IBuildAgent>();
                while (controller.getAgents().length > 0) {
                    IBuildAgent agent = controller.getAgents()[0];
                    agents.add(agent);
                    controller.removeBuildAgent(agent);
                }
                for (IBuildAgent agent : agents) {
                    ((BuildAgent)agent).setController(controller);
                }
            }
        }
        if (controllersToUpdate.size() > 0) {
            ArrayList<BuildControllerUpdateOptions> actualUpdates = new ArrayList<BuildControllerUpdateOptions>();
            ArrayList<BuildControllerUpdateOptions> updateOptions = new ArrayList<BuildControllerUpdateOptions>(controllersToUpdate.size());
            for (int i = 0; i < controllersToUpdate.size(); ++i) {
                BuildControllerUpdateOptions update = ((BuildController)controllersToUpdate.get(i)).getUpdateOptions();
                if (!update.getFields().equals(BuildControllerUpdate.NONE)) {
                    actualUpdates.add(update);
                    updateOptions.add(i, update);
                    continue;
                }
                updateOptions.add(i, null);
            }
            if (actualUpdates.size() > 0) {
                BuildControllerUpdateOptions[] array = new BuildControllerUpdateOptions[actualUpdates.size()];
                if (this.getBuildServerVersion().isV3()) {
                    this.getBuild2010Helper().updateBuildControllers(actualUpdates.toArray(array));
                } else {
                    this.getAdministrationService().updateBuildControllers(actualUpdates.toArray(array));
                }
                for (int i = 0; i < controllersToUpdate.size(); ++i) {
                    if (updateOptions.get(i) == null) continue;
                    ((BuildController)controllersToUpdate.get(i)).setUpdateOptions((BuildControllerUpdateOptions)updateOptions.get(i));
                }
            }
        }
        return controllers;
    }

    @Override
    public IQueuedBuild getQueuedBuild(int queuedBuildId, QueryOptions queryOptions) {
        return this.getQueuedBuild(queuedBuildId, new String[0], queryOptions);
    }

    public IQueuedBuild getQueuedBuild(int queuedBuildId, String[] informationTypes, QueryOptions queryOptions) {
        return this.getQueuedBuild(new int[]{queuedBuildId}, informationTypes, queryOptions)[0];
    }

    @Override
    public IQueuedBuild[] getQueuedBuild(int[] queuedBuildIds, QueryOptions queryOptions) {
        return this.getQueuedBuild(queuedBuildIds, new String[0], queryOptions);
    }

    public IQueuedBuild[] getQueuedBuild(int[] queuedBuildIds, String[] informationTypes, QueryOptions queryOptions) {
        if (this.getBuildServerVersion().isV2()) {
            return this.getBuild2008Helper().queryQueuedBuildsById(queuedBuildIds, queryOptions).getQueuedBuilds();
        }
        if (this.getBuildServerVersion().isV3()) {
            return this.getBuild2010Helper().queryQueuedBuildsById(queuedBuildIds, queryOptions).getQueuedBuilds();
        }
        return this.getBuildQueueService().queryBuildsById(queuedBuildIds, informationTypes, queryOptions).getQueuedBuilds();
    }

    @Override
    public IQueuedBuildQueryResult queryQueuedBuilds(IQueuedBuildSpec buildQueueSpec) {
        return this.queryQueuedBuilds(new IQueuedBuildSpec[]{buildQueueSpec})[0];
    }

    @Override
    public IQueuedBuildQueryResult[] queryQueuedBuilds(IQueuedBuildSpec[] buildQueueSpecs) {
        if (this.getBuildServerVersion().isV2()) {
            return this.getBuild2008Helper().queryQueuedBuilds(buildQueueSpecs);
        }
        if (this.getBuildServerVersion().isV3()) {
            return this.getBuild2010Helper().queryQueuedBuilds(buildQueueSpecs);
        }
        return this.getBuildQueueService().queryBuilds(buildQueueSpecs);
    }

    @Override
    public IQueuedBuild[] retryQueuedBuilds(IQueuedBuild[] queuedBuilds) {
        return this.retryQueuedBuilds(queuedBuilds, GUID.newGUID());
    }

    @Override
    public IQueuedBuild[] retryQueuedBuilds(IQueuedBuild[] queuedBuilds, GUID batchId) {
        return this.retryQueuedBuilds(queuedBuilds, batchId, QueuedBuildRetryOption.IN_PROGRESS_BUILD);
    }

    @Override
    public IQueuedBuild[] retryQueuedBuilds(IQueuedBuild[] queuedBuilds, GUID batchId, QueuedBuildRetryOption retryOption) {
        if (this.getBuildServerVersion().isLessThanV4()) {
            this.throwMethodNotSupported("RetryQueuedBuilds");
        }
        if (queuedBuilds == null || queuedBuilds.length == 0) {
            return queuedBuilds;
        }
        for (IQueuedBuild build : queuedBuilds) {
            build.retry(batchId, retryOption);
        }
        return this.saveQueuedBuilds(queuedBuilds);
    }

    @Override
    public IQueuedBuild[] saveQueuedBuilds(IQueuedBuild[] queuedBuilds) {
        if (queuedBuilds == null || queuedBuilds.length == 0) {
            return queuedBuilds;
        }
        QueuedBuildUpdateOptions[] updateOptions = new QueuedBuildUpdateOptions[queuedBuilds.length];
        HashMap<Integer, QueuedBuildUpdateOptions> actualUpdates = new HashMap<Integer, QueuedBuildUpdateOptions>();
        for (int i = 0; i < queuedBuilds.length; ++i) {
            updateOptions[i] = ((QueuedBuild)queuedBuilds[i]).getUpdateOptions();
        }
        IQueuedBuild[] result = this.getBuildServerVersion().isV2() ? this.getBuild2008Helper().updateQueuedBuilds(updateOptions) : (this.getBuildServerVersion().isV3() ? this.getBuild2010Helper().updateQueuedBuilds(updateOptions) : this.getBuildQueueService().updateBuilds(updateOptions).getQueuedBuilds());
        for (QueuedBuild queuedBuild : result) {
            if (queuedBuild == null) continue;
            actualUpdates.put(queuedBuild.getID(), queuedBuild.getUpdateOptions());
        }
        for (IQueuedBuild iQueuedBuild : queuedBuilds) {
            if (iQueuedBuild == null) continue;
            ((QueuedBuild)iQueuedBuild).setUpdateOptions((QueuedBuildUpdateOptions)actualUpdates.get(iQueuedBuild.getID()));
        }
        return result;
    }

    @Override
    public IQueuedBuild queueBuild(IBuildDefinition definition) {
        return this.queueBuild(definition.createBuildRequest());
    }

    @Override
    public IQueuedBuild queueBuild(IBuildRequest request) {
        return this.queueBuild(request, QueueOptions.NONE);
    }

    @Override
    public IQueuedBuild queueBuild(IBuildRequest request, QueueOptions options) {
        if (this.getBuildServerVersion().isV2()) {
            return this.getBuild2008Helper().queueBuild((BuildRequest)request, options);
        }
        return this.queueBuild(new IBuildRequest[]{(BuildRequest)request}, options)[0];
    }

    @Override
    public IQueuedBuild[] queueBuild(IBuildRequest[] requests, QueueOptions options) {
        if (this.getBuildServerVersion().isLessThanV3()) {
            this.throwMethodNotSupported("QueueBuild");
        }
        if (this.getBuildServerVersion().isV3()) {
            return this.getBuild2010Helper().queueBuilds(requests, options);
        }
        return this.getBuildQueueService().queueBuilds(requests, options).getQueuedBuilds();
    }

    @Override
    public IQueuedBuild[] startQueuedBuildsNow(IQueuedBuild[] builds) {
        if (builds == null || builds.length == 0) {
            return builds;
        }
        if (this.getBuildServerVersion().isLessThanV4()) {
            this.throwMethodNotSupported("StartQueuedBuildsNow");
        }
        int[] ids = new int[builds.length];
        for (int i = 0; i < builds.length; ++i) {
            ids[i] = builds[i].getID();
        }
        return this.startQueuedBuildsNow(ids);
    }

    @Override
    public IQueuedBuild[] startQueuedBuildsNow(int[] ids) {
        if (ids == null || ids.length == 0) {
            return new IQueuedBuild[0];
        }
        if (this.getBuildServerVersion().isLessThanV4()) {
            this.throwMethodNotSupported("StartQueuedBuildsNow");
        }
        return this.getBuildQueueService().startBuildsNow(ids).getQueuedBuilds();
    }

    @Override
    public void stopBuilds(IBuildDetail[] builds) {
        if (builds == null || builds.length == 0) {
            return;
        }
        String[] uriList = new String[builds.length];
        for (int i = 0; i < builds.length; ++i) {
            uriList[i] = builds[i].getURI();
        }
        this.stopBuilds(uriList);
    }

    @Override
    public void stopBuilds(String[] uris) {
        if (uris == null || uris.length == 0) {
            return;
        }
        if (this.getBuildServerVersion().isV2()) {
            this.getBuild2008Helper().stopBuilds(uris);
        } else if (this.getBuildServerVersion().isV3()) {
            this.getBuild2010Helper().stopBuilds(uris);
        } else {
            this.getBuildService().stopBuilds(uris);
        }
    }

    @Override
    public void cancelBuilds(IQueuedBuild[] queuedBuilds) {
        if (queuedBuilds == null || queuedBuilds.length == 0) {
            return;
        }
        int[] ids = new int[queuedBuilds.length];
        for (int i = 0; i < queuedBuilds.length; ++i) {
            ids[i] = queuedBuilds[i].getID();
        }
        this.cancelBuilds(ids);
    }

    @Override
    public void cancelBuilds(int[] ids) {
        if (ids == null || ids.length == 0) {
            return;
        }
        if (this.getBuildServerVersion().isV2()) {
            this.getBuild2008Helper().cancelBuilds(ids);
        } else if (this.getBuildServerVersion().isV3()) {
            this.getBuild2010Helper().cancelBuilds(ids);
        } else {
            this.getBuildQueueService().cancelBuilds(ids);
        }
    }

    @Override
    public void addBuildQuality(String teamProject, String quality) {
        this.addBuildQuality(teamProject, new String[]{quality});
    }

    @Override
    public void addBuildQuality(String teamProject, String[] qualities) {
        if (this.getBuildServerVersion().isV2()) {
            this.getBuild2008Helper().addBuildQualities(teamProject, qualities);
        } else if (this.getBuildServerVersion().isV3()) {
            this.getBuild2010Helper().addBuildQualities(teamProject, qualities);
        } else {
            this.getBuildService().addBuildQualities(teamProject, qualities);
        }
    }

    @Override
    public void deleteBuildQuality(String teamProject, String quality) {
        this.deleteBuildQuality(teamProject, new String[]{quality});
    }

    @Override
    public void deleteBuildQuality(String teamProject, String[] qualities) {
        if (this.getBuildServerVersion().isV2()) {
            this.getBuild2008Helper().deleteBuildQualities(teamProject, qualities);
        } else if (this.getBuildServerVersion().isV3()) {
            this.getBuild2010Helper().deleteBuildQualities(teamProject, qualities);
        } else {
            this.getBuildService().deleteBuildQualities(teamProject, qualities);
        }
    }

    @Override
    public String[] getBuildQualities(String teamProject) {
        if (this.getBuildServerVersion().isV2()) {
            return this.getBuild2008Helper().getBuildQualities(teamProject);
        }
        if (this.getBuildServerVersion().isV3()) {
            return this.getBuild2010Helper().getBuildQualities(teamProject);
        }
        return this.getBuildService().getBuildQualities(teamProject);
    }

    @Override
    public IProcessTemplate createProcessTemplate(String teamProject, String serverPath) {
        return new ProcessTemplate(this, teamProject, serverPath);
    }

    @Override
    public IProcessTemplate[] queryProcessTemplates(String teamProject) {
        return this.queryProcessTemplates(teamProject, ALL_PROCESS_TEMPLATE_TYPES);
    }

    @Override
    public IProcessTemplate[] queryProcessTemplates(String teamProject, ProcessTemplateType[] types) {
        IProcessTemplate[] getResult = this.getBuildServerVersion().isV3() ? this.getBuild2010Helper().queryProcessTemplates(teamProject, types) : this.getBuildService().queryProcessTemplates(teamProject, types);
        return getResult;
    }

    @Override
    public IProcessTemplate[] saveProcessTemplates(IProcessTemplate[] processTemplates) {
        ArrayList<ProcessTemplate> templatesToAdd = new ArrayList<ProcessTemplate>();
        ArrayList<ProcessTemplate> templatesToUpdate = new ArrayList<ProcessTemplate>();
        HashMap<Integer, Integer> addIndices = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> updateIndices = new HashMap<Integer, Integer>();
        HashMap<Integer, IProcessTemplate> updatedTemplates = new HashMap<Integer, IProcessTemplate>();
        IProcessTemplate[] result = new IProcessTemplate[processTemplates.length];
        for (int i = 0; i < processTemplates.length; ++i) {
            ProcessTemplate template = (ProcessTemplate)processTemplates[i];
            template.prepareToSave();
            if (template.getID() < 0) {
                templatesToAdd.add(template);
                addIndices.put(templatesToAdd.size() - 1, i);
                continue;
            }
            templatesToUpdate.add(template);
            updateIndices.put(templatesToUpdate.size() - 1, i);
        }
        if (templatesToAdd.size() > 0) {
            ProcessTemplate[] toAdd = templatesToAdd.toArray(new ProcessTemplate[templatesToAdd.size()]);
            ProcessTemplate[] addResult = this.getBuildServerVersion().isV3() ? this.getBuild2010Helper().addProcessTemplates(toAdd) : this.getBuildService().addProcessTemplates(toAdd);
            for (int i = 0; i < addResult.length; ++i) {
                ((ProcessTemplate)templatesToAdd.get(i)).setID(addResult[i].getID());
                ((ProcessTemplate)templatesToAdd.get(i)).setParameters(addResult[i].getParameters());
                result[((Integer)addIndices.get((Object)Integer.valueOf((int)i))).intValue()] = addResult[i];
            }
        }
        if (templatesToUpdate.size() > 0) {
            ProcessTemplate[] toUpdate = templatesToUpdate.toArray(new ProcessTemplate[templatesToUpdate.size()]);
            IProcessTemplate[] updateResult = this.getBuildServerVersion().isV3() ? this.getBuild2010Helper().updateProcessTemplates(toUpdate) : this.getBuildService().updateProcessTemplates(toUpdate);
            if (templatesToAdd.size() == 0) {
                return updateResult;
            }
            for (IProcessTemplate updatedTemplate : updateResult) {
                updatedTemplates.put(((ProcessTemplate)updatedTemplate).getID(), updatedTemplate);
            }
            for (int i = 0; i < templatesToUpdate.size(); ++i) {
                result[((Integer)updateIndices.get((Object)Integer.valueOf((int)i))).intValue()] = (IProcessTemplate)updatedTemplates.get(((ProcessTemplate)processTemplates[(Integer)updateIndices.get(i)]).getID());
            }
        }
        return result;
    }

    @Override
    public void deleteProcessTemplates(IProcessTemplate[] processTemplates) {
        if (processTemplates != null && processTemplates.length > 0) {
            int[] templateIds = new int[processTemplates.length];
            for (int i = 0; i < processTemplates.length; ++i) {
                templateIds[i] = ((ProcessTemplate)processTemplates[i]).getID();
            }
            if (this.getBuildServerVersion().isV3()) {
                this.getBuild2010Helper().deleteProcessTemplates(templateIds);
            } else {
                this.getBuildService().deleteProcessTemplates(templateIds);
            }
            for (IProcessTemplate template : processTemplates) {
                ((ProcessTemplate)template).setID(-1);
            }
        }
    }

    @Override
    public String getDisplayText(Object value) {
        return BuildEnumerationHelper.getDisplayText(value);
    }

    @Override
    public String[] getDisplayTextValues(Class enumType) {
        return BuildEnumerationHelper.getDisplayTextValues(enumType);
    }

    @Override
    public Object getEnumValue(Class enumType, String displayText, Object defaultValue) {
        if (Agent2008Status.class.equals((Object)enumType)) {
            if (Messages.getString("BuildClient.Agent2008StatusEnabled").equals(displayText)) {
                return Agent2008Status.ENABLED;
            }
            if (Messages.getString("BuildClient.Agent2008StatusDisabled").equals(displayText)) {
                return Agent2008Status.DISABLED;
            }
            if (Messages.getString("BuildClient.Agent2008StatusUnreachable").equals(displayText)) {
                return Agent2008Status.UNREACHABLE;
            }
            if (Messages.getString("BuildClient.Agent2008StatusInitializing").equals(displayText)) {
                return Agent2008Status.INITIALIZING;
            }
            return defaultValue;
        }
        return defaultValue;
    }

    public Build2008Helper getBuild2008Helper() {
        if (this.build2008Helper == null) {
            this.build2008Helper = new Build2008Helper(this);
        }
        return this.build2008Helper;
    }

    public Build2010Helper getBuild2010Helper() {
        if (this.build2010Helper == null) {
            this.build2010Helper = new Build2010Helper(this);
        }
        return this.build2010Helper;
    }

    public BuildWebService4 getBuildService() {
        if (this.buildService4 == null) {
            if (!this.getBuildServerVersion().isV4()) {
                throw new UnsupportedOperationException("Tried to get non V4 build web service");
            }
            this.buildService4 = new BuildWebService4(this.tfs);
        }
        return this.buildService4;
    }

    public BuildQueueWebService4 getBuildQueueService() {
        if (this.buildQueueService4 == null) {
            if (!this.getBuildServerVersion().isV4()) {
                throw new UnsupportedOperationException("Tried to get non V4 build queue web service");
            }
            this.buildQueueService4 = new BuildQueueWebService4(this.tfs);
        }
        return this.buildQueueService4;
    }

    public AdministrationWebService4 getAdministrationService() {
        if (this.buildAdminService4 == null) {
            if (!this.getBuildServerVersion().isV4()) {
                throw new UnsupportedOperationException("Tried to get non V4 build admin web service");
            }
            this.buildAdminService4 = new AdministrationWebService4(this.tfs);
        }
        return this.buildAdminService4;
    }

    private static String[] getUrisForBuilds(IBuildDetail[] builds) {
        if (builds == null) {
            return null;
        }
        String[] uriList = new String[builds.length];
        for (int i = 0; i < builds.length; ++i) {
            uriList[i] = builds[i].getURI();
        }
        return uriList;
    }

    private void throwMethodNotSupported(String method) throws NotSupportedException {
        String format = Messages.getString("BuildServer2012.MethodNotSupportedFormat");
        throw new NotSupportedException(MessageFormat.format(format, method, "IBuildServer"));
    }

    private void throwOperationNotSupported(String operation) throws NotSupportedException {
        String format = Messages.getString("BuildServer2012.OperationNotSupportedFormat");
        throw new NotSupportedException(MessageFormat.format(format, operation, "IBuildServer"));
    }

    private String getDomainUserName() {
        return IdentityHelper.getDomainUserName(this.getConnection().getAuthorizedIdentity());
    }
}

