/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.framework.location.internal;

import com.microsoft.tfs.core.clients.framework.location.AccessMapping;
import com.microsoft.tfs.core.clients.framework.location.LocationMapping;
import com.microsoft.tfs.core.clients.framework.location.LocationServiceData;
import com.microsoft.tfs.core.clients.framework.location.ServiceDefinition;
import com.microsoft.tfs.core.clients.framework.location.internal.LocationDataSerializer;
import com.microsoft.tfs.core.clients.framework.location.internal.LocationServiceCacheData;
import com.microsoft.tfs.core.clients.registration.ServerMap;
import com.microsoft.tfs.core.persistence.LockMode;
import com.microsoft.tfs.core.persistence.PersistenceStore;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;
import com.microsoft.tfs.util.StringUtil;
import java.io.IOException;
import java.net.URI;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocationCacheManager {
    private int lastChangeID;
    private final URI connectionBaseUri;
    private String webApplicationRelativeDirectory;
    private Map<String, AccessMapping> mapAccessMappings;
    private Map<String, Map<GUID, ServiceDefinition>> mapServices;
    private AccessMapping clientAccessMapping;
    private AccessMapping defaultAccessMapping;
    private final ReentrantReadWriteLock accessLock;
    private String defaultAccessMappingMoniker;
    private PersistenceStore locationDiskStore;
    private boolean cacheAvailable;
    private boolean cacheLocallyFresh;
    private static final Log log = LogFactory.getLog(LocationCacheManager.class);
    private static final String CACHE_DIRECTORY_NAME = "TEE-Location";
    private static final String CACHE_FILE_NAME = "LocationServiceData.xml";

    public LocationCacheManager(PersistenceStore cacheStore, GUID serverGuid, URI serverUrl) {
        String instanceID;
        ServerMap serverMap = ServerMap.load(cacheStore);
        if (serverGuid.equals(GUID.EMPTY) && (instanceID = serverMap.getServerID(serverUrl.toString())) != null) {
            serverGuid = new GUID(instanceID);
        }
        this.cacheAvailable = !serverGuid.equals(GUID.EMPTY);
        this.cacheLocallyFresh = false;
        this.accessLock = new ReentrantReadWriteLock();
        this.lastChangeID = -1;
        this.mapAccessMappings = new HashMap<String, AccessMapping>();
        this.mapServices = new HashMap<String, Map<GUID, ServiceDefinition>>();
        this.connectionBaseUri = serverUrl;
        if (this.cacheAvailable && serverGuid != null) {
            String directoryName = serverGuid.getGUIDString().toLowerCase() + "_" + this.connectionBaseUri.getScheme();
            this.locationDiskStore = cacheStore.getChildStore(CACHE_DIRECTORY_NAME).getChildStore(directoryName);
        }
    }

    public boolean isLocalCacheAvailable() {
        this.ensureDiskCacheLoaded();
        return this.cacheAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessMapping getClientAccessMapping() {
        try {
            this.accessLock.readLock().lock();
            AccessMapping accessMapping = this.clientAccessMapping;
            return accessMapping;
        }
        finally {
            this.accessLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessMapping getDefaultAccessMapping() {
        try {
            this.accessLock.readLock().lock();
            AccessMapping accessMapping = this.defaultAccessMapping;
            return accessMapping;
        }
        finally {
            this.accessLock.readLock().unlock();
        }
    }

    public String getWebApplicationRelativeDirectory() {
        return this.webApplicationRelativeDirectory;
    }

    public void setWebApplicationRelativeDirectory(String value) {
        this.webApplicationRelativeDirectory = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLastChangeID() {
        this.ensureDiskCacheLoaded();
        try {
            this.accessLock.readLock().lock();
            int n = this.lastChangeID;
            return n;
        }
        finally {
            this.accessLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearIfCacheNotFresh(int serverLastChangeId) {
        if (serverLastChangeId == this.lastChangeID) {
            return;
        }
        try {
            this.accessLock.writeLock().lock();
            if (serverLastChangeId == this.lastChangeID) {
                return;
            }
            this.mapAccessMappings.clear();
            this.mapServices.clear();
            this.lastChangeID = -1;
        }
        finally {
            if (this.accessLock.isWriteLockedByCurrentThread()) {
                this.accessLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessMapping[] getAccessMappings() {
        try {
            this.ensureDiskCacheLoaded();
            this.accessLock.readLock().lock();
            AccessMapping[] accessMappingArray = LocationCacheManager.accessMappingMapToArray(this.mapAccessMappings);
            return accessMappingArray;
        }
        finally {
            this.accessLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAccessMapping(String moniker) {
        try {
            this.ensureDiskCacheLoaded();
            this.accessLock.writeLock().lock();
            if (this.mapAccessMappings.containsKey(moniker)) {
                this.mapAccessMappings.remove(moniker);
                for (Map<GUID, ServiceDefinition> m : this.mapServices.values()) {
                    for (ServiceDefinition definition : m.values()) {
                        LocationMapping[] locationMappings = definition.getLocationMappings();
                        for (int i = 0; i < locationMappings.length; ++i) {
                            String accessMappingMoniker = locationMappings[i].getAccessMappingMoniker();
                            if (!moniker.equalsIgnoreCase(accessMappingMoniker)) continue;
                            definition.internalRemoveLocationMappingAt(i);
                        }
                    }
                }
            }
            this.writeCacheToDisk();
        }
        finally {
            if (this.accessLock.isWriteLockedByCurrentThread()) {
                this.accessLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServices(ServiceDefinition[] serviceDefinitions, int lastChangeId) {
        try {
            this.ensureDiskCacheLoaded();
            this.accessLock.writeLock().lock();
            for (int i = 0; i < serviceDefinitions.length; ++i) {
                ServiceDefinition serviceDefinition = serviceDefinitions[i];
                if (!this.mapServices.containsKey(serviceDefinition.getServiceType())) continue;
                Map<GUID, ServiceDefinition> serviceDefinitionInstances = this.mapServices.get(serviceDefinition.getServiceType());
                if (serviceDefinitionInstances.containsKey(serviceDefinition.getIdentifier())) {
                    serviceDefinitionInstances.remove(serviceDefinition.getIdentifier());
                }
                if (serviceDefinitionInstances.size() != 0) continue;
                this.mapServices.remove(serviceDefinition.getServiceType());
            }
            this.setLastChangeID(lastChangeId, false);
            this.writeCacheToDisk();
        }
        finally {
            if (this.accessLock.isWriteLockedByCurrentThread()) {
                this.accessLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessMapping getAccessMapping(String moniker) {
        Check.notNullOrEmpty(moniker, "moniker");
        try {
            this.ensureDiskCacheLoaded();
            this.accessLock.readLock().lock();
            if (this.mapAccessMappings.containsKey(moniker)) {
                AccessMapping accessMapping = this.mapAccessMappings.get(moniker);
                return accessMapping;
            }
            AccessMapping accessMapping = null;
            return accessMapping;
        }
        finally {
            this.accessLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceDefinition findService(String serviceType, GUID serviceIdentifier) {
        try {
            Map<GUID, ServiceDefinition> services;
            this.ensureDiskCacheLoaded();
            this.accessLock.readLock().lock();
            ServiceDefinition serviceDefinition = null;
            if (this.mapServices.containsKey(serviceType) && (services = this.mapServices.get(serviceType)).containsKey(serviceIdentifier)) {
                serviceDefinition = services.get(serviceIdentifier);
            }
            ServiceDefinition serviceDefinition2 = (ServiceDefinition)(serviceDefinition == null ? null : serviceDefinition.clone());
            return serviceDefinition2;
        }
        finally {
            this.accessLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceDefinition[] findServices(String serviceType) {
        try {
            this.ensureDiskCacheLoaded();
            this.accessLock.readLock().lock();
            Check.isTrue(this.lastChangeID == -1 || this.mapServices.size() > 0, "lastChangeID == -1 || mapServices.size() > 0");
            if (this.mapServices.size() == 0) {
                ServiceDefinition[] serviceDefinitionArray = null;
                return serviceDefinitionArray;
            }
            ArrayList<ServiceDefinition> list = new ArrayList<ServiceDefinition>();
            if (serviceType == null || serviceType.length() == 0) {
                for (Map<GUID, ServiceDefinition> mapServiceInstances : this.mapServices.values()) {
                    this.addClonedServiceInstancesToList(mapServiceInstances, list);
                }
            } else {
                if (!this.mapServices.containsKey(serviceType)) {
                    ServiceDefinition[] i$ = null;
                    return i$;
                }
                Map<GUID, ServiceDefinition> mapServiceInstances = this.mapServices.get(serviceType);
                this.addClonedServiceInstancesToList(mapServiceInstances, list);
            }
            ServiceDefinition[] serviceDefinitionArray = list.toArray(new ServiceDefinition[list.size()]);
            return serviceDefinitionArray;
        }
        finally {
            this.accessLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceDefinition[] findServicesByToolID(String toolId) {
        try {
            ServiceDefinition[] serviceDefinitionArray;
            this.ensureDiskCacheLoaded();
            this.accessLock.readLock().lock();
            boolean returnAll = toolId == null || toolId.length() == 0;
            ArrayList<ServiceDefinition> requestedDefinitions = new ArrayList<ServiceDefinition>();
            for (Map<GUID, ServiceDefinition> mapServiceInstances : this.mapServices.values()) {
                for (ServiceDefinition definition : mapServiceInstances.values()) {
                    if (!returnAll && !toolId.equalsIgnoreCase(definition.getToolID())) continue;
                    requestedDefinitions.add((ServiceDefinition)definition.clone());
                }
            }
            if (requestedDefinitions.size() == 0) {
                serviceDefinitionArray = null;
                return serviceDefinitionArray;
            }
            serviceDefinitionArray = requestedDefinitions.toArray(new ServiceDefinition[requestedDefinitions.size()]);
            return serviceDefinitionArray;
        }
        finally {
            this.accessLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadServicesData(LocationServiceData locationServiceData, boolean allServicesIncluded) {
        try {
            this.accessLock.writeLock().lock();
            if (!locationServiceData.isClientCacheFresh() && locationServiceData.getLastChangeID() != this.lastChangeID) {
                this.mapAccessMappings = new HashMap<String, AccessMapping>();
                this.mapServices = new HashMap<String, Map<GUID, ServiceDefinition>>();
                this.lastChangeID = -1;
            } else {
                this.ensureDiskCacheLoaded();
            }
            this.setLastChangeID(locationServiceData.getLastChangeID(), allServicesIncluded);
            this.defaultAccessMappingMoniker = locationServiceData.getDefaultAccessMappingMoniker();
            AccessMapping[] accessMappings = locationServiceData.getAccessMappings();
            if (accessMappings != null && accessMappings.length > 0) {
                for (int i = 0; i < accessMappings.length; ++i) {
                    String relativeDirectory;
                    AccessMapping accessMapping = accessMappings[i];
                    if (!locationServiceData.isAccessPointsDoNotIncludeWebAppRelativeDirectory() && (relativeDirectory = this.getWebApplicationRelativeDirectory()) != null && relativeDirectory.length() > 0) {
                        String unescapedAbsoluteUriTrimmed = URLDecoder.decode(StringUtil.trimEnd(accessMapping.getAccessPoint(), '/'));
                        String unescapedRelativeDirectoryTrimmed = URLDecoder.decode(StringUtil.trimEnd(relativeDirectory, '/'));
                        if (unescapedAbsoluteUriTrimmed.toLowerCase().endsWith(unescapedRelativeDirectoryTrimmed.toLowerCase())) {
                            String accessPoint = unescapedAbsoluteUriTrimmed.substring(0, unescapedAbsoluteUriTrimmed.length() - unescapedRelativeDirectoryTrimmed.length());
                            accessMapping.setAccessPoint(accessPoint);
                        }
                    }
                    if (this.mapAccessMappings.containsKey(accessMapping.getMoniker())) {
                        AccessMapping existingAccessMapping = this.mapAccessMappings.get(accessMapping.getMoniker());
                        existingAccessMapping.setDisplayName(accessMapping.getDisplayName());
                        existingAccessMapping.setAccessPoint(accessMapping.getAccessPoint());
                        continue;
                    }
                    this.mapAccessMappings.put(accessMapping.getMoniker(), accessMapping);
                }
                this.determineClientAndDefaultZones(locationServiceData.getDefaultAccessMappingMoniker());
            }
            this.connectionBaseUri.getScheme();
            this.connectionBaseUri.getAuthority();
            this.connectionBaseUri.getScheme();
            this.connectionBaseUri.getHost();
            ServiceDefinition[] serviceDefinitions = locationServiceData.getServiceDefinitions();
            if (serviceDefinitions != null) {
                for (int i = 0; i < serviceDefinitions.length; ++i) {
                    ServiceDefinition definition = serviceDefinitions[i];
                    if (!this.mapServices.containsKey(definition.getServiceType())) {
                        this.mapServices.put(definition.getServiceType(), new HashMap());
                    }
                    Map<GUID, ServiceDefinition> services = this.mapServices.get(definition.getServiceType());
                    services.put(definition.getIdentifier(), definition);
                }
            }
            this.writeCacheToDisk();
        }
        finally {
            if (this.accessLock.isWriteLockedByCurrentThread()) {
                this.accessLock.writeLock().unlock();
            }
        }
    }

    private void addClonedServiceInstancesToList(Map<GUID, ServiceDefinition> mapServiceInstances, List<ServiceDefinition> listOfClones) {
        for (ServiceDefinition serviceDefinition : mapServiceInstances.values()) {
            listOfClones.add((ServiceDefinition)serviceDefinition.clone());
        }
    }

    private void determineClientAndDefaultZones(String defaultAccessMappingMoniker) {
        this.defaultAccessMapping = null;
        this.clientAccessMapping = null;
        for (AccessMapping accessMapping : this.mapAccessMappings.values()) {
            String trimmedAccessPoint = StringUtil.trimEnd(accessMapping.getAccessPoint(), '/');
            String absoluteUri = this.connectionBaseUri.toString();
            if (!absoluteUri.toLowerCase().startsWith(trimmedAccessPoint.toLowerCase())) continue;
            this.clientAccessMapping = accessMapping;
        }
        this.defaultAccessMapping = this.mapAccessMappings.get(defaultAccessMappingMoniker);
        if (this.clientAccessMapping == null) {
            String accessPoint = StringUtil.trimEnd(this.connectionBaseUri.toString(), '/');
            this.getWebApplicationRelativeDirectory();
            if (this.webApplicationRelativeDirectory != null && this.webApplicationRelativeDirectory.length() > 0) {
                String trimmedRealtiveDirectory = StringUtil.trimEnd(this.getWebApplicationRelativeDirectory(), '/');
                String unescapedAbsoluteUriTrimmed = URLDecoder.decode(accessPoint);
                String unescapedRelativeDirectoryTrimmed = URLDecoder.decode(trimmedRealtiveDirectory);
                if (unescapedAbsoluteUriTrimmed.toLowerCase().endsWith(unescapedRelativeDirectoryTrimmed.toLowerCase())) {
                    accessPoint = unescapedAbsoluteUriTrimmed.substring(0, unescapedAbsoluteUriTrimmed.length() - unescapedRelativeDirectoryTrimmed.length());
                }
            }
            this.clientAccessMapping = new AccessMapping(accessPoint, accessPoint, accessPoint);
        }
    }

    private void setLastChangeID(int value, boolean allServicesUpdated) {
        Check.isTrue(this.accessLock.isWriteLockedByCurrentThread(), "accessLock.isWriteLockedByCurrentThread()");
        if (this.lastChangeID != -1 || allServicesUpdated) {
            this.lastChangeID = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasLocalCacheDataForConnection() {
        if (!this.cacheAvailable) {
            return false;
        }
        try {
            this.accessLock.writeLock().lock();
            LocationServiceCacheData data = this.loadLocationServiceCacheData();
            boolean bl = data != null;
            return bl;
        }
        catch (Exception ex) {
            log.info((Object)MessageFormat.format("unable to load location data (while testing) from {0}:{1}", this.locationDiskStore.toString(), CACHE_FILE_NAME), (Throwable)ex);
        }
        finally {
            if (this.accessLock.isWriteLockedByCurrentThread()) {
                this.accessLock.writeLock().unlock();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureDiskCacheLoaded() {
        if (this.cacheLocallyFresh || !this.cacheAvailable) {
            return;
        }
        try {
            this.accessLock.writeLock().lock();
            LocationServiceCacheData data = this.loadLocationServiceCacheData();
            if (data != null) {
                this.lastChangeID = data.getLastChangeID();
                this.webApplicationRelativeDirectory = data.getVirtualDirectory();
                this.mapAccessMappings = LocationCacheManager.accessMappingArrayToMap(data.getAccessMappings());
                this.determineClientAndDefaultZones(data.getDefaultMappingMoniker());
                this.mapServices = LocationCacheManager.serviceDefinitionArrayToMap(data.getServiceDefinitions());
            }
        }
        catch (Exception ex) {
            log.warn((Object)MessageFormat.format("unable to load location data from {0}:{1}", this.locationDiskStore.toString(), CACHE_FILE_NAME), (Throwable)ex);
            this.cacheAvailable = false;
            this.lastChangeID = -1;
        }
        finally {
            this.cacheLocallyFresh = true;
            if (this.accessLock.isWriteLockedByCurrentThread()) {
                this.accessLock.writeLock().unlock();
            }
        }
    }

    private LocationServiceCacheData loadLocationServiceCacheData() throws IOException, InterruptedException {
        LocationDataSerializer serializer = new LocationDataSerializer();
        return (LocationServiceCacheData)this.locationDiskStore.retrieveItem(CACHE_FILE_NAME, LockMode.WAIT_FOREVER, null, serializer);
    }

    private void writeCacheToDisk() {
        if (!this.cacheAvailable) {
            return;
        }
        AccessMapping[] accessMappings = LocationCacheManager.accessMappingMapToArray(this.mapAccessMappings);
        ServiceDefinition[] serviceDefinitions = LocationCacheManager.serviceDefinitionMapToArray(this.mapServices);
        String defaultMoniker = this.defaultAccessMapping != null ? this.defaultAccessMapping.getMoniker() : this.defaultAccessMappingMoniker;
        LocationServiceCacheData data = new LocationServiceCacheData(this.lastChangeID, defaultMoniker, this.webApplicationRelativeDirectory, accessMappings, serviceDefinitions);
        try {
            LocationDataSerializer serializer = new LocationDataSerializer();
            this.locationDiskStore.storeItem(CACHE_FILE_NAME, data, LockMode.WAIT_FOREVER, null, serializer);
        }
        catch (Exception e) {
            log.warn((Object)MessageFormat.format("unable to save registration data to {0}:{1}", this.locationDiskStore.toString(), CACHE_FILE_NAME), (Throwable)e);
        }
    }

    private static Map<String, Map<GUID, ServiceDefinition>> serviceDefinitionArrayToMap(ServiceDefinition[] serviceDefinitions) {
        HashMap<String, Map<GUID, ServiceDefinition>> map = new HashMap<String, Map<GUID, ServiceDefinition>>();
        for (ServiceDefinition definition : serviceDefinitions) {
            if (!map.containsKey(definition.getServiceType())) {
                map.put(definition.getServiceType(), new HashMap());
            }
            Map serviceDefinitionInstances = (Map)map.get(definition.getServiceType());
            serviceDefinitionInstances.put(definition.getIdentifier(), definition);
        }
        return map;
    }

    private static ServiceDefinition[] serviceDefinitionMapToArray(Map<String, Map<GUID, ServiceDefinition>> servicesMap) {
        ArrayList<ServiceDefinition> list = new ArrayList<ServiceDefinition>();
        for (Map<GUID, ServiceDefinition> serviceDefinitionInstances : servicesMap.values()) {
            for (ServiceDefinition serviceDefinition : serviceDefinitionInstances.values()) {
                list.add(serviceDefinition);
            }
        }
        return list.toArray(new ServiceDefinition[list.size()]);
    }

    private static Map<String, AccessMapping> accessMappingArrayToMap(AccessMapping[] accessMappings) {
        HashMap<String, AccessMapping> map = new HashMap<String, AccessMapping>();
        for (AccessMapping mapping : accessMappings) {
            map.put(mapping.getMoniker(), mapping);
        }
        return map;
    }

    private static AccessMapping[] accessMappingMapToArray(Map<String, AccessMapping> accessMappingsMap) {
        Collection<AccessMapping> values = accessMappingsMap.values();
        return values.toArray(new AccessMapping[values.size()]);
    }
}

