/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.security;

import com.microsoft.tfs.core.TFSConnection;
import com.microsoft.tfs.core.clients.security.AccessControlEntryDetails;
import com.microsoft.tfs.core.clients.security.AccessControlListDetails;
import com.microsoft.tfs.core.clients.security.SecurityNamespace;
import com.microsoft.tfs.core.clients.security.SecurityNamespaceDescription;
import com.microsoft.tfs.core.clients.webservices.IdentityDescriptor;
import com.microsoft.tfs.core.internal.wrappers.WrapperUtils;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;
import java.util.ArrayList;
import ms.ws._AccessControlEntryDetails;
import ms.ws._AccessControlListDetails;
import ms.ws._IdentityDescriptor;
import ms.ws._SecurityWebServiceSoap;

public class FrameworkSecurityNamespace
extends SecurityNamespace {
    private final SecurityNamespaceDescription description;
    private final _SecurityWebServiceSoap securityProxy;

    public FrameworkSecurityNamespace(TFSConnection connection, SecurityNamespaceDescription description) {
        Check.notNull(connection, "connection");
        Check.notNull(description.getName(), "description.getName()");
        Check.isTrue(description.getNamespaceId() != null && !description.getNamespaceId().equals(GUID.EMPTY), "description.getNamespaceId() != null && !description.getNamespaceId().equals(GUID.EMPTY)");
        this.description = description;
        this.securityProxy = (_SecurityWebServiceSoap)connection.getWebService(_SecurityWebServiceSoap.class);
    }

    @Override
    public SecurityNamespaceDescription getDescription() {
        return this.description.clone();
    }

    @Override
    public boolean hasPermission(String token, IdentityDescriptor descriptor, int requestedPermissions, boolean alwaysAllowAdministrators) {
        Check.notNull(token, "token");
        Check.notNull(descriptor, "descriptor");
        boolean[] ret = this.securityProxy.hasPermissionByPermissionsList(this.getDescription().getNamespaceId().getGUIDString(), token, descriptor.getWebServiceObject(), new int[]{requestedPermissions}, alwaysAllowAdministrators);
        if (ret == null) {
            return false;
        }
        return ret[0];
    }

    @Override
    public boolean[] hasPermission(String[] tokens, IdentityDescriptor descriptor, int requestedPermissions, boolean alwaysAllowAdministrators) {
        Check.notNullOrEmpty(tokens, "tokens");
        Check.notNull(descriptor, "descriptor");
        return this.securityProxy.hasPermissionByTokenList(this.getDescription().getNamespaceId().getGUIDString(), tokens, descriptor.getWebServiceObject(), requestedPermissions, alwaysAllowAdministrators);
    }

    @Override
    public boolean[] hasPermission(String token, IdentityDescriptor[] descriptors, int requestedPermissions, boolean alwaysAllowAdministrators) {
        Check.notNull(token, "token");
        Check.notNullOrEmpty(descriptors, "descriptors");
        return this.securityProxy.hasPermissionByDescriptorList(this.getDescription().getNamespaceId().getGUIDString(), token, (_IdentityDescriptor[])WrapperUtils.unwrap(_IdentityDescriptor.class, descriptors), requestedPermissions, alwaysAllowAdministrators);
    }

    @Override
    public boolean[] hasPermission(String token, IdentityDescriptor descriptor, int[] requestedPermissions, boolean alwaysAllowAdministrators) {
        Check.notNull(token, "token");
        Check.notNull(descriptor, "descriptor");
        Check.notNull(requestedPermissions, "requestedPermissions");
        Check.isTrue(requestedPermissions.length > 0, "requestedPermissions.length > 0");
        return this.securityProxy.hasPermissionByPermissionsList(this.getDescription().getNamespaceId().getGUIDString(), token, descriptor.getWebServiceObject(), requestedPermissions, alwaysAllowAdministrators);
    }

    @Override
    public boolean hasWritePermission(String token, int permissionsToChange) {
        Check.notNull(token, "token");
        boolean[] ret = this.securityProxy.hasWritePermission(this.getDescription().getNamespaceId().getGUIDString(), token, new int[]{permissionsToChange});
        if (ret == null) {
            return false;
        }
        return ret[0];
    }

    @Override
    public boolean[] hasWritePermission(String token, int[] permissionsToChange) {
        Check.notNull(token, "token");
        Check.notNull(permissionsToChange, "permissionsToChange");
        Check.isTrue(permissionsToChange.length > 0, "permissionsToChange.length > 0");
        return this.securityProxy.hasWritePermission(this.getDescription().getNamespaceId().getGUIDString(), token, permissionsToChange);
    }

    @Override
    public boolean removeAccessControlLists(String token, boolean recurse) {
        return this.removeAccessControlLists(new String[]{token}, recurse);
    }

    @Override
    public boolean removeAccessControlLists(String[] tokens, boolean recurse) {
        Check.notNull(tokens, "tokens");
        return this.securityProxy.removeAccessControlList(this.getDescription().getNamespaceId().getGUIDString(), tokens, recurse);
    }

    @Override
    public boolean removeAccessControlEntries(String token, IdentityDescriptor[] descriptors) {
        Check.notNull(token, "token");
        Check.notNullOrEmpty(descriptors, "descriptors");
        return this.securityProxy.removeAccessControlEntries(this.getDescription().getNamespaceId().getGUIDString(), token, (_IdentityDescriptor[])WrapperUtils.unwrap(IdentityDescriptor.class, descriptors));
    }

    @Override
    public boolean removeAccessControlEntry(String token, IdentityDescriptor descriptor) {
        return this.removeAccessControlEntries(token, new IdentityDescriptor[]{descriptor});
    }

    @Override
    public AccessControlEntryDetails removePermissions(String token, IdentityDescriptor descriptor, int permissionsToRemove) {
        Check.notNull(token, "token");
        Check.notNull(descriptor, "descriptor");
        return new AccessControlEntryDetails(this.securityProxy.removePermissions(this.getDescription().getNamespaceId().getGUIDString(), token, descriptor.getWebServiceObject(), permissionsToRemove));
    }

    @Override
    public AccessControlEntryDetails setPermissions(String token, IdentityDescriptor descriptor, int allow, int deny, boolean merge) {
        return this.setAccessControlEntry(token, new AccessControlEntryDetails(descriptor, allow, deny), merge);
    }

    @Override
    public AccessControlEntryDetails setAccessControlEntry(String token, AccessControlEntryDetails accessControlEntry, boolean merge) {
        Check.notNull(accessControlEntry, "accessControlEntry");
        Check.notNull(token, "token");
        AccessControlEntryDetails[] ret = this.setAccessControlEntries(token, new AccessControlEntryDetails[]{accessControlEntry}, merge);
        if (ret == null) {
            return null;
        }
        return ret[0];
    }

    @Override
    public AccessControlEntryDetails[] setAccessControlEntries(String token, AccessControlEntryDetails[] accessControlEntries, boolean merge) {
        Check.notNullOrEmpty(accessControlEntries, "accessControlEntries");
        Check.notNull(token, "token");
        return (AccessControlEntryDetails[])WrapperUtils.wrap(AccessControlEntryDetails.class, this.securityProxy.setPermissions(this.getDescription().getNamespaceId().getGUIDString(), token, (_AccessControlEntryDetails[])WrapperUtils.unwrap(_AccessControlEntryDetails.class, accessControlEntries), merge));
    }

    @Override
    public void setAccessControlLists(AccessControlListDetails[] accessControlLists) {
        Check.notNullOrEmpty(accessControlLists, "accessControlLists");
        this.securityProxy.setAccessControlList(this.getDescription().getNamespaceId().getGUIDString(), (_AccessControlListDetails[])WrapperUtils.unwrap(_AccessControlListDetails.class, accessControlLists));
    }

    @Override
    public void setAccessControlList(AccessControlListDetails accessControlList) {
        this.setAccessControlLists(new AccessControlListDetails[]{accessControlList});
    }

    @Override
    public AccessControlListDetails[] queryAccessControlLists(String token, IdentityDescriptor[] descriptors, boolean includeExtendedInfo, boolean recurse) {
        Check.notNull(token, "token");
        ArrayList<_IdentityDescriptor> identityData = null;
        if (descriptors != null) {
            identityData = new ArrayList<_IdentityDescriptor>();
            for (IdentityDescriptor descriptor : descriptors) {
                identityData.add(new _IdentityDescriptor(descriptor.getIdentityType(), descriptor.getIdentifier()));
            }
        }
        return (AccessControlListDetails[])WrapperUtils.wrap(AccessControlListDetails.class, this.securityProxy.queryPermissions(this.getDescription().getNamespaceId().getGUIDString(), token, identityData != null ? identityData.toArray(new _IdentityDescriptor[identityData.size()]) : null, includeExtendedInfo, recurse));
    }

    @Override
    public AccessControlListDetails queryAccessControlList(String token, IdentityDescriptor[] descriptors, boolean includeExtendedInfo) {
        AccessControlListDetails[] acl = this.queryAccessControlLists(token, descriptors, includeExtendedInfo, false);
        if (acl == null || acl.length == 0) {
            return new AccessControlListDetails(token, true);
        }
        return acl[0];
    }

    @Override
    public int queryEffectivePermissions(String token, IdentityDescriptor descriptor) {
        Check.notNull(descriptor, "descriptor");
        Check.notNull(token, "token");
        IdentityDescriptor identity = new IdentityDescriptor(descriptor.getIdentityType(), descriptor.getIdentifier());
        _AccessControlListDetails[] result = this.securityProxy.queryPermissions(this.getDescription().getNamespaceId().getGUIDString(), token, new _IdentityDescriptor[]{identity.getWebServiceObject()}, true, false);
        _AccessControlEntryDetails[] data = result[0].getAccessControlEntries();
        if (data.length == 0) {
            return 0;
        }
        return data[0].getExtendedInformation().getEffectiveAllow();
    }

    @Override
    public void setInheritFlag(String token, boolean inherit) {
        Check.notNull(token, "token");
        this.securityProxy.setInheritFlag(this.getDescription().getNamespaceId().getGUIDString(), token, inherit);
    }
}

