/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.engines.internal.workers;

import com.microsoft.tfs.core.clients.versioncontrol.VersionControlClient;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.workers.Worker;
import com.microsoft.tfs.core.clients.versioncontrol.events.EventSource;
import com.microsoft.tfs.core.clients.versioncontrol.specs.DownloadOutput;
import com.microsoft.tfs.util.tasks.TaskMonitor;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

abstract class AbstractDownloadWorker
implements Worker {
    private static final Log log = LogFactory.getLog(AbstractDownloadWorker.class);
    private final EventSource eventSource;
    private final TaskMonitor cancelMonitor;
    private final VersionControlClient client;

    public AbstractDownloadWorker(EventSource eventSource, TaskMonitor cancelMonitor, VersionControlClient client) {
        this.eventSource = eventSource;
        this.cancelMonitor = cancelMonitor;
        this.client = client;
    }

    protected EventSource getEventSource() {
        return this.eventSource;
    }

    protected TaskMonitor getCancelMonitor() {
        return this.cancelMonitor;
    }

    protected VersionControlClient getClient() {
        return this.client;
    }

    protected void closeDownloadOutputStreamsSafely(Iterable<DownloadOutput> outputs) {
        for (DownloadOutput output : outputs) {
            this.closeDownloadOutputStreamSafely(output);
        }
    }

    protected void closeDownloadOutputStreamSafely(DownloadOutput output) {
        if (output != null) {
            try {
                output.closeOutputStream();
            }
            catch (IOException e) {
                log.warn((Object)("Error closing output stream " + output), (Throwable)e);
            }
        }
    }
}

