/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.engines.internal.workers;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.VersionControlClient;
import com.microsoft.tfs.core.clients.versioncontrol.WebServiceLevel;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.AsyncCheckinOperation;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.workers.Worker;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.workers.WorkerStatus;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.VersionControlException;
import com.microsoft.tfs.core.clients.versioncontrol.internal.httpclient.CancellableChunkPart;
import com.microsoft.tfs.core.clients.versioncontrol.internal.httpclient.CancellableFilePart;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingChange;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.config.EnvironmentVariables;
import com.microsoft.tfs.core.exceptions.internal.CoreCancelException;
import com.microsoft.tfs.core.httpclient.methods.PostMethod;
import com.microsoft.tfs.core.httpclient.methods.multipart.MultipartRequestEntity;
import com.microsoft.tfs.core.httpclient.methods.multipart.Part;
import com.microsoft.tfs.core.httpclient.methods.multipart.StringPart;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.base64.Base64;
import com.microsoft.tfs.util.tasks.FileProcessingProgressMonitorAdapter;
import com.microsoft.tfs.util.tasks.TaskMonitor;
import com.microsoft.tfs.util.tasks.TaskMonitorService;
import com.microsoft.tfs.util.temp.TempStorageService;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.text.MessageFormat;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CheckinWorker
implements Worker {
    private static final Log log = LogFactory.getLog(CheckinWorker.class);
    private final TaskMonitor userCancellationMonitor;
    private final VersionControlClient client;
    private final Workspace workspace;
    private final PendingChange change;
    private final byte[] localMD5Hash;
    private final AsyncCheckinOperation state;
    private static final int GZIP_COMPRESS_READ_BUFFER = 4096;
    private static final int DEFAULT_UPLOAD_CHUNK_SIZE = 0x400000;
    private static final int MAX_CHUNK_SIZE = CheckinWorker.getMaxChunkSize(0x400000);
    private static final int DEFAULT_FILE_RETRY_ATTEMPTS = 2;
    private static final int MAX_FILE_RETRY_ATTEMPTS = CheckinWorker.getRetryAttempts("TF_MAX_FILE_RETRY_ATTEMPTS", 2);
    private static final int DEFAULT_CHUNK_RETRY_ATTEMPTS = 1;
    private static final int MAX_CHUNK_RETRY_ATTEMPTS = CheckinWorker.getRetryAttempts("TF_MAX_CHUNK_RETRY_ATTEMPTS", 1);
    private static final String COMPRESSED = "application/gzip";
    private static final String UNCOMPRESSED = "application/octet-stream";
    private static final String partCharSet = "utf-8";

    public CheckinWorker(TaskMonitor userCancellationMonitor, VersionControlClient client, Workspace workspace, PendingChange change, byte[] localMD5Hash, AsyncCheckinOperation state) {
        this.userCancellationMonitor = userCancellationMonitor;
        this.client = client;
        this.workspace = workspace;
        this.change = change;
        this.localMD5Hash = localMD5Hash;
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkerStatus call() throws Exception {
        try {
            if (this.userCancellationMonitor.isCanceled()) {
                WorkerStatus workerStatus = new WorkerStatus(this, WorkerStatus.FinalState.CANCELED);
                return workerStatus;
            }
            if (this.change.getLocalItem() == null) {
                log.warn((Object)MessageFormat.format("Skipping upload for change {0} because local item is null", this.change.toString()));
            } else {
                this.upload(this.change.getLocalItem(), this.localMD5Hash);
            }
        }
        catch (CoreCancelException e) {
            WorkerStatus workerStatus = new WorkerStatus(this, WorkerStatus.FinalState.CANCELED);
            return workerStatus;
        }
        catch (Throwable t) {
            this.state.setFatalError(t);
            WorkerStatus workerStatus = new WorkerStatus(this, WorkerStatus.FinalState.ERROR);
            return workerStatus;
        }
        finally {
            try {
                TempStorageService.getInstance().cleanUpItem(new File(this.change.getLocalItem()));
            }
            catch (Throwable t) {
                log.error((Object)"Error cleaning up temp file after upload", t);
            }
        }
        return new WorkerStatus(this, WorkerStatus.FinalState.NORMAL);
    }

    private void upload(String uncompressedSourceFile, byte[] md5Hash) throws CoreCancelException {
        Check.notNullOrEmpty(uncompressedSourceFile, "uncompressedSourceFile");
        Check.notNull(md5Hash, "md5Hash");
        File compressedFile = null;
        try {
            String contentType;
            File uploadFile;
            Part[] parts = new Part[7];
            parts[0] = new StringPart("item", this.change.getServerItem(), partCharSet);
            parts[1] = new StringPart("wsname", this.workspace.getName(), partCharSet);
            parts[2] = new StringPart("wsowner", this.workspace.getOwnerName(), partCharSet);
            long uncompressedFileLength = new File(uncompressedSourceFile).length();
            parts[3] = new StringPart("filelength", Long.toString(uncompressedFileLength), partCharSet);
            String hashString = new String(Base64.encodeBase64(md5Hash), "US-ASCII");
            parts[4] = new StringPart("hash", hashString, partCharSet);
            if (0L < uncompressedFileLength && uncompressedFileLength < 0xFFFFFFFFL) {
                compressedFile = this.compressToTempFile(uncompressedSourceFile);
            }
            if (compressedFile == null || compressedFile.length() > uncompressedFileLength) {
                uploadFile = new File(uncompressedSourceFile);
                contentType = UNCOMPRESSED;
            } else {
                uploadFile = compressedFile;
                contentType = COMPRESSED;
            }
            int attempt = 0;
            while (true) {
                ++attempt;
                try {
                    if (this.userCancellationMonitor.isCanceled()) {
                        throw new CoreCancelException();
                    }
                    this.retryableUpload(uploadFile, parts, contentType);
                    return;
                }
                catch (SocketException e) {
                    try {
                        log.warn((Object)MessageFormat.format("SocketException during {0} attempt to upload the file {1}", attempt, uncompressedSourceFile), (Throwable)e);
                        if (attempt < MAX_FILE_RETRY_ATTEMPTS) {
                            log.info((Object)"Retrying");
                            continue;
                        }
                        String message = MessageFormat.format(Messages.getString("CheckinEngineUploadWorker.SocketExceptionDuringUploadRetryFormat"), e.getLocalizedMessage());
                        throw new VersionControlException(message, e);
                    }
                    catch (IOException e2) {
                        throw new VersionControlException(e2);
                    }
                }
                break;
            }
        }
        finally {
            if (compressedFile != null && compressedFile.exists()) {
                try {
                    compressedFile.delete();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void retryableUpload(File uploadFile, Part[] parts, String contentType) throws SocketException, CoreCancelException {
        Check.notNull(uploadFile, "uploadFile");
        Check.notNullOrEmpty(parts, "parts");
        Check.notNullOrEmpty(contentType, "contentType");
        PostMethod method = null;
        InputStream fileStream = null;
        BufferedInputStream bufferedStream = null;
        try {
            long uploadFileLength = uploadFile.length();
            long uploadFilePos = 0L;
            boolean aChunkHasBeenRetried = false;
            fileStream = new FileInputStream(uploadFile);
            bufferedStream = new BufferedInputStream(fileStream);
            block22: while (true) {
                CancellableFilePart filePart;
                long chunkSize;
                long bytesLeft = uploadFileLength - uploadFilePos;
                long l = chunkSize = 0 < MAX_CHUNK_SIZE && (long)MAX_CHUNK_SIZE < bytesLeft ? (long)MAX_CHUNK_SIZE : bytesLeft;
                if (chunkSize == uploadFileLength) {
                    filePart = new CancellableFilePart("content", "item", uploadFile, contentType, null);
                    filePart.setCharSet(null);
                } else {
                    bufferedStream.mark(MAX_CHUNK_SIZE);
                    filePart = new CancellableChunkPart(uploadFile, bufferedStream, contentType, chunkSize);
                }
                parts[5] = new StringPart("range", "bytes=" + uploadFilePos + "-" + (uploadFilePos + chunkSize - 1L) + "/" + uploadFile.length() + "\r\n", partCharSet);
                parts[6] = filePart;
                int attempt = 0;
                while (true) {
                    block31: {
                        ++attempt;
                        if (TaskMonitorService.getTaskMonitor().isCanceled()) {
                            throw new CoreCancelException();
                        }
                        try {
                            String messageFormat = MessageFormat.format(Messages.getString("CheckinWorker.UploadFileProgressFormat_SKIPVALIDATE"), this.change.getServerItem());
                            FileProcessingProgressMonitorAdapter monitor = new FileProcessingProgressMonitorAdapter(this.userCancellationMonitor, uploadFilePos, uploadFileLength, messageFormat);
                            TaskMonitorService.pushTaskMonitor(monitor);
                            method = this.client.beginUploadRequest();
                            method.setRequestEntity(new MultipartRequestEntity(parts, method.getParams()));
                            this.client.executeUploadRequest(method);
                            uploadFilePos += chunkSize;
                            if (method == null) break block31;
                        }
                        catch (SocketException e) {
                            if (attempt == MAX_CHUNK_RETRY_ATTEMPTS) throw e;
                            if (chunkSize == uploadFileLength) throw e;
                            if (this.client.getServiceLevel().getValue() < WebServiceLevel.TFS_2012_QU1_1.getValue()) {
                                throw e;
                            }
                            aChunkHasBeenRetried = true;
                            continue;
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                            catch (VersionControlException e2) {
                                if (!aChunkHasBeenRetried) throw e2;
                                throw new SocketException("This version of the TFS Server does not support chunk retrying.");
                            }
                        }
                        finally {
                            if (method != null) {
                                this.client.finishUploadRequest(method);
                            }
                            TaskMonitorService.popTaskMonitor();
                            continue;
                        }
                        this.client.finishUploadRequest(method);
                    }
                    TaskMonitorService.popTaskMonitor();
                    if (uploadFilePos < uploadFileLength) continue block22;
                    return;
                    break;
                }
                break;
            }
        }
        catch (CancellableFilePart.SendDataCancellationException e) {
            throw new CoreCancelException();
        }
        catch (SocketException e) {
            throw e;
        }
        catch (IOException e) {
            throw new VersionControlException(e);
        }
        finally {
            if (bufferedStream != null) {
                try {
                    bufferedStream.close();
                }
                catch (IOException e) {}
            }
            if (fileStream != null) {
                try {
                    fileStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private File compressToTempFile(String sourceFile) throws CoreCancelException {
        Check.notNullOrEmpty(sourceFile, "sourceFile");
        FileInputStream is = null;
        FileOutputStream os = null;
        DeflaterOutputStream gzos = null;
        String messageFormat = MessageFormat.format(Messages.getString("CheckinWorker.CompressFIleProgressFormat_SKIPVALIDATE"), this.change.getServerItem());
        FileProcessingProgressMonitorAdapter monitor = new FileProcessingProgressMonitorAdapter(this.userCancellationMonitor, new File(sourceFile).length(), messageFormat);
        TaskMonitorService.pushTaskMonitor(monitor);
        try {
            File temp = File.createTempFile("teamexplorer", ".tmp");
            String tempFileName = temp.getAbsolutePath();
            is = new FileInputStream(sourceFile);
            os = new FileOutputStream(tempFileName);
            gzos = new GZIPOutputStream(os);
            byte[] buffer = new byte[4096];
            int read = 0;
            while ((read = is.read(buffer)) != -1) {
                if (TaskMonitorService.getTaskMonitor().isCanceled()) {
                    temp.delete();
                    throw new CoreCancelException();
                }
                ((GZIPOutputStream)gzos).write(buffer, 0, read);
                TaskMonitorService.getTaskMonitor().worked(read);
            }
            File file = temp;
            return file;
        }
        catch (IOException e) {
            throw new VersionControlException(e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {}
            try {
                if (gzos != null) {
                    gzos.close();
                }
            }
            catch (IOException e) {}
            TaskMonitorService.popTaskMonitor();
        }
    }

    private static int getMaxChunkSize(int defaultValue) {
        int chunkSize = EnvironmentVariables.getInt("TF_UPLOAD_CHUNK_SIZE", defaultValue);
        if (chunkSize > 2) {
            return chunkSize;
        }
        log.warn((Object)"Chunked upload is disabled");
        return 0;
    }

    private static int getRetryAttempts(String varName, int defaultValue) {
        try {
            return EnvironmentVariables.getInt(varName, defaultValue);
        }
        catch (NumberFormatException e) {
            log.warn((Object)("Wrong numeric value of the environment variable" + varName));
            return defaultValue;
        }
    }
}

