/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.localworkspace;

import com.microsoft.tfs.core.clients.versioncontrol.WorkspaceLocation;
import com.microsoft.tfs.core.clients.versioncontrol.Workstation;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.VersionControlException;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.AllTablesTransaction;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalPendingChangesTable;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalWorkspaceProperties;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalWorkspaceTransaction;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspaceLocalItem;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspacePropertiesLocalVersionTransaction;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspaceVersionTable;
import com.microsoft.tfs.core.clients.versioncontrol.localworkspace.LocalWorkspaceScanner;
import com.microsoft.tfs.core.clients.versioncontrol.localworkspace.PathWatcher;
import com.microsoft.tfs.core.clients.versioncontrol.localworkspace.PathWatcherReport;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.WorkingFolder;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.clients.versioncontrol.sparsetree.EnumParentsOptions;
import com.microsoft.tfs.core.clients.versioncontrol.sparsetree.EnumSubTreeOptions;
import com.microsoft.tfs.core.clients.versioncontrol.sparsetree.SparseTree;
import com.microsoft.tfs.core.exceptions.internal.CoreCancelException;
import com.microsoft.tfs.core.util.notifications.Notification;
import com.microsoft.tfs.util.tasks.CanceledException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;

public class WorkspaceWatcher {
    private final Workspace workspace;
    private boolean isAsynchronous;
    private final Object lock = new Object();
    private final SparseTree<PathWatcher> pathWatchers;
    private PathWatcherReport report;
    private final Set<String> skippedItems;
    private static final boolean ENABLE_PARTIAL_SCANS;
    private static final String ENABLE_PARTIAL_SCANS_PROPERTY_NAME = "com.microsoft.tfs.core.clients.versioncontrol.localworkspace.enablepartialscans";

    public WorkspaceWatcher(Workspace workspace) {
        this.workspace = workspace;
        this.report = new PathWatcherReport(true);
        this.pathWatchers = new SparseTree('\\', (Comparator<String>)String.CASE_INSENSITIVE_ORDER);
        this.skippedItems = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    }

    public boolean isAsynchronous() {
        return this.isAsynchronous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAsynchronous(boolean value) {
        this.isAsynchronous = value;
        if (WorkspaceLocation.LOCAL != this.workspace.getLocation()) {
            return;
        }
        if (value) {
            LocalWorkspaceTransaction transaction = new LocalWorkspaceTransaction(this.workspace);
            try {
                transaction.execute(new WorkspacePropertiesLocalVersionTransaction(){

                    @Override
                    public void invoke(LocalWorkspaceProperties wp, WorkspaceVersionTable lv) {
                        WorkspaceWatcher.this.updatePathWatchers(wp, lv);
                    }
                });
            }
            finally {
                try {
                    transaction.close();
                }
                catch (Exception e) {
                    throw new VersionControlException(e);
                }
            }
            Object e = this.lock;
            synchronized (e) {
                for (PathWatcher pathWatcher : this.pathWatchers.EnumSubTreeReferencedObjects(null, EnumSubTreeOptions.NONE, Integer.MAX_VALUE)) {
                    if (pathWatcher.isWatching()) continue;
                    pathWatcher.startWatching();
                }
            }
        }
        Object object = this.lock;
        synchronized (object) {
            for (PathWatcher pathWatcher : this.pathWatchers.EnumSubTreeReferencedObjects(null, EnumSubTreeOptions.NONE, Integer.MAX_VALUE)) {
                if (!pathWatcher.isWatching()) continue;
                pathWatcher.stopWatching();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void locationChanged() {
        if (WorkspaceLocation.LOCAL == this.workspace.getLocation()) {
            Object object = this.lock;
            synchronized (object) {
                this.report = new PathWatcherReport(true);
            }
        }
        Object object = this.lock;
        synchronized (object) {
            for (PathWatcher pathWatcher : this.pathWatchers.EnumSubTreeReferencedObjects(null, EnumSubTreeOptions.NONE, Integer.MAX_VALUE)) {
                if (!pathWatcher.isWatching()) continue;
                pathWatcher.stopWatching();
            }
            this.pathWatchers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopWatching() {
        if (WorkspaceLocation.LOCAL != this.workspace.getLocation()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            for (PathWatcher pathWatcher : this.pathWatchers.EnumSubTreeReferencedObjects(null, EnumSubTreeOptions.NONE, Integer.MAX_VALUE)) {
                if (!pathWatcher.isWatching()) continue;
                pathWatcher.stopWatching();
            }
            this.pathWatchers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureWatching() {
        if (WorkspaceLocation.LOCAL != this.workspace.getLocation()) {
            return;
        }
        if (this.isAsynchronous) {
            Object object = this.lock;
            synchronized (object) {
                for (PathWatcher pathWatcher : this.pathWatchers.EnumSubTreeReferencedObjects(null, EnumSubTreeOptions.NONE, Integer.MAX_VALUE)) {
                    if (pathWatcher.isWatching()) continue;
                    pathWatcher.startWatching();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void workingFoldersChanged(WorkingFolder[] workingFolders) {
        if (WorkspaceLocation.LOCAL != this.workspace.getLocation()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            for (String workspaceRoot : WorkingFolder.getWorkspaceRoots(workingFolders)) {
                if (this.pathWatchers.EnumParents(workspaceRoot, EnumParentsOptions.NONE).iterator().hasNext()) continue;
                this.pathWatchers.remove(workspaceRoot, true);
                PathWatcher toAdd = this.newPathWatcher(workspaceRoot);
                if (this.isAsynchronous) {
                    toAdd.startWatching();
                }
                this.pathWatchers.add(workspaceRoot, toAdd);
            }
            this.report.fullyInvalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markPathChanged(String path) {
        if (WorkspaceLocation.LOCAL != this.workspace.getLocation()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (path == null || path.length() == 0) {
                this.report.fullyInvalidate();
            } else {
                this.report.addChangedPath(path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceFullScan() throws IOException {
        LocalWorkspaceTransaction transaction = new LocalWorkspaceTransaction(this.workspace);
        try {
            transaction.execute(new AllTablesTransaction(){

                @Override
                public void invoke(LocalWorkspaceProperties wp, WorkspaceVersionTable lv, LocalPendingChangesTable pc) {
                    WorkspaceWatcher.this.report.fullyInvalidate();
                    WorkspaceWatcher.this.scan(wp, lv, pc);
                }
            });
        }
        finally {
            transaction.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan(LocalWorkspaceProperties wp, WorkspaceVersionTable lv, LocalPendingChangesTable pc) {
        PathWatcherReport report;
        this.updatePathWatchers(wp, lv);
        Object object = this.lock;
        synchronized (object) {
            report = this.poll();
            report.unionWith(this.report);
            this.report = new PathWatcherReport(false);
        }
        if (!report.isNothingChanged()) {
            LocalWorkspaceScanner scanner;
            Set<String> set = this.skippedItems;
            synchronized (set) {
                scanner = new LocalWorkspaceScanner(wp, lv, pc, this.skippedItems);
            }
            try {
                if (report.getFullyInvalidated() || !ENABLE_PARTIAL_SCANS) {
                    scanner.fullScan();
                } else {
                    scanner.partialScan(report.getChangedPaths());
                }
            }
            catch (CoreCancelException e) {
                throw new CanceledException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isScanNecessary() {
        if (WorkspaceLocation.LOCAL != this.workspace.getLocation()) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            this.report.unionWith(this.poll());
            return !this.report.isNothingChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSkippedItem(String localItem) {
        if (WorkspaceLocation.LOCAL != this.workspace.getLocation()) {
            return;
        }
        Set<String> set = this.skippedItems;
        synchronized (set) {
            this.skippedItems.add(localItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pathChanged(PathWatcher sender) {
        if (this.isScanNecessary()) {
            final AtomicBoolean raiseCrossProcessNotification = new AtomicBoolean();
            LocalWorkspaceTransaction transaction = new LocalWorkspaceTransaction(this.workspace);
            try {
                transaction.execute(new AllTablesTransaction(){

                    @Override
                    public void invoke(LocalWorkspaceProperties wp, WorkspaceVersionTable lv, LocalPendingChangesTable pc) {
                        WorkspaceWatcher.this.scan(wp, lv, pc);
                        if (lv.isDirty() || pc.isDirty()) {
                            raiseCrossProcessNotification.set(true);
                        }
                    }
                });
            }
            finally {
                try {
                    transaction.close();
                }
                catch (Exception e) {
                    throw new VersionControlException(e);
                }
            }
            if (raiseCrossProcessNotification.get()) {
                Workstation.getCurrent(this.workspace.getClient().getConnection().getPersistenceStoreProvider()).notifyForWorkspace(this.workspace, Notification.VERSION_CONTROL_LOCAL_WORKSPACE_SCAN);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSkippedItem(String localItem) {
        if (WorkspaceLocation.LOCAL != this.workspace.getLocation()) {
            return;
        }
        Set<String> set = this.skippedItems;
        synchronized (set) {
            this.skippedItems.remove(localItem);
        }
    }

    private PathWatcherReport poll() {
        PathWatcherReport toReturn = new PathWatcherReport(false);
        for (PathWatcher pathWatcher : this.pathWatchers.EnumSubTreeReferencedObjects(null, EnumSubTreeOptions.NONE, Integer.MAX_VALUE)) {
            if (!pathWatcher.isWatching()) {
                pathWatcher.startWatching();
            }
            toReturn.unionWith(pathWatcher.poll());
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePathWatchers(LocalWorkspaceProperties wp, WorkspaceVersionTable lv) {
        SparseTree<String> newRoots = new SparseTree<String>('\\', (Comparator<String>)String.CASE_INSENSITIVE_ORDER);
        for (String workingFolderRoot : WorkingFolder.getWorkspaceRoots(wp.getWorkingFolders())) {
            newRoots.add(workingFolderRoot, workingFolderRoot);
        }
        for (WorkspaceLocalItem lvEntry : lv.queryLocalItemRoots()) {
            if (newRoots.EnumParents(lvEntry.getLocalItem(), EnumParentsOptions.NONE).iterator().hasNext()) continue;
            newRoots.remove(lvEntry.getLocalItem(), true);
            newRoots.add(lvEntry.getLocalItem(), lvEntry.getLocalItem());
        }
        Object object = this.lock;
        synchronized (object) {
            for (String newRoot : newRoots.EnumSubTreeReferencedObjects(null, EnumSubTreeOptions.NONE, Integer.MAX_VALUE)) {
                PathWatcher pathWatcher = this.pathWatchers.get(newRoot);
                if (pathWatcher != null) continue;
                this.pathWatchers.add(newRoot, this.newPathWatcher(newRoot));
            }
            ArrayList<String> toRemove = new ArrayList<String>();
            for (PathWatcher pathWatcher : this.pathWatchers.EnumSubTreeReferencedObjects(null, EnumSubTreeOptions.NONE, Integer.MAX_VALUE)) {
                if (newRoots.get(pathWatcher.getPath()) != null) continue;
                toRemove.add(pathWatcher.getPath());
            }
            for (String path : toRemove) {
                this.pathWatchers.remove(path, false);
            }
        }
    }

    private PathWatcher newPathWatcher(String path) {
        return this.workspace.getClient().getPathWatcherFactory().newPathWatcher(path, this);
    }

    static {
        String propValue = System.getProperty(ENABLE_PARTIAL_SCANS_PROPERTY_NAME);
        ENABLE_PARTIAL_SCANS = propValue == null || !propValue.equalsIgnoreCase("false");
    }
}

