/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.link;

import com.microsoft.tfs.core.artifact.ArtifactID;
import com.microsoft.tfs.core.clients.workitem.internal.link.LinkImpl;
import com.microsoft.tfs.core.clients.workitem.link.ExternalLink;
import com.microsoft.tfs.core.clients.workitem.link.Link;
import com.microsoft.tfs.core.clients.workitem.link.RegisteredLinkType;
import com.microsoft.tfs.util.xml.DOMUtils;
import java.text.MessageFormat;
import org.w3c.dom.Element;

public class ExternalLinkImpl
extends LinkImpl
implements ExternalLink {
    private final String uri;

    public ExternalLinkImpl(RegisteredLinkType linkType, String uri, String comment, int extId, boolean newComponent, boolean readOnly) {
        super(linkType, comment, extId, newComponent, readOnly);
        if ("Related Workitem".equals(linkType.getName()) || "Workitem Hyperlink".equals(linkType.getName())) {
            throw new IllegalArgumentException(MessageFormat.format("the link type [{0}] is not valid for ExternalLinks", linkType.getName()));
        }
        if (uri == null || uri.trim().length() == 0) {
            throw new IllegalArgumentException("uri must not be null or empty");
        }
        this.uri = uri.trim();
    }

    @Override
    public LinkImpl cloneLink() {
        return new ExternalLinkImpl(this.getLinkType(), this.uri, this.getComment(), -1, true, this.isReadOnly());
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    @Override
    public boolean isEquivalent(Link link) {
        if (link instanceof ExternalLinkImpl) {
            ExternalLinkImpl other = (ExternalLinkImpl)link;
            return this.uri.equalsIgnoreCase(other.uri);
        }
        return false;
    }

    @Override
    public ArtifactID getArtifactID() {
        return new ArtifactID(this.uri);
    }

    @Override
    protected String getFallbackDescription() {
        ArtifactID id = this.getArtifactID();
        StringBuilder description = new StringBuilder(id.getArtifactType());
        description.append(" ");
        if (id.getArtifactType().equalsIgnoreCase("commit")) {
            String toolSpecificId = id.getToolSpecificID();
            String commitId = toolSpecificId.substring(toolSpecificId.lastIndexOf(47) + 1);
            description.append(commitId);
        } else {
            description.append(id.getToolSpecificID());
        }
        return description.toString();
    }

    @Override
    protected void createXMLForAdd(Element parentElement) {
        Element element = DOMUtils.appendChild(parentElement, "InsertResourceLink");
        element.setAttribute("FieldName", "System.BISLinks");
        element.setAttribute("LinkType", this.getLinkType().getName());
        element.setAttribute("Location", this.uri);
        if (this.getComment() != null && this.getComment().trim().length() > 0) {
            element.setAttribute("Comment", this.getComment().trim());
        }
    }

    @Override
    protected void createXMLForRemove(Element parentElement) {
        Element element = DOMUtils.appendChild(parentElement, "RemoveResourceLink");
        element.setAttribute("LinkID", String.valueOf(this.getExtID()));
    }

    @Override
    protected String getInsertTagName() {
        return "InsertResourceLink";
    }
}

