/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.project;

import com.microsoft.tfs.core.clients.workitem.WorkItemClient;
import com.microsoft.tfs.core.clients.workitem.category.Category;
import com.microsoft.tfs.core.clients.workitem.category.CategoryCollection;
import com.microsoft.tfs.core.clients.workitem.category.CategoryMemberCollection;
import com.microsoft.tfs.core.clients.workitem.internal.WITContext;
import com.microsoft.tfs.core.clients.workitem.internal.category.CategoryCollectionImpl;
import com.microsoft.tfs.core.clients.workitem.internal.category.CategoryMemberCollectionImpl;
import com.microsoft.tfs.core.clients.workitem.internal.node.NodeCollectionImpl;
import com.microsoft.tfs.core.clients.workitem.internal.node.NodeImpl;
import com.microsoft.tfs.core.clients.workitem.internal.query.StoredQueryCollectionImpl;
import com.microsoft.tfs.core.clients.workitem.internal.wittype.WorkItemTypeCollectionImpl;
import com.microsoft.tfs.core.clients.workitem.node.Node;
import com.microsoft.tfs.core.clients.workitem.node.NodeCollection;
import com.microsoft.tfs.core.clients.workitem.project.Project;
import com.microsoft.tfs.core.clients.workitem.project.ProjectModificationEvent;
import com.microsoft.tfs.core.clients.workitem.project.ProjectModificationListener;
import com.microsoft.tfs.core.clients.workitem.query.StoredQueryCollection;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.QueryHierarchy;
import com.microsoft.tfs.core.clients.workitem.wittype.WorkItemType;
import com.microsoft.tfs.core.clients.workitem.wittype.WorkItemTypeCollection;
import com.microsoft.tfs.util.GUID;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;

public class ProjectImpl
implements Project {
    private final NodeImpl node;
    private WorkItemTypeCollectionImpl workItemTypeCollection;
    private StoredQueryCollectionImpl storedQueryCollection;
    private CategoryCollectionImpl categoryCollection;
    private CategoryMemberCollectionImpl categoryMemberCollection;
    private WorkItemType[] visibleWorkItemTypes;
    private NodeCollectionImpl areaRootNodes;
    private NodeCollectionImpl iterationRootNodes;
    private final WITContext witContext;
    private final ArrayList<ProjectModificationListener> projectModificationListeners = new ArrayList();

    public ProjectImpl(NodeImpl node, WITContext witContext) {
        this.node = node;
        this.witContext = witContext;
    }

    public String toString() {
        return MessageFormat.format("project: {0}/{1}", Integer.toString(this.node.getID()), this.node.getName());
    }

    @Override
    public int compareTo(Project other) {
        return this.getName().compareToIgnoreCase(other.getName());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ProjectImpl) {
            ProjectImpl other = (ProjectImpl)obj;
            return other.witContext == this.witContext && other.getID() == this.getID();
        }
        return false;
    }

    public int hashCode() {
        return this.witContext.hashCode() + this.getID();
    }

    @Override
    public synchronized NodeCollection getAreaRootNodes() {
        if (this.areaRootNodes == null) {
            NodeImpl areaChildNode = this.node.findFirstChildOfStructureType(1);
            this.areaRootNodes = areaChildNode.getChildNodesInternal();
        }
        return this.areaRootNodes;
    }

    @Override
    public synchronized NodeCollection getIterationRootNodes() {
        if (this.iterationRootNodes == null) {
            NodeImpl iterationChildNode = this.node.findFirstChildOfStructureType(2);
            this.iterationRootNodes = iterationChildNode.getChildNodesInternal();
        }
        return this.iterationRootNodes;
    }

    @Override
    public int getID() {
        return this.node.getID();
    }

    @Override
    public GUID getGUID() {
        return this.node.getGUID();
    }

    @Override
    public String getName() {
        return this.node.getName();
    }

    @Override
    public String getURI() {
        return this.node.getURI();
    }

    @Override
    public synchronized WorkItemTypeCollection getWorkItemTypes() {
        if (this.workItemTypeCollection == null) {
            this.workItemTypeCollection = new WorkItemTypeCollectionImpl(this, this.witContext);
        }
        return this.workItemTypeCollection;
    }

    @Override
    public synchronized WorkItemType[] getVisibleWorkItemTypes() {
        if (this.visibleWorkItemTypes == null) {
            if (!this.witContext.getServerInfo().isSupported("WorkItemTypeCategoryMembers") || !this.getCategories().contains("Microsoft.HiddenCategory")) {
                this.visibleWorkItemTypes = this.getWorkItemTypes().getTypes();
            } else {
                Category hiddenCategory = this.getCategories().get("Microsoft.HiddenCategory");
                WorkItemType[] hiddenTypes = this.getCategoryMembers().getCategoryMembers(hiddenCategory.getID());
                HashSet<Integer> hiddenTypeIDs = new HashSet<Integer>();
                if (hiddenTypes != null) {
                    for (WorkItemType hiddenType : hiddenTypes) {
                        hiddenTypeIDs.add(hiddenType.getID());
                    }
                }
                ArrayList<WorkItemType> list = new ArrayList<WorkItemType>();
                for (WorkItemType type : this.getWorkItemTypes()) {
                    if (hiddenTypeIDs.contains(type.getID())) continue;
                    list.add(type);
                }
                this.visibleWorkItemTypes = list.toArray(new WorkItemType[list.size()]);
            }
        }
        return this.visibleWorkItemTypes;
    }

    @Override
    public synchronized StoredQueryCollection getStoredQueries() {
        if (this.storedQueryCollection == null) {
            this.storedQueryCollection = new StoredQueryCollectionImpl(this, this.witContext);
        }
        return this.storedQueryCollection;
    }

    @Override
    public QueryHierarchy getQueryHierarchy() {
        return this.witContext.getQueryHierarchyProvider().getQueryHierarchy(this);
    }

    @Override
    public synchronized StoredQueryCollection getAndRefreshStoredQueries() {
        if (this.storedQueryCollection == null) {
            return this.getStoredQueries();
        }
        this.storedQueryCollection.refresh();
        return this.storedQueryCollection;
    }

    @Override
    public synchronized CategoryCollection getCategories() {
        if (this.categoryCollection == null) {
            this.categoryCollection = new CategoryCollectionImpl(this.getWITContext(), this.getID());
        }
        return this.categoryCollection;
    }

    @Override
    public synchronized CategoryMemberCollection getCategoryMembers() {
        if (this.categoryMemberCollection == null) {
            this.categoryMemberCollection = new CategoryMemberCollectionImpl(this.getWITContext(), this.getWorkItemTypes());
        }
        return this.categoryMemberCollection;
    }

    @Override
    public Object resolvePath(String path, Node.TreeType treeType) {
        if (path == null) {
            return null;
        }
        int structureType = treeType == Node.TreeType.AREA ? 1 : 2;
        NodeImpl targetNode = this.node.findNodeDownwards(path, true, structureType);
        if (targetNode == this.node) {
            return this;
        }
        return targetNode;
    }

    @Override
    public boolean addProjectModificationListener(ProjectModificationListener listener) {
        return this.projectModificationListeners.add(listener);
    }

    @Override
    public boolean removeProjectModificationListener(ProjectModificationListener listener) {
        return this.projectModificationListeners.remove(listener);
    }

    @Override
    public void notifyModicationListeners() {
        ProjectModificationEvent event = new ProjectModificationEvent(this);
        for (ProjectModificationListener listener : this.projectModificationListeners) {
            listener.onModification(event);
        }
    }

    @Override
    public WorkItemClient getWorkItemClient() {
        return this.witContext.getClient();
    }

    @Override
    public WITContext getWITContext() {
        return this.witContext;
    }

    @Override
    public void clearCachedWITMetadata() {
        this.areaRootNodes = null;
        this.iterationRootNodes = null;
        this.workItemTypeCollection = null;
        this.categoryCollection = null;
        this.categoryMemberCollection = null;
        this.visibleWorkItemTypes = null;
    }

    public NodeImpl getAreaRootNode() {
        return this.node.findFirstChildOfStructureType(1);
    }

    public NodeImpl getNodeInternal() {
        return this.node;
    }
}

